/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.impressao;

import br.gov.serpro.gcap.entidades.psocietarias.OperacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.psocietarias.ParcelaAquisicaoParticipacaoSocietaria;
import br.gov.serpro.gcap.impressao.pojo.OperacaoParticipacaoSocietariaRelatorio;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import serpro.ppgd.formatosexternos.RelatorioMultiploXML;
import serpro.ppgd.formatosexternos.RelatorioXML;

public class RelatorioPlanilhaCustoAquisicao {
    private static final String NOME_RELATORIO = "relPlanilhaCustoAquisicao.jasper";
    private static final String TITULO_RELATORIO = "Planilha - Apura\u00e7\u00e3o do Custo de Aquisi\u00e7\u00e3o";
    private ParcelaAquisicaoParticipacaoSocietaria parcela;
    RelatorioMultiploXML relatorio;

    public void imprimir() {
        this.preparar();
        this.relatorio.imprimir();
    }

    public void visualizar() {
        this.preparar();
        this.relatorio.visualizar();
    }

    public void gerarPDF() {
        this.preparar();
        this.relatorio.gerarPDF();
    }

    public RelatorioPlanilhaCustoAquisicao(ParcelaAquisicaoParticipacaoSocietaria parcela) {
        this.parcela = parcela;
    }

    protected void preparar() {
        String lNomeArquivoPdfGerado = "planilha" + new Date().getTime() + ".pdf";
        this.relatorio = new RelatorioMultiploXML(TITULO_RELATORIO, NOME_RELATORIO, "", "/classe", lNomeArquivoPdfGerado);
        ArrayList<RelatorioXML> lRelatorios = new ArrayList<RelatorioXML>();
        RelatorioXML lRelatorio = new RelatorioXML(TITULO_RELATORIO, NOME_RELATORIO, "", "/classe");
        lRelatorio.addParametro("SUBREPORT_DIR", "");
        lRelatorio.addParametro("custoMedioPonderadoUnitario", this.parcela.getParticipacaoSocietariaAlienada().getOperacoesParticipacaoSocietaria().getUltimoCustoMedioTransportado().formatado());
        lRelatorio.addParametro("colecaoCustoAquisicaoPlanilha", this.obterListaCustoAquisicaoPlanilha());
        lRelatorios.add(lRelatorio);
        this.relatorio.setRelatorios(lRelatorios);
    }

    private Collection<OperacaoParticipacaoSocietariaRelatorio> obterListaCustoAquisicaoPlanilha() {
        ArrayList<OperacaoParticipacaoSocietariaRelatorio> lRetorno = new ArrayList<OperacaoParticipacaoSocietariaRelatorio>();
        for (OperacaoParticipacaoSocietaria operacao : this.parcela.getParticipacaoSocietariaAlienada().getOperacoesParticipacaoSocietaria().itens()) {
            lRetorno.add(new OperacaoParticipacaoSocietariaRelatorio(operacao));
        }
        return lRetorno;
    }
}

