/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.impressao;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.consolidacao.Consolidacao;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.ObjetoNegocio;

public class RelatorioUtil {
    private static RelatorioUtil relatorioUtil = new RelatorioUtil();

    private RelatorioUtil() {
    }

    public static RelatorioUtil getInstancia() {
        return relatorioUtil;
    }

    public Consolidacao getConsolidacaoDemonstrativo(DemonstrativoGCAP pDemonstrativo) {
        Consolidacao lConsolidacaoRetorno = this.obterTodasConsolidacoes(pDemonstrativo);
        return lConsolidacaoRetorno;
    }

    private Consolidacao obterTodasConsolidacoes(DemonstrativoGCAP pDemonstrativo) {
        List<ObjetoNegocio> lLista = this.obterTodosBens(pDemonstrativo);
        Consolidacao lConsolidacaoSomatorio = new Consolidacao();
        ValorPositivo impostoTotal = new ValorPositivo();
        for (ObjetoNegocio objNegocio : lLista) {
            Alienacao lBem = (Alienacao)objNegocio;
            Consolidacao lConsolidacaoItem = lBem.getConsolidacao();
            lConsolidacaoSomatorio.getImpostoDiferidoAnosAnteriores().append('+', lConsolidacaoItem.getImpostoDiferidoAnosAnteriores());
            lConsolidacaoSomatorio.getImpostoReferenteAlienacaoAnoAtual().append('+', lConsolidacaoItem.getImpostoReferenteAlienacaoAnoAtual());
            impostoTotal.append('+', lConsolidacaoItem.getImpostoDiferidoAnosAnteriores().operacao('+', lConsolidacaoItem.getImpostoReferenteAlienacaoAnoAtual()));
            lConsolidacaoSomatorio.getImpostoDevidoAnoAtual().append('+', lConsolidacaoItem.getImpostoDevidoAnoAtual());
            lConsolidacaoSomatorio.getImpostoDiferidoAnosPosteriores().append('+', lConsolidacaoItem.getImpostoDiferidoAnosPosteriores());
            lConsolidacaoSomatorio.getTotalImpostoPago().append('+', lConsolidacaoItem.getTotalImpostoPago());
            lConsolidacaoSomatorio.getTotalRendIsentosNaoTributaveis().append('+', lConsolidacaoItem.getTotalRendIsentosNaoTributaveis());
            lConsolidacaoSomatorio.getTotalRendSujeitosTributacao().append('+', lConsolidacaoItem.getTotalRendSujeitosTributacao());
            lConsolidacaoSomatorio.getValorIRF().append('+', lConsolidacaoItem.getValorIRF());
        }
        lConsolidacaoSomatorio.getImpostoTotal().setConteudo(impostoTotal);
        return lConsolidacaoSomatorio;
    }

    private List<ObjetoNegocio> obterTodosBens(DemonstrativoGCAP pDemonstrativo) {
        ArrayList<ObjetoNegocio> lLista = new ArrayList<ObjetoNegocio>();
        lLista.addAll(pDemonstrativo.getBensMoveis().itens());
        return lLista;
    }

    public Boolean exibirPerguntaBemPequenoValor(AlienacaoBemMovel alienacaoBemMovel) {
        boolean retorno = false;
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        if (alienacaoBemMovel.getBemMovel().isAdquiridoNoBrasil()) {
            valorAlienacaoReal.setConteudo(alienacaoBemMovel.getValorAlienacao());
        } else {
            valorAlienacaoReal.setConteudo(alienacaoBemMovel.getValorAlienacaoDolar().operacao('*', alienacaoBemMovel.getCotacaoDolarDataAlienacao()));
        }
        if (valorAlienacaoReal.comparacao("<=", alienacaoBemMovel.getValorIsencaoAsString()) && AplicacaoPropertiesUtil.getExercicio().equals(alienacaoBemMovel.getDataAlienacao().getAno())) {
            retorno = true;
        }
        return retorno;
    }

    public static String getPerguntaConfirmacaoValorAlienacaoVersusLimiteIsencao(Data pData, String pValor) {
        String lMesAnoAlienacao = "";
        if (!pData.isVazio() && pData.isValido()) {
            lMesAnoAlienacao = pData.formatado().substring(3);
        }
        if (pData.isVazio()) {
            lMesAnoAlienacao = "m\u00eas/ano";
        }
        return MensagemUtil.getMensagem("ConfirmaValorBensMes", new String[]{lMesAnoAlienacao, pValor});
    }
}

