/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.impressao.pojo;

import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.consolidacao.Consolidacao;

public class ConsolidacaoRelatorio {
    private Consolidacao consolidacao;
    private String titulo;

    public ConsolidacaoRelatorio(Alienacao pBem) {
        this.consolidacao = pBem.getConsolidacao();
        this.configuraTitulo(pBem);
    }

    public ConsolidacaoRelatorio(Consolidacao itemDadosConsolidacao) {
        this.consolidacao = itemDadosConsolidacao;
        this.configuraTituloGeral();
    }

    private void configuraTituloGeral() {
        this.titulo = "CONSOLIDA\u00c7\u00c3O GERAL";
    }

    private void configuraTitulo(Alienacao pBem) {
        this.titulo = pBem instanceof AlienacaoParticipacaoSocietaria ? "CONSOLIDA\u00c7\u00c3O DAS PARTICIPA\u00c7\u00d5ES SOCIET\u00c1RIAS" : (pBem instanceof AlienacaoBemMovel ? (((AlienacaoBemMovel)pBem).getBemMovel().isAdquiridoNoBrasil() ? "CONSOLIDA\u00c7\u00c3O DO BEM M\u00d3VEL NO BRASIL" : "CONSOLIDA\u00c7\u00c3O DO BEM M\u00d3VEL NO EXTERIOR") : "CONSOLIDA\u00c7\u00c3O DO BEM IM\u00d3VEL");
    }

    public String getTitulo() {
        return this.titulo;
    }

    public String getPagarDiferidoAnosAnteriores() {
        return this.consolidacao.getImpostoDiferidoAnosAnteriores().formatado();
    }

    public String getPagarReferenteExercicio() {
        return this.consolidacao.getImpostoReferenteAlienacaoAnoAtual().formatado();
    }

    public String getPagarTotal() {
        return this.consolidacao.getImpostoTotal().formatado();
    }

    public String getPagarDevidoReferenteExercicio() {
        return this.consolidacao.getImpostoDevidoAnoAtual().formatado();
    }

    public String getPagarDiferidoAnosPosteriores() {
        return this.consolidacao.getImpostoDiferidoAnosPosteriores().formatado();
    }

    public String getPagoTotal() {
        return this.consolidacao.getTotalImpostoPago().formatado();
    }

    public String getIsentoTotal() {
        return this.consolidacao.getTotalRendIsentosNaoTributaveis().formatado();
    }

    public String getIRNaFonte() {
        return this.consolidacao.getValorIRF().formatado();
    }

    public String getExclusivaTotal() {
        return this.consolidacao.getTotalRendSujeitosTributacao().formatado();
    }
}

