/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.negocio;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.util.Validador;

public class CalculoImpostoDevidoUtil {
    private static final TabelaImposto[] tabelasImposto = new TabelaImposto[]{new TabelaImposto("01/01/2017", new String[][]{{"30000000,00", "0,225000000"}, {"10000000,00", "0,200000000"}, {"5000000,00", "0,175000000"}, {"0,00", "0,150000000"}}), new TabelaImposto("01/01/1900", new String[][]{{"0,00", "0,150000000"}})};

    public static ValorPositivo[] calcularFaixasDeImpostoDevido(ValorPositivo resultadoLiquido) {
        ValorPositivo[] parteFaixas = new ValorPositivo[4];
        for (int i = 0; i < parteFaixas.length; ++i) {
            parteFaixas[i] = new ValorPositivo(null, "Parte do Imposto sobre Faixa", 13, 6);
        }
        if (resultadoLiquido.comparacao("<=", "5000000,00")) {
            parteFaixas[0].setConteudo(resultadoLiquido);
        } else {
            parteFaixas[0].setConteudo("5000000,00");
            if (resultadoLiquido.comparacao("<=", "10000000,00")) {
                parteFaixas[1].setConteudo(resultadoLiquido);
                parteFaixas[1].append('-', "5000000,00");
            } else {
                parteFaixas[1].setConteudo("10000000,00");
                parteFaixas[1].append('-', "5000000,00");
                if (resultadoLiquido.comparacao("<=", "30000000,00")) {
                    parteFaixas[2].setConteudo(resultadoLiquido);
                    parteFaixas[2].append('-', "10000000,00");
                } else {
                    parteFaixas[2].setConteudo("30000000,00");
                    parteFaixas[2].append('-', "10000000,00");
                    parteFaixas[3].setConteudo(resultadoLiquido);
                    parteFaixas[3].append('-', "30000000,00");
                }
            }
        }
        return parteFaixas;
    }

    public static ValorPositivo calcularAliquotaEfetivaDeImposto(ValorPositivo resultadoLiquido, ValorPositivo impostoDevido) {
        ValorPositivo aliquotaEfetiva = new ValorPositivo(null, "Al\u00edquota M\u00e9dia", 3, 9);
        if (resultadoLiquido.comparacao(">", "0,00")) {
            aliquotaEfetiva.setConteudo(impostoDevido);
            aliquotaEfetiva.append('*', "100");
            aliquotaEfetiva.append('/', resultadoLiquido);
            if (aliquotaEfetiva.comparacao("<", "15,00")) {
                aliquotaEfetiva.setConteudo("15,000000");
            }
        } else {
            aliquotaEfetiva.setConteudo(0L);
        }
        aliquotaEfetiva.setConteudo(aliquotaEfetiva);
        aliquotaEfetiva.converteQtdCasasDecimais(6);
        return aliquotaEfetiva;
    }

    public static TabelaImposto[] getTabelasImposto() {
        return tabelasImposto;
    }

    public static String[][] getTabelaImposto(Data dataAlienacao) {
        TabelaImposto[] tabelasImposto = CalculoImpostoDevidoUtil.getTabelasImposto();
        for (int i = 0; i < tabelasImposto.length; ++i) {
            if (dataAlienacao.maisAntiga(tabelasImposto[i].getDataInicioVigencia())) continue;
            return tabelasImposto[i].getTabela();
        }
        return new String[0][];
    }

    public static ValorPositivo calcularImpostoDevido(ValorPositivo ganhoCapital, Data dataAlienacao) {
        return CalculoImpostoDevidoUtil.calcularImpostoDevido(ganhoCapital, CalculoImpostoDevidoUtil.getTabelaImposto(dataAlienacao));
    }

    public static ValorPositivo calcularImpostoDevido(ValorPositivo ganhoCapital, String[][] tabelaImposto) {
        ValorPositivo tributavel = new ValorPositivo(null, "tributavel", 11, 9);
        tributavel.append('+', ganhoCapital);
        ValorPositivo imposto = new ValorPositivo(null, "imposto", 11, 9);
        for (int i = 0; i < tabelaImposto.length && tributavel.comparacao(">", "0,00"); ++i) {
            if (!tributavel.comparacao(">", tabelaImposto[i][0])) continue;
            ValorPositivo faixa = new ValorPositivo(null, "faixa", 11, 9);
            faixa.append('+', tributavel);
            faixa.append('-', tabelaImposto[i][0]);
            faixa.append('*', tabelaImposto[i][1]);
            imposto.append('+', faixa);
            tributavel.setConteudo(tabelaImposto[i][0]);
        }
        return imposto;
    }

    public static ValorPositivo calcularImpostoDevidoAliquotaFixa(ValorPositivo ganhoCapital, String aliquota) {
        ValorPositivo imposto = new ValorPositivo();
        imposto.setConteudo(ganhoCapital);
        imposto.append('*', aliquota);
        return imposto;
    }

    public static ValorPositivo calcularPercentualReducaoLei7713(Data dataAquisicao) {
        ValorPositivo percentual = new ValorPositivo(null, "Percentual de Reducao", 11, 6);
        try {
            if (dataAquisicao != null && Validador.validarData((String)dataAquisicao.formatado()) == null) {
                ValorPositivo anoLei7713 = new ValorPositivo(null, "", 11, 6);
                anoLei7713.setConteudo("1989");
                ValorPositivo anoAquisicao = new ValorPositivo(null, "", 11, 6);
                anoAquisicao.setConteudo(dataAquisicao.getAno());
                percentual.append('+', anoLei7713);
                percentual.append('-', anoAquisicao);
                if (percentual.comparacao("<", "0,000000")) {
                    percentual.clear();
                } else if (percentual.comparacao(">", "20,000000")) {
                    percentual.setConteudo("100,000000");
                } else {
                    percentual.append('*', "5");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return percentual;
    }

    public static ValorPositivo calcularPercentualReducaoLei11196FR1(Data dataAquisicao) {
        ValorPositivo percentual = new ValorPositivo(null, "Percentual de Reducao", 11, 9);
        try {
            if (dataAquisicao != null && Validador.validarData((String)dataAquisicao.formatado()) == null) {
                int anoAquisicao = Integer.parseInt(dataAquisicao.getAno());
                int anoDataLimiteFinal = 2005;
                int anoDataLimiteInicial = 1996;
                int mesAquisicao = Integer.parseInt(dataAquisicao.getMes());
                int mesDataLimiteFinal = 11;
                int mesDataLimiteInicial = 1;
                if (anoAquisicao <= anoDataLimiteFinal) {
                    if (anoAquisicao < anoDataLimiteInicial || anoAquisicao == anoDataLimiteInicial && mesAquisicao < mesDataLimiteInicial) {
                        anoAquisicao = anoDataLimiteInicial;
                        mesAquisicao = mesDataLimiteInicial;
                    }
                    int m = anoDataLimiteFinal * 12 + mesDataLimiteFinal - (anoAquisicao * 12 + mesAquisicao) + 1;
                    percentual.setConteudo(new BigDecimal("100.000000000").divide(new BigDecimal("1.0060").pow(m), RoundingMode.HALF_UP).negate().add(new BigDecimal("100.000000000")));
                    percentual.converteQtdCasasDecimais(6);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return percentual;
    }

    public static ValorPositivo calcularPercentualReducaoLei11196FR2(Data dataAquisicao, Data dataAlienacao) {
        ValorPositivo percentual = new ValorPositivo(null, "Percentual de Reducao", 11, 9);
        try {
            if (dataAquisicao != null && Validador.validarData((String)dataAquisicao.formatado(), (int)Integer.parseInt(ConstantesGlobais.EXERCICIO_POSTERIOR)) == null && dataAlienacao != null && Validador.validarData((String)dataAlienacao.formatado(), (int)Integer.parseInt(ConstantesGlobais.EXERCICIO_POSTERIOR)) == null) {
                int anoAquisicao = Integer.parseInt(dataAquisicao.getAno());
                int anoDataLimiteFinal = Integer.parseInt(dataAlienacao.getAno());
                int anoDataLimiteInicial = 2005;
                int mesAquisicao = Integer.parseInt(dataAquisicao.getMes());
                int mesDataLimiteFinal = Integer.parseInt(dataAlienacao.getMes());
                int mesDataLimiteInicial = 12;
                if (anoAquisicao <= anoDataLimiteFinal) {
                    if (anoAquisicao < anoDataLimiteInicial || anoAquisicao == anoDataLimiteInicial && mesAquisicao < mesDataLimiteInicial) {
                        anoAquisicao = anoDataLimiteInicial;
                        mesAquisicao = mesDataLimiteInicial;
                    }
                    int m = anoDataLimiteFinal * 12 + mesDataLimiteFinal - (anoAquisicao * 12 + mesAquisicao) + 1;
                    percentual.setConteudo(new BigDecimal("100.000000000").divide(new BigDecimal("1.0035").pow(m), RoundingMode.HALF_UP).negate().add(new BigDecimal("100.000000000")));
                    percentual.converteQtdCasasDecimais(6);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return percentual;
    }

    public static void main(String[] args) {
        ValorPositivo valor = new ValorPositivo(null, "Teste", 11, 9);
        valor.setConteudo("5011097,36");
        Data data = new Data();
        data.setConteudo("01/01/2024");
        ValorPositivo imposto = CalculoImpostoDevidoUtil.calcularImpostoDevido(valor, data);
        System.out.println("Imposto: " + imposto.formatado());
    }

    public static class TabelaImposto {
        private Data dataInicioVigencia = new Data();
        private String[][] tabela = null;

        public TabelaImposto(String data, String[][] tabela) {
            this.getDataInicioVigencia().setConteudo(data);
            this.setTabela(tabela);
        }

        public String[][] getTabela() {
            return this.tabela;
        }

        public void setTabela(String[][] tabela) {
            this.tabela = tabela;
        }

        public Data getDataInicioVigencia() {
            return this.dataInicioVigencia;
        }
    }
}

