/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.negocio;

import br.gov.serpro.gcap.entidades.ColecaoIdDemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.consolidacao.Consolidacao;
import br.gov.serpro.gcap.entidades.perguntas.PerguntasUtil;
import br.gov.serpro.gcap.exception.AplicacaoException;
import br.gov.serpro.gcap.gui.pendencias.PendenciaGCAP;
import br.gov.serpro.gcap.impressao.RelatorioUtil;
import br.gov.serpro.gcap.negocio.RepositorioXMLGCAP;
import br.gov.serpro.gcap.util.DataUtil;
import br.gov.serpro.gcap.util.GcapUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import serpro.hash.Crc32;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.PPGDFacade;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.persistenciagenerica.BackupInexistenteException;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;
import serpro.util.PLong;

public class GCAPFacade
implements PPGDFacade {
    public static final String EXPORTACAO_ENCODING = "ISO-8859-1";
    public static final String EXPORTACAO_STREAM_ENCODING = "ISO8859_1";
    public static final String EXPORTACAO_XML_DADOS_STREAM_ENCODING = "UTF-8";
    public static final String HASH_ALGORITMO_CRC32 = "CRC32";
    public static final String HASH_ALGORITMO_MD5 = "MD5";
    public static final String HASH_ALGORITMO = "CRC32";
    private static GCAPFacade instancia = null;
    private RepositorioXMLGCAP repositorioXMLGCAP = new RepositorioXMLGCAP();
    private static RelatorioUtil relatorioUtil = RelatorioUtil.getInstancia();
    private static PerguntasUtil perguntasUtil = PerguntasUtil.getInstancia();

    private GCAPFacade() {
    }

    public static GCAPFacade getInstancia() {
        if (instancia == null) {
            instancia = new GCAPFacade();
        }
        return instancia;
    }

    public static void abreDeclaracao(IdDemonstrativoGCAP id) throws HashInvalidoException {
        try {
            GCAPFacade.getInstancia().repositorioXMLGCAP.abreDeclaracao(id);
        }
        catch (RepositorioXMLException e) {
            e.printStackTrace();
        }
    }

    public static void abreDeclaracaoSemUI(IdDemonstrativoGCAP id) throws HashInvalidoException {
        try {
            GCAPFacade.getInstancia().repositorioXMLGCAP.abreDeclaracao(id);
        }
        catch (RepositorioXMLException e) {
            e.printStackTrace();
        }
    }

    public void restaurarBackup(IdDemonstrativoGCAP id) throws BackupInexistenteException {
        GCAPFacade.getInstancia().repositorioXMLGCAP.restaurarBackup(id);
    }

    public void restaurarBackup(String pathArquivo) throws BackupInexistenteException {
        GCAPFacade.getInstancia().repositorioXMLGCAP.restaurarBackup(pathArquivo);
    }

    public void fazerBackup(IdDemonstrativoGCAP id) {
        GCAPFacade.getInstancia().repositorioXMLGCAP.fazerBackup(id);
    }

    public void fazerBackup(String pathArquivo) {
        GCAPFacade.getInstancia().repositorioXMLGCAP.fazerBackup(pathArquivo);
    }

    public void excluirBackup(IdDemonstrativoGCAP id) throws BackupInexistenteException {
        GCAPFacade.getInstancia().repositorioXMLGCAP.excluirBackup(id);
    }

    public void excluirBackup(String pathArquivo) throws BackupInexistenteException {
        GCAPFacade.getInstancia().repositorioXMLGCAP.excluirBackup(pathArquivo);
    }

    public void gravarCopiaSeguranca(File diretorioGravacao, IdDemonstrativoGCAP idDemonstrativo) throws Exception {
        Object lCaminhoNomeArquivo = diretorioGravacao.getPath() + File.separator + idDemonstrativo.getNomeArquivo() + ".DBK";
        lCaminhoNomeArquivo = ((String)lCaminhoNomeArquivo).replaceFirst("//", "/");
        Object lCaminhoNomeArquivoDADOS = GcapUtil.DIR_DADOS + File.separator + idDemonstrativo.getCpf().getUltimoConteudoValido() + File.separator + idDemonstrativo.getNomeArquivo() + ".xml";
        lCaminhoNomeArquivoDADOS = ((String)lCaminhoNomeArquivoDADOS).replaceFirst("//", "/");
        this.compactarArquivoSalvandoDados((String)lCaminhoNomeArquivo, (String)lCaminhoNomeArquivoDADOS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactarArquivoSalvandoDados(String pCaminhoNomeArquivo, String pCaminhoNomeArquivoDADOS) throws Exception {
        ZipOutputStream out = null;
        try (Writer lWriter = null;){
            String line;
            out = new ZipOutputStream(new FileOutputStream(pCaminhoNomeArquivo));
            out.setLevel(-1);
            out.closeEntry();
            File fCaminhoNomeArquivoDADOS = new File(pCaminhoNomeArquivoDADOS);
            out.putNextEntry(new ZipEntry(fCaminhoNomeArquivoDADOS.getName()));
            BufferedReader bfr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fCaminhoNomeArquivoDADOS), EXPORTACAO_XML_DADOS_STREAM_ENCODING));
            lWriter = new OutputStreamWriter((OutputStream)out, EXPORTACAO_XML_DADOS_STREAM_ENCODING);
            while ((line = bfr.readLine()) != null) {
                lWriter.write(line);
            }
            lWriter.flush();
            bfr.close();
            out.closeEntry();
        }
    }

    public static String calcularHashCRC32(String pTexto) {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        pLong.setValue(0L);
        crc32.CalcCrc32(pTexto, pTexto.length(), pLong);
        return crc32.getStrCrc32();
    }

    public static String calcularHashMD5(String pTexto) throws Exception {
        MessageDigest lMessageDigest = null;
        lMessageDigest = MessageDigest.getInstance("CRC32");
        byte[] lDados = pTexto.getBytes(EXPORTACAO_ENCODING);
        lMessageDigest.update(lDados, 0, lDados.length);
        BigInteger lValorBigInt = new BigInteger(1, lMessageDigest.digest());
        return String.format("%1$032X", lValorBigInt);
    }

    public static String calcularHash(String pTexto) throws Exception {
        return GCAPFacade.calcularHashCRC32(pTexto);
    }

    public static String calcularHashMD5(File arquivoXML) throws AplicacaoException {
        String output = "";
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_ALGORITMO_MD5);
            FileInputStream is = new FileInputStream(arquivoXML);
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            output = bigInt.toString(16);
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            // empty catch block
        }
        return output;
    }

    public static void abreDeclaracao(DemonstrativoGCAP dec) {
        try {
            GCAPFacade.getInstancia().repositorioXMLGCAP.abreDeclaracao(dec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean existeDeclaracao(IdentificadorDeclaracaoXML idDec) {
        return GCAPFacade.getInstancia().repositorioXMLGCAP.existeDeclaracao(idDec);
    }

    public boolean existeDemonstrativo(String cpf, String dataInicio, String dataFim) {
        return this.repositorioXMLGCAP.existeDemonstrativo(cpf, dataInicio, dataFim);
    }

    public boolean existeCopiaSeguranca(File diretorio, IdDemonstrativoGCAP idDemonstrativo) {
        File arquivo = new File(diretorio.getPath() + File.separator + idDemonstrativo.getNomeArquivo() + ".DBK");
        return arquivo.exists();
    }

    public static ColecaoIdDemonstrativoGCAP getListaIdDeclaracoes() {
        return (ColecaoIdDemonstrativoGCAP)GCAPFacade.getInstancia().repositorioXMLGCAP.getListaIdDeclaracoes();
    }

    public static void setCacheIdDeclaracao(boolean status) {
        GCAPFacade.getInstancia().repositorioXMLGCAP.setCacheIdDeclaracao(status);
    }

    public static void criarDeclaracao(IdDemonstrativoGCAP id) {
        id.getDataUltimoAcesso().setConteudo(DataUtil.obterDataAtual());
        GCAPFacade.getInstancia().repositorioXMLGCAP.criarDeclaracao(id);
    }

    public static void criarDeclaracao(DemonstrativoGCAP dec) {
        dec.getIdentificadorDeclaracao().getDataUltimoAcesso().setConteudo(DataUtil.obterDataAtual());
        GCAPFacade.getInstancia().repositorioXMLGCAP.criarDeclaracao(dec);
    }

    public static void excluirDeclaracao(IdDemonstrativoGCAP id) {
        GCAPFacade.getInstancia().repositorioXMLGCAP.excluirDeclaracao(id);
    }

    public static void excluirDeclaracao(List<IdentificadorDeclaracaoXML> ids) {
        GCAPFacade.getInstancia().repositorioXMLGCAP.excluirDeclaracao(ids);
    }

    public static void salvaDeclaracaoAberta() {
        GCAPFacade.getInstancia().repositorioXMLGCAP.salvaDeclaracaoAberta();
    }

    public static void fechaDeclaracao() {
        GCAPFacade.limpaCacheDeclaracoes();
    }

    public static void limpaCacheDeclaracoes() {
        GCAPFacade.getInstancia().repositorioXMLGCAP.fechaDeclaracao();
    }

    public boolean isDeclaracaoAberta() {
        return GCAPFacade.getInstancia().repositorioXMLGCAP != null && GCAPFacade.getInstancia().repositorioXMLGCAP.getDeclaracaoAberta() != null;
    }

    public IdDemonstrativoGCAP getIdDeclaracaoAberto() {
        return (IdDemonstrativoGCAP)this.repositorioXMLGCAP.getIdDeclaracaoAberto();
    }

    public IdDemonstrativoGCAP recuperarIdDeclaracao(String cpf, String dataInicio, String dataFim) {
        return (IdDemonstrativoGCAP)this.repositorioXMLGCAP.obterIdentificador(GCAPFacade.getListaIdDeclaracoes(), cpf + "-" + dataInicio + "-" + dataFim);
    }

    public DemonstrativoGCAP recuperarDemonstrativoGCAP(String cpf, String dataInicio, String dataFim) {
        try {
            return (DemonstrativoGCAP)this.repositorioXMLGCAP.recuperarDeclaracao(cpf + "-" + dataInicio + "-" + dataFim);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void salvarDeclaracao(DemonstrativoGCAP dec) {
        try {
            this.repositorioXMLGCAP.salvarDeclaracao(dec);
            dec.getDataHoraSalvamento().setConteudo(DataUtil.obterDataAtual());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean existeDeclaracoes() {
        return GCAPFacade.getListaIdDeclaracoes().itens().size() > 0;
    }

    public DemonstrativoGCAP getDeclaracao() {
        return (DemonstrativoGCAP)GCAPFacade.getInstancia().repositorioXMLGCAP.getDeclaracaoAberta();
    }

    public void verificarIdDeclaracoes() {
        try {
            GCAPFacade.getInstancia().repositorioXMLGCAP.verificaIdDeclaracoes();
        }
        catch (Exception ex1) {
            try {
                Files.delete(Paths.get(GcapUtil.DIR_DADOS + File.separator + "iddeclaracoes.conf", new String[0]));
                Files.delete(Paths.get(GcapUtil.DIR_DADOS + File.separator + "iddeclaracoes.xml", new String[0]));
                GCAPFacade.getInstancia().repositorioXMLGCAP.verificaIdDeclaracoes();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static List<IdDemonstrativoGCAP> getListaDeclaracoesRecentes() {
        return GCAPFacade.getListaDeclaracoesOrdenadasPorDataAcesso(true);
    }

    public static List<IdDemonstrativoGCAP> getListaDeclaracoesOrdenadasPorDataAcesso(boolean apenasRecentes) {
        List lista = GCAPFacade.getListaIdDeclaracoes().itens();
        ArrayList<IdDemonstrativoGCAP> listaOrdenada = new ArrayList<IdDemonstrativoGCAP>();
        Collections.sort(lista, new Comparator<IdDemonstrativoGCAP>(){

            @Override
            public int compare(IdDemonstrativoGCAP i1, IdDemonstrativoGCAP i2) {
                Date d1 = i1.getDataUltimoAcesso().asDate();
                Date d2 = i2.getDataUltimoAcesso().asDate();
                if (d1 != null && d2 != null) {
                    return i2.getDataUltimoAcesso().asDate().compareTo(i1.getDataUltimoAcesso().asDate());
                }
                if (d1 == null) {
                    return 1;
                }
                return -1;
            }
        });
        int cont = 0;
        Iterator iterator = lista.iterator();
        while (iterator.hasNext()) {
            IdDemonstrativoGCAP objetoNegocio;
            IdDemonstrativoGCAP id = objetoNegocio = (IdDemonstrativoGCAP)((Object)iterator.next());
            listaOrdenada.add(id);
            if (!apenasRecentes || ++cont < 10) continue;
            break;
        }
        return listaOrdenada;
    }

    public Consolidacao getConsolidacaoDemonstrativo(DemonstrativoGCAP pDemonstrativo) {
        return relatorioUtil.getConsolidacaoDemonstrativo(pDemonstrativo);
    }

    public boolean deveExibirPerguntaConjuntoBensSuperior35Mil(AlienacaoBemImovel alienacaoBemImovel) {
        return perguntasUtil.deveExibirPerguntaBensInferiorLimiteIsencao(alienacaoBemImovel);
    }

    public boolean verificaHabilitacaoAbaPerguntas(AlienacaoBemImovel alienacaoBemImovel, IdDemonstrativoGCAP idDemonstrativo) {
        boolean existeParteAquisicaoPosterior1969;
        if (alienacaoBemImovel.getDataAlienacao().isVazio() || alienacaoBemImovel.getAquisicao().getDataAquisicao().isVazio()) {
            return false;
        }
        if (GcapUtil.isDeclaracaoBrasileira(alienacaoBemImovel) && (existeParteAquisicaoPosterior1969 = alienacaoBemImovel.existeCustoAquisicaoPosterior1969())) {
            Data data = alienacaoBemImovel.getDataAlienacao();
            data.validar();
            if (!data.isVazio() && data.isValido()) {
                return !PerguntasUtil.getInstancia().temPrejuizo(alienacaoBemImovel) || !alienacaoBemImovel.isAlienacaoBrasil();
            }
        }
        return false;
    }

    public boolean deveExibirPerguntaPossuiOutroImovel(AlienacaoBemImovel alienacaoBemImovel) {
        return perguntasUtil.deveExibirPerguntaPossuiOutroImovel(alienacaoBemImovel);
    }

    public boolean deveExibirPerguntaImovelResidencial(AlienacaoBemImovel alienacaoBemImovel) {
        return perguntasUtil.deveExibirPerguntaImovelResidencial(alienacaoBemImovel);
    }

    public boolean deveExibirPerguntaMP252(AlienacaoBemImovel alienacaoBemImovel) {
        return perguntasUtil.deveExibirPerguntaMP252(alienacaoBemImovel);
    }

    public boolean deveExibirPerguntaMP252Parte2(AlienacaoBemImovel alienacaoBemImovel) {
        return perguntasUtil.deveExibirPerguntaMP252Parte2(alienacaoBemImovel);
    }

    public List<Pendencia> verificarPendenciasObjetoNegocio(List<Informacao> informacoes, List<Pendencia> listaPendencias, String nomeFicha, String classeFicha, int numeroItem, String nomeAba, String listaSelecao) {
        for (Informacao informacao : informacoes) {
            informacao.setFicha(nomeFicha);
            RetornoValidacao retornoValidacao = informacao.validar().getPrimeiroRetornoValidacaoMaisSevero();
            if (retornoValidacao.getSeveridade() <= 0) continue;
            PendenciaGCAP pendencia = new PendenciaGCAP(retornoValidacao.getSeveridade(), informacao, informacao.getNomeCampo(), retornoValidacao.getMensagemValidacao(), numeroItem);
            pendencia.setClassePainel(classeFicha);
            pendencia.setNomeAba(nomeAba);
            pendencia.setListaSelecao(listaSelecao);
            listaPendencias.add(pendencia);
        }
        return null;
    }

    public Pendencia criarPendenciaSemCampo(byte severidade, String msgErro, String classeFicha, String nomeAba, String listaPassosSelecaoTela, String ficha) {
        Alfa dummy = new Alfa(msgErro);
        dummy.setFicha(ficha);
        PendenciaGCAP pendencia = new PendenciaGCAP(severidade, (Informacao)dummy, "Participa\u00e7\u00f5es", msgErro, -1);
        pendencia.setClassePainel(classeFicha);
        pendencia.setNomeAba(nomeAba);
        pendencia.setListaSelecao(listaPassosSelecaoTela);
        return pendencia;
    }
}

