/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.negocio;

import br.gov.serpro.gcap.entidades.ColecaoIdDemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.DataUtil;
import br.gov.serpro.gcap.util.GcapUtil;
import br.gov.serpro.gcap.util.IdDeclaracaoXMLTagHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.DeclaracaoComIdentificador;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.persistenciagenerica.BackupInexistenteException;
import serpro.ppgd.persistenciagenerica.DefaultTagHandler;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;
import serpro.ppgd.persistenciagenerica.RepositorioXML;
import serpro.ppgd.persistenciagenerica.RepositorioXMLDefault;
import serpro.ppgd.persistenciagenerica.RepositorioXMLListener;
import serpro.ppgd.persistenciagenerica.XMLSaxHandler;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class RepositorioXMLGCAP
extends RepositorioXML
implements RepositorioXMLListener {
    private RepositorioXMLDefault repositorioDeclaracoes = new RepositorioXMLDefault();

    public RepositorioXMLGCAP() {
        this.addRepositorioXMLListener(this);
    }

    public void recuperouDeclaracao(DeclaracaoComIdentificador dec) {
        ((DemonstrativoGCAP)dec).adicionaObservadoresCalculosLate();
    }

    public void abriuDeclaracao(DeclaracaoComIdentificador dec) {
        ((DemonstrativoGCAP)dec).adicionaObservadoresCalculosLate();
    }

    public void criouDeclaracao(DeclaracaoComIdentificador dec) {
        if (GcapUtil.getEstadoSistema() != 2) {
            ((DemonstrativoGCAP)dec).adicionaObservadoresCalculosLate();
        }
    }

    public void excluirDeclaracao(IdentificadorDeclaracaoXML id) {
        super.excluirDeclaracao(id);
        try {
            super.excluirBackup(id);
        }
        catch (BackupInexistenteException e) {
            e.printStackTrace();
        }
        new File(id.getPathArquivo()).getParentFile().delete();
    }

    public DeclaracaoComIdentificador recuperarDeclaracao(String cpf) throws RepositorioXMLException, HashInvalidoException {
        DeclaracaoComIdentificador dec = super.recuperarDeclaracao(cpf);
        IdDemonstrativoGCAP idOrigem = ((DemonstrativoGCAP)dec).getIdentificadorDeclaracao();
        IdDemonstrativoGCAP idDestino = ((DemonstrativoGCAP)dec).getCopiaIdentificador();
        this.copiaIdentificador(idOrigem, idDestino);
        return dec;
    }

    protected void copiaIdentificador(IdentificadorDeclaracaoXML orig, IdentificadorDeclaracaoXML destin) {
        IdDemonstrativoGCAP origem = (IdDemonstrativoGCAP)orig;
        IdDemonstrativoGCAP destino = (IdDemonstrativoGCAP)destin;
        destino.getCpf().setConteudo(origem.getCpf().toString());
        destino.getExercicio().setConteudo(origem.getExercicio().toString());
        destino.getNome().setConteudo(origem.getNome().toString());
        destino.getDddDeclarante().setConteudo(origem.getDddDeclarante().toString());
        destino.getTelefoneDeclarante().setConteudo(origem.getTelefoneDeclarante().toString());
        destino.getDataInicioPermanencia().setConteudo(origem.getDataInicioPermanencia());
        destino.getDataFimPermanencia().setConteudo(origem.getDataFimPermanencia());
        destino.getDataUltimoAcesso().setConteudo(origem.getDataUltimoAcesso());
        destino.getTerritorioParaisoFiscal().setConteudo(origem.getTerritorioParaisoFiscal());
    }

    protected Colecao criarListaIdDeclaracoes() {
        return new ColecaoIdDemonstrativoGCAP();
    }

    public boolean existeDeclaracao(IdentificadorDeclaracaoXML identificadorDeclaracao) {
        IdDemonstrativoGCAP pIdDemonstrativo = (IdDemonstrativoGCAP)identificadorDeclaracao;
        List lLista = this.getListaIdDeclaracoes().itens();
        for (ObjetoNegocio objetoNegocio : lLista) {
            IdDemonstrativoGCAP lId = (IdDemonstrativoGCAP)objetoNegocio;
            if (!lId.getCpf().naoFormatado().equals(pIdDemonstrativo.getCpf().naoFormatado()) || !DataUtil.verificarIntercecaoPeriodos(pIdDemonstrativo.getDataInicioPermanencia(), pIdDemonstrativo.getDataFimPermanencia(), lId.getDataInicioPermanencia(), lId.getDataFimPermanencia())) continue;
            return true;
        }
        return false;
    }

    public boolean existeDemonstrativo(String cpf, String dataInicio, String dataFim) {
        List lLista = this.getListaIdDeclaracoes().itens();
        for (ObjetoNegocio objetoNegocio : lLista) {
            IdDemonstrativoGCAP lId = (IdDemonstrativoGCAP)objetoNegocio;
            if (!lId.getCpf().naoFormatado().equals(cpf) || !lId.getDataInicioPermanencia().naoFormatado().equals(dataInicio) || !lId.getDataFimPermanencia().naoFormatado().equals(dataFim)) continue;
            return true;
        }
        return false;
    }

    protected DeclaracaoComIdentificador instanciarDeclaracao(IdentificadorDeclaracaoXML identificadorDeclaracao) {
        return new DemonstrativoGCAP((IdDemonstrativoGCAP)identificadorDeclaracao);
    }

    protected IdentificadorDeclaracaoXML obterIdentificador(Colecao listaIdDeclaracoes, String numeroIdentificacao) {
        return ((ColecaoIdDemonstrativoGCAP)listaIdDeclaracoes).getIdentificadorDeclaracao(numeroIdentificacao);
    }

    protected String obterNumeroIdentificacao(IdentificadorDeclaracaoXML identificadorDeclaracao) {
        IdDemonstrativoGCAP idDec = (IdDemonstrativoGCAP)identificadorDeclaracao;
        return idDec.getCpf().naoFormatado() + "-" + idDec.getDataInicioPermanencia().naoFormatado() + "-" + idDec.getDataFimPermanencia().naoFormatado();
    }

    protected String obterPathDados() {
        return GcapUtil.DIR_DADOS;
    }

    protected String obterPathXmlIdsDeclaracoes() {
        return this.obterPathDados() + File.separator + "iddeclaracoes.xml";
    }

    protected DefaultTagHandler obterTagHandler() {
        return new IdDeclaracaoXMLTagHandler();
    }

    protected void parseXml(Colecao colecaoIds, SAXParser parser, DefaultTagHandler tagHandler, XMLSaxHandler xmlHandler, File[] decXml) {
        try {
            IdDeclaracaoXMLTagHandler idDeclaracaoXMLTagHandler = (IdDeclaracaoXMLTagHandler)tagHandler;
            idDeclaracaoXMLTagHandler.setIdDec(new IdDemonstrativoGCAP());
            parser.parse(decXml[0], (DefaultHandler)xmlHandler);
            if (AplicacaoPropertiesUtil.getExercicio().equals(idDeclaracaoXMLTagHandler.getIdDec().getExercicio().naoFormatado())) {
                colecaoIds.itens().add(idDeclaracaoXMLTagHandler.getIdDec());
            }
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void removerIdentificador(Colecao colecaoIdentificadores, IdentificadorDeclaracaoXML identificadorDeclaracao) {
        ((ColecaoIdDemonstrativoGCAP)colecaoIdentificadores).removeCPF((IdDemonstrativoGCAP)identificadorDeclaracao);
    }

    public String getXPathCopiaId() {
        return "/classe/copiaIdentificador";
    }

    protected String obterExpressaoRegularNomePasta() {
        return "(\\d){11}";
    }

    protected void antesDeSalvar(DeclaracaoComIdentificador aDec) {
        DemonstrativoGCAP dec = (DemonstrativoGCAP)aDec;
        IdDemonstrativoGCAP copia = dec.getCopiaIdentificador();
        IdentificadorDeclaracaoXML origem = dec.getIdentificador();
        dec.getIdentificadorDeclaracao().getDataUltimoAcesso().setConteudo(DataUtil.obterDataAtual());
        this.copiaIdentificador(origem, copia);
    }

    public List<IdDemonstrativoGCAP> ordenarIdDemonstrativosPorAcessoMaisRecente(List<IdDemonstrativoGCAP> listaIdDemonstrativos) {
        Collections.sort(listaIdDemonstrativos, new Comparator<IdDemonstrativoGCAP>(){

            @Override
            public int compare(IdDemonstrativoGCAP o1, IdDemonstrativoGCAP o2) {
                Date data1 = o1.getDataUltimoAcesso().asDate();
                Date data2 = o2.getDataUltimoAcesso().asDate();
                if (data1 != null && data2 != null) {
                    return data2.compareTo(data1);
                }
                if (data1 == null && data2 == null) {
                    return 0;
                }
                if (data1 == null) {
                    return 1;
                }
                return -1;
            }
        });
        return listaIdDemonstrativos;
    }

    public void verificaIdDeclaracoes() {
        Colecao colIds = this.getListaIdDeclaracoes();
        this.testaDiretorioDados();
        ArrayList<File> decs = new ArrayList<File>();
        try {
            File[] pastas;
            File dados = new File(this.obterPathDados());
            for (File pasta : pastas = dados.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().matches(RepositorioXMLGCAP.this.obterExpressaoRegularNomePasta());
                }
            })) {
                File[] files = pasta.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && pathname.getName().matches("(\\d){11}\\-(\\d){4}-(\\d){4}-GCAP-" + AplicacaoPropertiesUtil.getExercicio() + "\\.xml");
                    }
                });
                Collections.addAll(decs, files);
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            return;
        }
        this.excluirIdentificadoresInvalidos((ColecaoIdDemonstrativoGCAP)colIds);
        if (colIds == null || colIds.itens().size() != decs.size()) {
            this.restaurarListaIdDeclaracoes(colIds, decs);
            try {
                this.salvarColecaoId(colIds);
            }
            catch (RepositorioXMLException e) {
                LogPPGD.erro((String)e.getMessage());
            }
        }
    }

    private void excluirIdentificadoresInvalidos(ColecaoIdDemonstrativoGCAP ids) {
        ArrayList<IdDemonstrativoGCAP> idsExcluir = new ArrayList<IdDemonstrativoGCAP>();
        if (ids != null) {
            for (IdDemonstrativoGCAP id : ids.itens()) {
                if (AplicacaoPropertiesUtil.getExercicio().equals(id.getExercicio().naoFormatado())) continue;
                idsExcluir.add(id);
            }
            for (IdDemonstrativoGCAP id : idsExcluir) {
                ids.remove(id);
            }
        }
    }

    protected void restaurarListaIdDeclaracoes(Colecao colIds, List<File> decs) {
        System.out.println("Recuperando Ids... total: " + decs.size());
        if (colIds == null) {
            colIds = this.criarListaIdDeclaracoes();
        } else {
            colIds.itens().clear();
        }
        DefaultTagHandler tagHandler = this.obterTagHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            XMLSaxHandler handler = new XMLSaxHandler();
            handler.addTagHandler(this.getXPathCopiaId(), tagHandler);
            for (int i = 0; i < decs.size(); ++i) {
                File dec = decs.get(i);
                try {
                    this.parseXml(colIds, parser, tagHandler, handler, new File[]{dec});
                    continue;
                }
                catch (Exception e) {
                    LogPPGD.erro((String)e.getMessage());
                }
            }
        }
        catch (ParserConfigurationException ex) {
            LogPPGD.erro((String)ex.getMessage());
        }
        catch (SAXException ex) {
            LogPPGD.erro((String)ex.getMessage());
        }
    }

    public DeclaracaoComIdentificador abreDeclaracaoSemUI(IdentificadorDeclaracaoXML id) throws RepositorioXMLException, HashInvalidoException {
        DeclaracaoComIdentificador declaracao = null;
        if (this.repositorioDeclaracoes.temObjetoNegocioEmCache(id.getPathArquivo())) {
            declaracao = (DeclaracaoComIdentificador)this.repositorioDeclaracoes.getObjeto(id.getPathArquivo());
        } else {
            declaracao = this.instanciarDeclaracao(id);
            this.repositorioDeclaracoes.preencheObjeto((ObjetoNegocio)declaracao, id.getPathArquivo(), false);
            for (RepositorioXMLListener listener : this.getListeners()) {
                listener.abriuDeclaracao(declaracao);
            }
        }
        return declaracao;
    }
}

