/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.nuvem;

import br.gov.serpro.gcap.exception.AplicacaoException;
import br.gov.serpro.gcap.exception.BarramentoException;
import br.gov.serpro.gcap.nuvem.BarramentoIRPFUtil;
import br.gov.serpro.gcap.nuvem.RetornoBarramento;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.DataUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import com.google.gson.Gson;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import jsignnet.aplicacao.Hash;
import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.erro.ErroAoGerarPKCS7;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class BarramentoIRPFService {
    public static final String RETORNO_OK = "00";
    public static final String RETORNO_CAPTCHA_INCORRETO = "90";
    public static final String RETORNO_ERRO = "99";
    public static final String RETORNO_CPF_NAO_EXISTE = "94";
    private static final String URL_BASE_REST = Boolean.valueOf(FabricaUtilitarios.getProperties().getProperty("versao_testes")) != false ? "https://hom-mir-barramentoirpf.estaleiro.serpro.gov.br/pgdirpf/rest" : "https://mir-barramentoirpf.estaleiro.serpro.gov.br/pgdirpf/rest";
    private static final String URL_DARF_GCAP = URL_BASE_REST + "/darf/gcap";
    private static final String versaoPGD = FabricaUtilitarios.getProperties().getProperty("versao_txt");
    private static String token = null;

    public static Map<String, String> getQueryMap(String query) {
        String[] params = query.split("&");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String param : params) {
            String[] paramPair = param.split("=");
            String name = paramPair[0];
            String value = paramPair[1];
            map.put(name, value);
        }
        return map;
    }

    public static String gerarAssinaturaBase64(X509CertificadoWrapper certificado, byte[] conteudo) throws AplicacaoException {
        try {
            byte[] assinatura = certificado.assinaPKCS7(Hash.MESMO_DO_CERTIFICADO, conteudo, certificado.getSenhaContainer(), true, true);
            return new String(Base64.encodeBase64((byte[])assinatura, (boolean)true, (boolean)true));
        }
        catch (ErroAoGerarPKCS7 e) {
            throw new AplicacaoException("Ocorreu um erro durante assinatura de dados.", e, false);
        }
    }

    public static byte[] obterPdfDarfGcap(TipoDarfGCAP tipo, String cpf, String nomeContribuinte, String observacoes, String descricaoPrincipal, String descricoesAdicionais, Date periodoApuracao, Date dataVencimento, Double valorPrincipal, boolean aplicarIN599_2005, Date dataAlienacao) throws AplicacaoException, BarramentoException {
        RetornoBarramento retornoBarramento;
        String principal;
        DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        try {
            principal = df.format(valorPrincipal);
        }
        catch (Exception e) {
            throw new AplicacaoException("Valor da quota com formato inv\u00e1lido.", false);
        }
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        try {
            parametros.put("nomeContribuinte", URLEncoder.encode(nomeContribuinte, StandardCharsets.UTF_8.toString()));
            parametros.put("observacoes", URLEncoder.encode(observacoes, StandardCharsets.UTF_8.toString()));
            parametros.put("descricaoPrincipal", URLEncoder.encode(descricaoPrincipal, StandardCharsets.UTF_8.toString()));
            parametros.put("descricoesAdicionais", URLEncoder.encode(descricoesAdicionais, StandardCharsets.UTF_8.toString()));
            parametros.put("principal", principal);
            parametros.put("aplicarIN599_2005", Boolean.toString(aplicarIN599_2005));
            if (aplicarIN599_2005) {
                parametros.put("dataAlienacao", DataUtil.formatarDataSemBarras(dataAlienacao));
            }
            parametros.put("periodoApuracao", DataUtil.formatarDataSemBarras(periodoApuracao));
            parametros.put("dataVencimento", DataUtil.formatarDataSemBarras(dataVencimento));
            parametros.put("exercicio", AplicacaoPropertiesUtil.getExercicio());
        }
        catch (Throwable e) {
            throw new AplicacaoException("Parametros Invalidos.", e);
        }
        String hashParametros = BarramentoIRPFUtil.gerarHashParametros(parametros);
        String json = StringUtils.newStringUtf8((byte[])BarramentoIRPFService.chamarServicoRestPost(URL_DARF_GCAP + "/" + String.valueOf((Object)tipo) + "/" + cpf, parametros, hashParametros)).trim();
        if (AplicacaoPropertiesUtil.isVersaoTestes()) {
            System.out.println("Parametros: " + ((Object)parametros).toString());
            System.out.println("Retorno: " + json);
        }
        Gson gson = new Gson();
        try {
            retornoBarramento = (RetornoBarramento)gson.fromJson(json, RetornoBarramento.class);
        }
        catch (Exception e) {
            RetornoBarramento retorno = new RetornoBarramento();
            retorno.setCodigoRetorno(RETORNO_ERRO);
            retorno.setMensagemRetorno("Ocorreu um erro ao gerar o Darf.");
            retorno.setException("Erro durante consulta ao DARF. [Retorno:" + json + "]");
            throw new BarramentoException(retorno.getMensagemRetorno(), retorno.getCodigoRetorno(), e);
        }
        if (!retornoBarramento.getCodigoRetorno().equals(RETORNO_OK)) {
            throw new BarramentoException(retornoBarramento);
        }
        try {
            return Base64.decodeBase64((String)retornoBarramento.getConteudo());
        }
        catch (Throwable e) {
            RetornoBarramento retorno = new RetornoBarramento();
            retorno.setCodigoRetorno(RETORNO_ERRO);
            retorno.setMensagemRetorno("Ocorreu um erro ao gerar o Darf.");
            retorno.setException("Erro durante consulta ao DARF. [Retorno:" + json + "]");
            e.printStackTrace();
            throw new BarramentoException(retorno);
        }
    }

    private static byte[] chamarServicoRestPost(String url, Map<String, String> parametros, String hash) {
        return BarramentoIRPFService.chamarServicoRest("POST", url, parametros, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] chamarServicoRest(String method, String url, Map<String, String> parametros, String hash) {
        String msgErro;
        HttpURLConnection con = null;
        try {
            URL obj = new URL(url);
            System.out.println("URL: " + String.valueOf(obj));
            con = BarramentoIRPFService.getURLConnection(obj);
            byte[] byArray = BarramentoIRPFService.chamarServicoRest(con, method, parametros, hash);
            return byArray;
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
            e.printStackTrace();
            msgErro = MensagemUtil.getMensagem("nuvem.erro.inesperado");
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        RetornoBarramento retornoBarramento = new RetornoBarramento();
        retornoBarramento.setCodigoRetorno(RETORNO_ERRO);
        retornoBarramento.setMensagemRetorno(msgErro);
        return StringUtils.getBytesUtf8((String)new Gson().toJson((Object)retornoBarramento));
    }

    private static byte[] chamarServicoRest(HttpURLConnection con, String method, Map<String, String> parametros, String hash) {
        byte[] retorno = null;
        RetornoBarramento retornoBarramento = new RetornoBarramento();
        try {
            ByteArrayOutputStream baf;
            BufferedInputStream bis;
            int responseCode;
            boolean first = true;
            StringBuilder urlParameters = null;
            if (parametros != null && !parametros.isEmpty()) {
                urlParameters = new StringBuilder();
                for (String nomeParametro : parametros.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        urlParameters.append("&");
                    }
                    String valorParametro = parametros.get(nomeParametro);
                    urlParameters.append(nomeParametro).append("=").append(valorParametro);
                }
            }
            con.setRequestMethod(method);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setRequestProperty("charset", "iso-8859-1");
            if (urlParameters != null) {
                con.setRequestProperty("Content-Length", Integer.toString(urlParameters.toString().getBytes().length));
            }
            if (hash != null) {
                con.setRequestProperty("hash", hash);
            }
            con.setRequestProperty("versao_pgd", versaoPGD);
            con.setRequestProperty("exercicio", ConstantesGlobais.EXERCICIO);
            con.setDoOutput(true);
            if (urlParameters != null) {
                try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                    wr.writeBytes(urlParameters.toString());
                    wr.flush();
                }
                catch (Exception e) {
                    throw new AplicacaoException("nuvem.erro.inesperado", e);
                }
            }
            if ((responseCode = con.getResponseCode()) == 200) {
                bis = new BufferedInputStream(con.getInputStream());
                try {
                    baf = new ByteArrayOutputStream(50);
                    try {
                        int read = 0;
                        int bufSize = 512;
                        byte[] buffer = new byte[bufSize];
                        while ((read = bis.read(buffer)) != -1) {
                            baf.write(buffer, 0, read);
                        }
                        retorno = baf.toByteArray();
                    }
                    finally {
                        baf.close();
                    }
                }
                finally {
                    bis.close();
                }
                return retorno;
            }
            bis = new BufferedInputStream(con.getErrorStream());
            try {
                baf = new ByteArrayOutputStream(50);
                try {
                    int read = 0;
                    int bufSize = 512;
                    byte[] buffer = new byte[bufSize];
                    while ((read = bis.read(buffer)) != -1) {
                        baf.write(buffer, 0, read);
                    }
                    retornoBarramento.setException(new String(baf.toByteArray()));
                }
                finally {
                    baf.close();
                }
            }
            finally {
                bis.close();
            }
            if (responseCode / 100 == 5) {
                retornoBarramento.setMensagemRetorno(MensagemUtil.getMensagem("nuvem.erro.servico_indisponivel"));
            } else {
                retornoBarramento.setMensagemRetorno(MensagemUtil.getMensagem("nuvem.erro.inesperado"));
            }
        }
        catch (AplicacaoException e) {
            LogPPGD.erro((String)e.getMessage());
            e.printStackTrace();
            retornoBarramento.setMensagemRetorno(e.getMessage());
        }
        catch (Throwable e) {
            LogPPGD.erro((String)e.getMessage());
            e.printStackTrace();
            retornoBarramento.setMensagemRetorno(MensagemUtil.getMensagem("nuvem.erro.inesperado"));
        }
        retornoBarramento.setCodigoRetorno(RETORNO_ERRO);
        return StringUtils.getBytesUtf8((String)new Gson().toJson((Object)retornoBarramento));
    }

    private static HttpURLConnection getURLConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    public static void main(String[] args) {
        Data d1 = new Data();
        Data d2 = new Data();
        d1.setConteudo("31/12/2023");
        d2.setConteudo("30/04/2024");
        try {
            byte[] darf = BarramentoIRPFService.obterPdfDarfGcap(TipoDarfGCAP.AlienacaoMoedaEspecie, "11171887795", "TESTE", "Caso seja feriado local, antecipe o pagamento||Imposto sobre a Renda da Pessoa F\u00edsica 2023", "Imposto de Renda da Pessoa F\u00edsica", "Declara\u00e7\u00e3o de Ajuste Anual|Quota \u00fanica do IRPF 2023|", d1.asDate(), d2.asDate(), 86.42, false, null);
            try (FileOutputStream outputStream = new FileOutputStream(new File("darf.pdf"));){
                outputStream.write(darf);
            }
        }
        catch (Exception ex) {
            System.out.println("Erro: " + ex.getMessage());
        }
    }

    public static enum TipoDarfGCAP {
        AlienacaoBrasilResidenteBrasil,
        AlienacaoBrasilResidenteExterior,
        AlienacaoExteriorResidenteBrasil,
        AlienacaoExteriorResidenteBrasilDepositosCartao,
        AlienacaoMoedaEspecie;

    }
}

