/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.observador;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacaoBem;
import java.lang.ref.WeakReference;
import serpro.ppgd.negocio.Observador;

public class ObservadorCalculoTotaisParcelasBem
extends Observador {
    private WeakReference<AlienacaoBem> weakAlienacao;

    public ObservadorCalculoTotaisParcelasBem(AlienacaoBem alienacao) {
        this.weakAlienacao = new WeakReference<AlienacaoBem>(alienacao);
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                ParcelaAlienacaoBem parcela = (ParcelaAlienacaoBem)((Object)valorNovo);
                parcela.addObservador(this);
                this.calcularTotais();
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                ParcelaAlienacaoBem parcela = (ParcelaAlienacaoBem)((Object)valorNovo);
                parcela.removeObservador(this);
                this.calcularTotais();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_VALOR_RECEBIDO)) {
                this.calculaTotaisValorRecebido();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_CUSTO_CORRETAGEM)) {
                this.calculaTotaisCustoCorretagem();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_VALOR_LIQUIDO_ALIENACAO)) {
                this.calculaTotaisValorLiquidoAlienacao();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_GANHO_1_PROPORCIONAL)) {
                this.calculaTotaisGanho1Proporcional();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_GANHO_5_PROPORCIONAL)) {
                this.calculaTotaisGanho5Proporcional();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_IMPOSTO_DEVIDO)) {
                this.calculaTotaisImpostoDevido();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_IMPOSTO_DEVIDO_APOS_COMPENSACAO)) {
                this.calculaTotaisImpostoDevido2();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_IMPOSTO_PAGO)) {
                this.calculaTotaisImpostoPago();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_IMPOSTO_PAGO_EXTERIOR_PASSIVEL_COMPENSACAO)) {
                this.calculaTotaisImpostoPagoExterior();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_VALOR_RECEBIDO_DOLAR)) {
                this.calculaTotaisValorRecebidoDolarTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_VALOR_RECEBIDO_REAL)) {
                this.calculaTotaisValorRecebidoRealTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_CUSTO_CORRETAGEM_DOLAR)) {
                this.calculaCustoCorretagemDolarTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_VALOR_LIQUIDO_ALIENACAO_DOLAR)) {
                this.calculaValorLiquidoAlienacaoDolarTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_VALOR_LIQUIDO_ALIENACAO_REAL)) {
                this.calculaValorLiquidoAlienacaoRealTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_GANHO_CAPITAL_1_PROPORCIONAL_NACIONAL_REAL)) {
                this.calculaGanhoCapital1ProporcionalNacionalRealTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_GANHO_5_PROPORCIONAL_MN)) {
                this.calculaGanhoCapital5ProporcionalNacionalRealTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_GANHO_CAPITAL_1_PROPORCIONAL_ME_REAL)) {
                this.calculaGanhoCapital1ProporcionalMERealTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_GANHO_5_PROPORCIONAL_ME)) {
                this.calculaGanhoCapital5ProporcionalMERealTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_GANHO_CAPITAL_1_PROPORCIONAL_ME_DOLAR)) {
                this.calculaGanhoCapital1ProporcionalMEDolarTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_GANHO_CAPITAL_1_PROPORCIONAL_TOTAL_REAL)) {
                this.calculaGanhoCapital1ProporcionalRealTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_GANHO_CAPITAL_5_PROPORCIONAL_TOTAL_REAL)) {
                this.calculaGanhoCapital5ProporcionalRealTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_CUSTO_AQUISICAO_PROPORCIONAL)) {
                this.calculaCustoAquisicaoProporcionalTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_CUSTO_AQUISICAO_TORNA_PROPORCIONAL)) {
                this.calculaCustoAquisicaoTornaProporcionalTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_CUSTO_AQUISICAO_PROPORCIONAL_NACIONAL_REAL)) {
                this.calculaCustoAquisicaoProporcionalOrigemNacionalRealTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_CUSTO_AQUISICAO_TORNA_PROPORCIONAL_NACIONAL_REAL)) {
                this.calculaCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_CUSTO_AQUISICAO_PROPORCIONAL_ME_DOLAR)) {
                this.calculaCustoAquisicaoProporcionalOrigemMEDolarTotal();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_CUSTO_AQUISICAO_TORNA_PROPORCIONAL_ME_DOLAR)) {
                this.calculaCustoAquisicaoTornaProporcionalOrigemMEDolarTotal();
            }
        }
    }

    private void calcularTotais() {
        ValorPositivo totalValorRecebido = new ValorPositivo();
        ValorPositivo totalCustoCorretagem = new ValorPositivo();
        ValorPositivo totalValorLiquidoAlienacao = new ValorPositivo();
        ValorPositivo totalGanho1Proporcional = new ValorPositivo();
        ValorPositivo totalGanho5Proporcional = new ValorPositivo();
        ValorPositivo totalImpostoDevido = new ValorPositivo();
        ValorPositivo totalImpostoDevido2 = new ValorPositivo();
        ValorPositivo totalImpostoPago = new ValorPositivo();
        ValorPositivo totalImpostoPagoExterior = new ValorPositivo();
        ValorPositivo totalValorRecebidoDolarTotal = new ValorPositivo();
        ValorPositivo totalValorRecebidoRealTotal = new ValorPositivo();
        ValorPositivo totalCustoCorretagemDolarTotal = new ValorPositivo();
        ValorPositivo totalValorLiquidoAlienacaoDolarTotal = new ValorPositivo();
        ValorPositivo totalValorLiquidoAlienacaoRealTotal = new ValorPositivo();
        ValorPositivo totalGanhoCapital1ProporcionalNacionalRealTotal = new ValorPositivo();
        ValorPositivo totalGanhoCapital5ProporcionalNacionalRealTotal = new ValorPositivo();
        ValorPositivo totalGanhoCapital1ProporcionalMERealTotal = new ValorPositivo();
        ValorPositivo totalGanhoCapital5ProporcionalMERealTotal = new ValorPositivo();
        ValorPositivo totalGanhoCapital1ProporcionalMEDolarTotal = new ValorPositivo();
        ValorPositivo totalGanhoCapital1ProporcionalRealTotal = new ValorPositivo();
        ValorPositivo totalGanhoCapital5ProporcionalRealTotal = new ValorPositivo();
        ValorPositivo totalCustoAquisicaoProporcionalTotal = new ValorPositivo();
        ValorPositivo totalCustoAquisicaoTornaProporcionalTotal = new ValorPositivo();
        ValorPositivo totalCustoAquisicaoProporcionalOrigemNacionalRealTotal = new ValorPositivo();
        ValorPositivo totalCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal = new ValorPositivo();
        ValorPositivo totalCustoAquisicaoProporcionalOrigemMEDolarTotal = new ValorPositivo();
        ValorPositivo totalCustoAquisicaoTornaProporcionalOrigemMEDolarTotal = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            totalValorRecebido.append('+', parcela.getValorRecebido());
            totalCustoCorretagem.append('+', parcela.getCustoCorretagem());
            totalValorLiquidoAlienacao.append('+', parcela.getValorLiquidoAlienacao());
            totalGanho1Proporcional.append('+', parcela.getGanhoCapital1Proporcional());
            totalGanho5Proporcional.append('+', parcela.getGanhoCapital5Proporcional());
            totalImpostoDevido.append('+', parcela.getImpostoDevido());
            totalImpostoDevido2.append('+', parcela.getImpostoDevido2());
            totalImpostoPago.append('+', parcela.getImpostoPago());
            totalImpostoPagoExterior.append('+', parcela.getImpostoPagoExterior());
            totalValorRecebidoDolarTotal.append('+', parcela.getValorRecebidoDolar());
            totalValorRecebidoRealTotal.append('+', parcela.getValorRecebidoReal());
            totalCustoCorretagemDolarTotal.append('+', parcela.getCustoCorretagemDolar());
            totalValorLiquidoAlienacaoDolarTotal.append('+', parcela.getValorLiquidoAlienacaoDolar());
            totalValorLiquidoAlienacaoRealTotal.append('+', parcela.getValorLiquidoAlienacaoReal());
            totalGanhoCapital1ProporcionalNacionalRealTotal.append('+', parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
            totalGanhoCapital5ProporcionalNacionalRealTotal.append('+', parcela.getGanhoCapital5ProporcionalMN());
            totalGanhoCapital1ProporcionalMERealTotal.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEReal());
            totalGanhoCapital5ProporcionalMERealTotal.append('+', parcela.getGanhoCapital5ProporcionalME());
            totalGanhoCapital1ProporcionalMEDolarTotal.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEDolar());
            totalGanhoCapital1ProporcionalRealTotal.append('+', parcela.getGanhoCapital1ProporcionalTotalReal());
            totalGanhoCapital5ProporcionalRealTotal.append('+', parcela.getGanhoCapital5ProporcionalTotalReal());
            totalCustoAquisicaoProporcionalTotal.append('+', parcela.getCustoAquisicaoProporcional());
            totalCustoAquisicaoTornaProporcionalTotal.append('+', parcela.getCustoAquisicaoTornaProporcional());
            totalCustoAquisicaoProporcionalOrigemNacionalRealTotal.append('+', parcela.getCustoAquisicaoProporcionalOrigemNacionalReal());
            totalCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal.append('+', parcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal());
            totalCustoAquisicaoProporcionalOrigemMEDolarTotal.append('+', parcela.getCustoAquisicaoProporcionalOrigemMEDolar());
            totalCustoAquisicaoTornaProporcionalOrigemMEDolarTotal.append('+', parcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorRecebidoTotal().setConteudo(totalValorRecebido);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoCorretagemTotal().setConteudo(totalCustoCorretagem);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorLiquidoAlienacaoTotal().setConteudo(totalValorLiquidoAlienacao);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanho1ProporcionalTotal().setConteudo(totalGanho1Proporcional);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanho5ProporcionalTotal().setConteudo(totalGanho5Proporcional);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getImpostoDevidoTotal().setConteudo(totalImpostoDevido);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getImpostoDevido2Total().setConteudo(totalImpostoDevido2);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getImpostoPagoTotal().setConteudo(totalImpostoPago);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getImpostoPagoExteriorTotal().setConteudo(totalImpostoPagoExterior);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorRecebidoDolarTotal().setConteudo(totalValorRecebidoDolarTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorRecebidoRealTotal().setConteudo(totalValorRecebidoRealTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal().setConteudo(totalCustoCorretagemDolarTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorLiquidoAlienacaoDolarTotal().setConteudo(totalValorLiquidoAlienacaoDolarTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal().setConteudo(totalValorLiquidoAlienacaoRealTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalNacionalRealTotal().setConteudo(totalGanhoCapital1ProporcionalNacionalRealTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalNacionalRealTotal().setConteudo(totalGanhoCapital5ProporcionalNacionalRealTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMERealTotal().setConteudo(totalGanhoCapital1ProporcionalMERealTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalMERealTotal().setConteudo(totalGanhoCapital5ProporcionalMERealTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMEDolarTotal().setConteudo(totalGanhoCapital1ProporcionalMEDolarTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalRealTotal().setConteudo(totalGanhoCapital1ProporcionalRealTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalRealTotal().setConteudo(totalGanhoCapital5ProporcionalRealTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalTotal().setConteudo(totalCustoAquisicaoProporcionalTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalTotal().setConteudo(totalCustoAquisicaoTornaProporcionalTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemNacionalRealTotal().setConteudo(totalCustoAquisicaoProporcionalOrigemNacionalRealTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal().setConteudo(totalCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemMEDolarTotal().setConteudo(totalCustoAquisicaoProporcionalOrigemMEDolarTotal);
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemMEDolarTotal().setConteudo(totalCustoAquisicaoTornaProporcionalOrigemMEDolarTotal);
        if (this.weakAlienacao.get() instanceof AlienacaoBemImovel) {
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().atualizarReducoesMN();
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().atualizarReducoesME();
        }
    }

    private void calculaTotaisValorRecebido() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorRecebido());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorRecebidoTotal().setConteudo(total);
    }

    private void calculaTotaisCustoCorretagem() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getCustoCorretagem());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoCorretagemTotal().setConteudo(total);
    }

    private void calculaTotaisValorLiquidoAlienacao() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorLiquidoAlienacao());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorLiquidoAlienacaoTotal().setConteudo(total);
    }

    private void calculaTotaisGanho1Proporcional() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital1Proporcional());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanho1ProporcionalTotal().setConteudo(total);
    }

    private void calculaTotaisGanho5Proporcional() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital5Proporcional());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanho5ProporcionalTotal().setConteudo(total);
    }

    private void calculaTotaisImpostoDevido() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getImpostoDevido());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getImpostoDevidoTotal().setConteudo(total);
    }

    private void calculaTotaisImpostoDevido2() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getImpostoDevido2());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getImpostoDevido2Total().setConteudo(total);
    }

    private void calculaTotaisImpostoPago() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getImpostoPago());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getImpostoPagoTotal().setConteudo(total);
    }

    private void calculaTotaisImpostoPagoExterior() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getImpostoPagoExterior());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getImpostoPagoExteriorTotal().setConteudo(total);
    }

    private void calculaTotaisValorRecebidoDolarTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorRecebidoDolar());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorRecebidoDolarTotal().setConteudo(total);
    }

    private void calculaTotaisValorRecebidoRealTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorRecebidoReal());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorRecebidoRealTotal().setConteudo(total);
    }

    private void calculaCustoCorretagemDolarTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getCustoCorretagemDolar());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal().setConteudo(total);
    }

    private void calculaValorLiquidoAlienacaoDolarTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorLiquidoAlienacaoDolar());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorLiquidoAlienacaoDolarTotal().setConteudo(total);
    }

    private void calculaValorLiquidoAlienacaoRealTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorLiquidoAlienacaoReal());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal().setConteudo(total);
    }

    private void calculaGanhoCapital1ProporcionalNacionalRealTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalNacionalRealTotal().setConteudo(total);
    }

    private void calculaGanhoCapital5ProporcionalNacionalRealTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital5ProporcionalMN());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalNacionalRealTotal().setConteudo(total);
    }

    private void calculaGanhoCapital1ProporcionalMERealTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEReal());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMERealTotal().setConteudo(total);
    }

    private void calculaGanhoCapital5ProporcionalMERealTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital5ProporcionalME());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalMERealTotal().setConteudo(total);
    }

    private void calculaGanhoCapital1ProporcionalMEDolarTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEDolar());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMEDolarTotal().setConteudo(total);
    }

    private void calculaGanhoCapital1ProporcionalRealTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital1ProporcionalTotalReal());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalRealTotal().setConteudo(total);
    }

    private void calculaGanhoCapital5ProporcionalRealTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital5ProporcionalTotalReal());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalRealTotal().setConteudo(total);
    }

    private void calculaCustoAquisicaoProporcionalTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getCustoAquisicaoProporcional());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalTotal().setConteudo(total);
    }

    private void calculaCustoAquisicaoTornaProporcionalTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getCustoAquisicaoTornaProporcional());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalTotal().setConteudo(total);
    }

    private void calculaCustoAquisicaoProporcionalOrigemNacionalRealTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getCustoAquisicaoProporcionalOrigemNacionalReal());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemNacionalRealTotal().setConteudo(total);
    }

    private void calculaCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal().setConteudo(total);
    }

    private void calculaCustoAquisicaoProporcionalOrigemMEDolarTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getCustoAquisicaoProporcionalOrigemMEDolar());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemMEDolarTotal().setConteudo(total);
    }

    private void calculaCustoAquisicaoTornaProporcionalOrigemMEDolarTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemMEDolarTotal().setConteudo(total);
    }
}

