/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.observador;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.ColecaoAlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.consolidacao.Consolidacao;
import java.lang.ref.WeakReference;
import serpro.ppgd.negocio.Observador;

public class ObservadorTotaisConsolidacaoMovel
extends Observador {
    private WeakReference<ColecaoAlienacaoBemMovel> weakColecao;

    public ObservadorTotaisConsolidacaoMovel(ColecaoAlienacaoBemMovel colecao) {
        this.weakColecao = new WeakReference<ColecaoAlienacaoBemMovel>(colecao);
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                this.calcularTotais();
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                this.calcularTotais();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_IMPOSTO_DIFERIDO_ANOS_ANTERIORES)) {
                this.calculaTotalImpostoDiferidoAnosAnteriores();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_REFERENTE_ALIENACAO_ANO_ATUAL)) {
                this.calculaTotalImpostoReferenteAlienacaoAnoAtual();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_IMPOSTO_TOTAL)) {
                this.calculaTotalImpostoTotal();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_VALOR_IRF)) {
                this.calculaTotalValorIRF();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_IMPOSTO_DEVIDO_ANO_ATUAL)) {
                this.calculaTotalImpostoDevidoAnoAtual();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_IMPOSTO_DIFERIDO_ANOS_POSTERIORES)) {
                this.calculaTotalImpostoDiferidoAnosPosteriores();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_TOTAL_IMPOSTO_PAGO)) {
                this.calculaTotalImpostoPago();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_REND_ISENTOS_NAO_TRIBUTAVEIS)) {
                this.calculaTotalRendIsentosNaoTributaveis();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_REND_SUJEITO_TRIBUTACAO_EXCLUSIVA)) {
                this.calculaTotalRendSujeitosTributacao();
            }
        }
    }

    private void calcularTotais() {
        this.calculaTotalImpostoDiferidoAnosAnteriores();
        this.calculaTotalImpostoReferenteAlienacaoAnoAtual();
        this.calculaTotalImpostoTotal();
        this.calculaTotalValorIRF();
        this.calculaTotalImpostoDevidoAnoAtual();
        this.calculaTotalImpostoDiferidoAnosPosteriores();
        this.calculaTotalImpostoPago();
        this.calculaTotalRendIsentosNaoTributaveis();
        this.calculaTotalRendSujeitosTributacao();
    }

    private void calculaTotalImpostoDiferidoAnosAnteriores() {
        ValorPositivo total = new ValorPositivo();
        for (AlienacaoBemMovel alienacao : ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).itens()) {
            total.append('+', alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores());
        }
        ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).getTotalImpostoDiferidoAnosAnteriores().setConteudo(total);
    }

    private void calculaTotalImpostoReferenteAlienacaoAnoAtual() {
        ValorPositivo total = new ValorPositivo();
        for (AlienacaoBemMovel alienacao : ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).itens()) {
            total.append('+', alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual());
        }
        ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).getTotalImpostoReferenteAlienacaoAnoAtual().setConteudo(total);
    }

    private void calculaTotalImpostoTotal() {
        ValorPositivo total = new ValorPositivo();
        for (AlienacaoBemMovel alienacao : ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).itens()) {
            total.append('+', alienacao.getConsolidacao().getImpostoTotal());
        }
        ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).getTotalImpostoTotal().setConteudo(total);
    }

    private void calculaTotalValorIRF() {
        ValorPositivo total = new ValorPositivo();
        for (AlienacaoBemMovel alienacao : ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).itens()) {
            total.append('+', alienacao.getConsolidacao().getValorIRF());
        }
        ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).getTotalValorIRF().setConteudo(total);
    }

    private void calculaTotalImpostoDevidoAnoAtual() {
        ValorPositivo total = new ValorPositivo();
        for (AlienacaoBemMovel alienacao : ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).itens()) {
            total.append('+', alienacao.getConsolidacao().getImpostoDevidoAnoAtual());
        }
        ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).getTotalImpostoDevidoAnoAtual().setConteudo(total);
    }

    private void calculaTotalImpostoDiferidoAnosPosteriores() {
        ValorPositivo total = new ValorPositivo();
        for (AlienacaoBemMovel alienacao : ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).itens()) {
            total.append('+', alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores());
        }
        ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).getTotalImpostoDiferidoAnosPosteriores().setConteudo(total);
    }

    private void calculaTotalImpostoPago() {
        ValorPositivo totalBR = new ValorPositivo();
        ValorPositivo totalEX = new ValorPositivo();
        for (AlienacaoBemMovel alienacao : ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).itens()) {
            if (alienacao.isAlienacaoBrasil()) {
                totalBR.append('+', alienacao.getConsolidacao().getTotalImpostoPago());
                continue;
            }
            totalEX.append('+', alienacao.getConsolidacao().getTotalImpostoPago());
        }
        ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).getTotalImpostoPagoBrasil().setConteudo(totalBR);
        ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).getTotalImpostoPagoExterior().setConteudo(totalEX);
    }

    private void calculaTotalRendIsentosNaoTributaveis() {
        ValorPositivo totalBR = new ValorPositivo();
        ValorPositivo totalEX = new ValorPositivo();
        for (AlienacaoBemMovel alienacao : ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).itens()) {
            if (alienacao.isAlienacaoBrasil()) {
                totalBR.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
                continue;
            }
            totalEX.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).getTotalRendIsentosNaoTributaveisBrasil().setConteudo(totalBR);
        ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).getTotalRendIsentosNaoTributaveisExterior().setConteudo(totalEX);
    }

    private void calculaTotalRendSujeitosTributacao() {
        ValorPositivo totalBR = new ValorPositivo();
        ValorPositivo totalEX = new ValorPositivo();
        for (AlienacaoBemMovel alienacao : ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).itens()) {
            if (alienacao.isAlienacaoBrasil()) {
                totalBR.append('+', alienacao.getConsolidacao().getTotalRendSujeitosTributacao());
                continue;
            }
            totalEX.append('+', alienacao.getConsolidacao().getTotalRendSujeitosTributacao());
        }
        ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).getTotalRendSujeitosTributacaoBrasil().setConteudo(totalBR);
        ((ColecaoAlienacaoBemMovel)((Object)this.weakColecao.get())).getTotalRendSujeitosTributacaoExterior().setConteudo(totalEX);
    }
}

