/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.tabelas;

import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.aquisicao.Aquisicao;
import br.gov.serpro.gcap.entidades.psocietarias.ParcelaAquisicaoParticipacaoSocietaria;
import br.gov.serpro.gcap.tabelas.TabelaDatasIRPF;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.TrataErroSistemicoIf;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.RepositorioTabelasBasicasIf;
import serpro.ppgd.repositorio.repositorioXML.RepositorioTabelasBasicasXML;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class CadastroTabelasGCAP {
    private static Hashtable<String, List<ElementoTabela>> tabelaMunicipios = new Hashtable();
    private static RepositorioTabelasBasicasIRPF repositorioTabelasBasicas = new RepositorioTabelasBasicasIRPF();
    private static List<ElementoTabela> colecaoOrigemRendimentos;
    private static List<ElementoTabela> colecaoNaturezasGCMEBemMovel;
    private static List<ElementoTabela> colecaoNaturezasGCMEBemImovel;
    private static List<ElementoTabela> colecaoNaturezasGCAPBemMovel;
    private static List<ElementoTabela> colecaoNaturezasGCAPBemImovel;
    private static List<ElementoTabela> colecaoPaises;
    private static List<ElementoTabela> colecaoPaisesExterior;
    private static List<ElementoTabela> colecaoUFs;
    private static List<ElementoTabela> colecaoDatasVencimento;
    private static List<ElementoTabela> colecaoAliquotasLei14973;
    private static List<ElementoTabela> colecaoNaturezasParticipacaoSocietaria;
    private static List<ElementoTabela> colecaoEspecieOperacaoPSocietaria;
    private static List<ElementoTabela> colecaoEspecieAquisicaoPSocietaria;
    private static List<ElementoTabela> colecaoMoedas;
    private static List<ElementoTabela> colecaoTipoLogradouro;
    private static List<ElementoTabela> colecaoDependencias;
    private static TrataErroSistemicoIf trataErro;
    private static boolean testarCRC;

    public static List<ElementoTabela> recuperarTiposOrigemRendimentos() {
        if (colecaoOrigemRendimentos == null) {
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, String.valueOf(Aquisicao.CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL));
            e1.setConteudo(1, Aquisicao.DESCRICAO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL);
            ElementoTabela e2 = new ElementoTabela();
            e2.setConteudo(0, String.valueOf(Aquisicao.CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA));
            e2.setConteudo(1, Aquisicao.DESCRICAO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA);
            ElementoTabela e3 = new ElementoTabela();
            e3.setConteudo(0, String.valueOf(Aquisicao.CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA));
            e3.setConteudo(1, Aquisicao.DESCRICAO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA);
            colecaoOrigemRendimentos = new ArrayList<ElementoTabela>();
            colecaoOrigemRendimentos.add(e1);
            colecaoOrigemRendimentos.add(e2);
            colecaoOrigemRendimentos.add(e3);
        }
        return colecaoOrigemRendimentos;
    }

    public static List<ElementoTabela> recuperarNaturezaGCMEBemImovel() {
        if (colecaoNaturezasGCMEBemImovel == null) {
            colecaoNaturezasGCMEBemImovel = new ArrayList<ElementoTabela>();
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_VENDA));
            e1.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_VENDA);
            colecaoNaturezasGCMEBemImovel.add(e1);
            ElementoTabela e2 = new ElementoTabela();
            e2.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA));
            e2.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA);
            colecaoNaturezasGCMEBemImovel.add(e2);
            ElementoTabela e4 = new ElementoTabela();
            e4.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DACAO_EM_PAGAMENTO));
            e4.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DACAO_EM_PAGAMENTO);
            colecaoNaturezasGCMEBemImovel.add(e4);
            ElementoTabela e13 = new ElementoTabela();
            e13.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA));
            e13.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA);
            colecaoNaturezasGCMEBemImovel.add(e13);
            ElementoTabela e5 = new ElementoTabela();
            e5.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTRAS_DOACOES));
            e5.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTRAS_DOACOES);
            colecaoNaturezasGCMEBemImovel.add(e5);
            ElementoTabela e6 = new ElementoTabela();
            e6.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA));
            e6.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA);
            colecaoNaturezasGCMEBemImovel.add(e6);
            ElementoTabela e7 = new ElementoTabela();
            e7.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA));
            e7.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA);
            colecaoNaturezasGCMEBemImovel.add(e7);
            ElementoTabela e8 = new ElementoTabela();
            e8.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_CESSAO_DE_DIREITOS));
            e8.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_CESSAO_DE_DIREITOS);
            colecaoNaturezasGCMEBemImovel.add(e8);
            ElementoTabela e9 = new ElementoTabela();
            e9.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA));
            e9.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA);
            colecaoNaturezasGCMEBemImovel.add(e9);
            ElementoTabela e10 = new ElementoTabela();
            e10.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTROS));
            e10.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTROS);
            colecaoNaturezasGCMEBemImovel.add(e10);
        }
        return colecaoNaturezasGCMEBemImovel;
    }

    public static List<ElementoTabela> recuperarNaturezaGCMEBemMovelDireitos() {
        if (colecaoNaturezasGCMEBemMovel == null) {
            colecaoNaturezasGCMEBemMovel = new ArrayList<ElementoTabela>();
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_VENDA));
            e1.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_VENDA);
            colecaoNaturezasGCMEBemMovel.add(e1);
            ElementoTabela e4 = new ElementoTabela();
            e4.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DACAO_EM_PAGAMENTO));
            e4.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DACAO_EM_PAGAMENTO);
            colecaoNaturezasGCMEBemMovel.add(e4);
            ElementoTabela e13 = new ElementoTabela();
            e13.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA));
            e13.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA);
            colecaoNaturezasGCMEBemMovel.add(e13);
            ElementoTabela e5 = new ElementoTabela();
            e5.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTRAS_DOACOES));
            e5.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTRAS_DOACOES);
            colecaoNaturezasGCMEBemMovel.add(e5);
            ElementoTabela e6 = new ElementoTabela();
            e6.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA));
            e6.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA);
            colecaoNaturezasGCMEBemMovel.add(e6);
            ElementoTabela e7 = new ElementoTabela();
            e7.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA));
            e7.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA);
            colecaoNaturezasGCMEBemMovel.add(e7);
            ElementoTabela e8 = new ElementoTabela();
            e8.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_CESSAO_DE_DIREITOS));
            e8.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_CESSAO_DE_DIREITOS);
            colecaoNaturezasGCMEBemMovel.add(e8);
            ElementoTabela e9 = new ElementoTabela();
            e9.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO));
            e9.setConteudo(1, AlienacaoBem.DESCRICAO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO);
            colecaoNaturezasGCMEBemMovel.add(e9);
            ElementoTabela e10 = new ElementoTabela();
            e10.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL));
            e10.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL);
            colecaoNaturezasGCMEBemMovel.add(e10);
            ElementoTabela e11 = new ElementoTabela();
            e11.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS));
            e11.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_TRASMISSAO_CAUSA_MORTIS);
            colecaoNaturezasGCMEBemMovel.add(e11);
            ElementoTabela e12 = new ElementoTabela();
            e12.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTROS));
            e12.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTROS);
            colecaoNaturezasGCMEBemMovel.add(e12);
        }
        return colecaoNaturezasGCMEBemMovel;
    }

    public static List<ElementoTabela> recuperarNaturezaGCAPBemImovel() {
        if (colecaoNaturezasGCAPBemImovel == null) {
            colecaoNaturezasGCAPBemImovel = new ArrayList<ElementoTabela>();
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_VENDA));
            e1.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_VENDA);
            colecaoNaturezasGCAPBemImovel.add(e1);
            ElementoTabela e3 = new ElementoTabela();
            e3.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DACAO_EM_PAGAMENTO));
            e3.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DACAO_EM_PAGAMENTO);
            colecaoNaturezasGCAPBemImovel.add(e3);
            ElementoTabela e13 = new ElementoTabela();
            e13.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA));
            e13.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA);
            colecaoNaturezasGCAPBemImovel.add(e13);
            ElementoTabela e4 = new ElementoTabela();
            e4.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTRAS_DOACOES));
            e4.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTRAS_DOACOES);
            colecaoNaturezasGCAPBemImovel.add(e4);
            ElementoTabela e5 = new ElementoTabela();
            e5.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA));
            e5.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA);
            colecaoNaturezasGCAPBemImovel.add(e5);
            ElementoTabela e6 = new ElementoTabela();
            e6.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA));
            e6.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA);
            colecaoNaturezasGCAPBemImovel.add(e6);
            ElementoTabela e7 = new ElementoTabela();
            e7.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_CESSAO_DE_DIREITOS));
            e7.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_CESSAO_DE_DIREITOS);
            colecaoNaturezasGCAPBemImovel.add(e7);
            ElementoTabela e8 = new ElementoTabela();
            e8.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL));
            e8.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL);
            colecaoNaturezasGCAPBemImovel.add(e8);
            ElementoTabela e9 = new ElementoTabela();
            e9.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS));
            e9.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_TRASMISSAO_CAUSA_MORTIS);
            colecaoNaturezasGCAPBemImovel.add(e9);
            ElementoTabela e10 = new ElementoTabela();
            e10.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA));
            e10.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA);
            colecaoNaturezasGCAPBemImovel.add(e10);
            ElementoTabela e11 = new ElementoTabela();
            e11.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTROS));
            e11.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTROS);
            colecaoNaturezasGCAPBemImovel.add(e11);
        }
        return colecaoNaturezasGCAPBemImovel;
    }

    public static List<ElementoTabela> recuperarNaturezaGCAPBemMovelDireitos() {
        if (colecaoNaturezasGCAPBemMovel == null) {
            colecaoNaturezasGCAPBemMovel = new ArrayList<ElementoTabela>();
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_VENDA));
            e1.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_VENDA);
            colecaoNaturezasGCAPBemMovel.add(e1);
            ElementoTabela e3 = new ElementoTabela();
            e3.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DACAO_EM_PAGAMENTO));
            e3.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DACAO_EM_PAGAMENTO);
            colecaoNaturezasGCAPBemMovel.add(e3);
            ElementoTabela e13 = new ElementoTabela();
            e13.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA));
            e13.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA);
            colecaoNaturezasGCAPBemMovel.add(e13);
            ElementoTabela e4 = new ElementoTabela();
            e4.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTRAS_DOACOES));
            e4.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTRAS_DOACOES);
            colecaoNaturezasGCAPBemMovel.add(e4);
            ElementoTabela e5 = new ElementoTabela();
            e5.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA));
            e5.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA);
            colecaoNaturezasGCAPBemMovel.add(e5);
            ElementoTabela e6 = new ElementoTabela();
            e6.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA));
            e6.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA);
            colecaoNaturezasGCAPBemMovel.add(e6);
            ElementoTabela e7 = new ElementoTabela();
            e7.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_CESSAO_DE_DIREITOS));
            e7.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_CESSAO_DE_DIREITOS);
            colecaoNaturezasGCAPBemMovel.add(e7);
            ElementoTabela e8 = new ElementoTabela();
            e8.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL));
            e8.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL);
            colecaoNaturezasGCAPBemMovel.add(e8);
            ElementoTabela e9 = new ElementoTabela();
            e9.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS));
            e9.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_TRASMISSAO_CAUSA_MORTIS);
            colecaoNaturezasGCAPBemMovel.add(e9);
            ElementoTabela e10 = new ElementoTabela();
            e10.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTROS));
            e10.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTROS);
            colecaoNaturezasGCAPBemMovel.add(e10);
        }
        return colecaoNaturezasGCAPBemMovel;
    }

    public static List<ElementoTabela> recuperarNaturezaParticipacaoSocietaria() {
        if (colecaoNaturezasParticipacaoSocietaria == null) {
            colecaoNaturezasParticipacaoSocietaria = new ArrayList<ElementoTabela>();
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_ALIENACAO_RESGATES_OUTRAS));
            e1.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_ALIENACAO_RESGATES_OUTRAS);
            colecaoNaturezasParticipacaoSocietaria.add(e1);
            ElementoTabela e2 = new ElementoTabela();
            e2.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS));
            e2.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_TRASMISSAO_CAUSA_MORTIS);
            colecaoNaturezasParticipacaoSocietaria.add(e2);
            ElementoTabela e3 = new ElementoTabela();
            e3.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA));
            e3.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA);
            colecaoNaturezasParticipacaoSocietaria.add(e3);
            ElementoTabela e4 = new ElementoTabela();
            e4.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL));
            e4.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL);
            colecaoNaturezasParticipacaoSocietaria.add(e4);
        }
        return colecaoNaturezasParticipacaoSocietaria;
    }

    public static List<ElementoTabela> recuperarEspecieOperacaoPSocietaria() {
        if (colecaoEspecieOperacaoPSocietaria == null) {
            colecaoEspecieOperacaoPSocietaria = new ArrayList<ElementoTabela>();
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, AlienacaoParticipacaoSocietaria.CODIGO_ESPECIE_ACOES);
            e1.setConteudo(1, AlienacaoParticipacaoSocietaria.DESCRICAO_ESPECIE_ACOES);
            colecaoEspecieOperacaoPSocietaria.add(e1);
            ElementoTabela e2 = new ElementoTabela();
            e2.setConteudo(0, AlienacaoParticipacaoSocietaria.CODIGO_ESPECIE_FII);
            e2.setConteudo(1, AlienacaoParticipacaoSocietaria.DESCRICAO_ESPECIE_FII);
            colecaoEspecieOperacaoPSocietaria.add(e2);
            ElementoTabela e3 = new ElementoTabela();
            e3.setConteudo(0, AlienacaoParticipacaoSocietaria.CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_PARTICIPACOES);
            e3.setConteudo(1, AlienacaoParticipacaoSocietaria.DESCRICAO_ESPECIE_FUNDOS_INVESTIMENTOS_PARTICIPACOES);
            colecaoEspecieOperacaoPSocietaria.add(e3);
            ElementoTabela e4 = new ElementoTabela();
            e4.setConteudo(0, AlienacaoParticipacaoSocietaria.CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_COTAS_FUNDOS_INVESTIMENTOS_PARTICIPACOES);
            e4.setConteudo(1, AlienacaoParticipacaoSocietaria.DESCRICAO_ESPECIE_FUNDOS_INVESTIMENTOS_COTAS_FUNDOS_INVESTIMENTOS_PARTICIPACOES);
            colecaoEspecieOperacaoPSocietaria.add(e4);
            ElementoTabela e5 = new ElementoTabela();
            e5.setConteudo(0, AlienacaoParticipacaoSocietaria.CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_EMPRESAS_EMERGENTES);
            e5.setConteudo(1, AlienacaoParticipacaoSocietaria.DESCRICAO_ESPECIE_FUNDOS_INVESTIMENTOS_EMPRESAS_EMERGENTES);
            colecaoEspecieOperacaoPSocietaria.add(e5);
            ElementoTabela e6 = new ElementoTabela();
            e6.setConteudo(0, AlienacaoParticipacaoSocietaria.CODIGO_ESPECIE_QUOTAS);
            e6.setConteudo(1, AlienacaoParticipacaoSocietaria.DESCRICAO_ESPECIE_QUOTAS);
            colecaoEspecieOperacaoPSocietaria.add(e6);
            ElementoTabela e7 = new ElementoTabela();
            e7.setConteudo(0, AlienacaoParticipacaoSocietaria.CODIGO_ESPECIE_OUTRAS);
            e7.setConteudo(1, AlienacaoParticipacaoSocietaria.DESCRICAO_ESPECIE_OUTRAS);
            colecaoEspecieOperacaoPSocietaria.add(e7);
        }
        return colecaoEspecieOperacaoPSocietaria;
    }

    public static List<ElementoTabela> recuperarEspecieAquisicaoPSAcoes() {
        colecaoEspecieAquisicaoPSocietaria = new ArrayList<ElementoTabela>();
        ElementoTabela e1 = new ElementoTabela();
        e1.setConteudo(0, String.valueOf(ParcelaAquisicaoParticipacaoSocietaria.CODIGO_ACAO_PREFERENCIAL));
        e1.setConteudo(1, ParcelaAquisicaoParticipacaoSocietaria.DESCRICAO_ACAO_PREFERENCIAL);
        colecaoEspecieAquisicaoPSocietaria.add(e1);
        ElementoTabela e2 = new ElementoTabela();
        e2.setConteudo(0, String.valueOf(ParcelaAquisicaoParticipacaoSocietaria.CODIGO_ACAO_ORDINARIA));
        e2.setConteudo(1, ParcelaAquisicaoParticipacaoSocietaria.DESCRICAO_ACAO_ORDINARIA);
        colecaoEspecieAquisicaoPSocietaria.add(e2);
        return colecaoEspecieAquisicaoPSocietaria;
    }

    public static List<ElementoTabela> recuperarEspecieAquisicaoPSQuota() {
        colecaoEspecieAquisicaoPSocietaria = new ArrayList<ElementoTabela>();
        ElementoTabela e1 = new ElementoTabela();
        e1.setConteudo(0, String.valueOf(ParcelaAquisicaoParticipacaoSocietaria.CODIGO_QUOTA));
        e1.setConteudo(1, ParcelaAquisicaoParticipacaoSocietaria.DESCRICAO_QUOTA);
        colecaoEspecieAquisicaoPSocietaria.add(e1);
        return colecaoEspecieAquisicaoPSocietaria;
    }

    public static List<ElementoTabela> recuperarEspecieAquisicaoPSOutras() {
        colecaoEspecieAquisicaoPSocietaria = new ArrayList<ElementoTabela>();
        ElementoTabela e1 = new ElementoTabela();
        e1.setConteudo(0, String.valueOf(ParcelaAquisicaoParticipacaoSocietaria.CODIGO_OUTRAS));
        e1.setConteudo(1, ParcelaAquisicaoParticipacaoSocietaria.DESCRICAO_OUTRAS);
        colecaoEspecieAquisicaoPSocietaria.add(e1);
        return colecaoEspecieAquisicaoPSocietaria;
    }

    public static List<ElementoTabela> recuperarTiposLogradouro() {
        try {
            if (colecaoTipoLogradouro == null) {
                colecaoTipoLogradouro = repositorioTabelasBasicas.recuperarObjetosTabela("tipoLogradouro.xml", testarCRC);
                CadastroTabelasGCAP.ordenarElementosPorColuna(1, colecaoTipoLogradouro);
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoTipoLogradouro;
    }

    public static List<ElementoTabela> recuperarPaises() {
        if (colecaoPaises == null) {
            try {
                colecaoPaises = repositorioTabelasBasicas.recuperarObjetosTabela("paises.xml", testarCRC);
            }
            catch (RepositorioException e) {
                trataErro.trataErroSistemico((Throwable)e);
            }
        }
        return colecaoPaises;
    }

    public static List<ElementoTabela> recuperarPaisesExterior() {
        if (colecaoPaisesExterior == null) {
            try {
                colecaoPaisesExterior = repositorioTabelasBasicas.recuperarObjetosTabela("paises.xml", testarCRC);
                ElementoTabela brasil = null;
                for (ElementoTabela et : colecaoPaisesExterior) {
                    if (et.getConteudo(0).equals("105")) {
                        brasil = et;
                        continue;
                    }
                    String cod = et.getConteudo(0);
                    String desc = et.getConteudo(1);
                    String inParaiso = et.getConteudo(2);
                    et.setConteudo(1, cod + " - " + desc);
                    et.setConteudo(2, desc);
                    et.setConteudo(3, inParaiso);
                }
                colecaoPaisesExterior.remove(brasil);
            }
            catch (RepositorioException e) {
                trataErro.trataErroSistemico((Throwable)e);
            }
        }
        return colecaoPaisesExterior;
    }

    public static List<ElementoTabela> recuperarMoedas() {
        if (colecaoMoedas == null) {
            try {
                colecaoMoedas = repositorioTabelasBasicas.recuperarObjetosTabela("moedas.xml", testarCRC);
            }
            catch (RepositorioException e) {
                trataErro.trataErroSistemico((Throwable)e);
            }
        }
        return colecaoMoedas;
    }

    public static List<ElementoTabela> recuperarUFs(int pColunaDeOrdenacao) {
        try {
            if (colecaoUFs == null) {
                colecaoUFs = repositorioTabelasBasicas.recuperarObjetosTabela("ufssigla.xml", testarCRC);
            }
            CadastroTabelasGCAP.ordenarElementosPorColuna(pColunaDeOrdenacao, colecaoUFs);
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoUFs;
    }

    public static void carregarDatasVencimento() {
        try {
            ArrayList<ElementoTabela> colecaoDatasVencimento = new ArrayList<ElementoTabela>();
            repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.DatasVencimento.getNomeArquivo(), colecaoDatasVencimento, testarCRC);
            CadastroTabelasGCAP.colecaoDatasVencimento = colecaoDatasVencimento;
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static void carregarAliquotasLei14973() {
        try {
            ArrayList<ElementoTabela> colecaoAliquotasLei14973 = new ArrayList<ElementoTabela>();
            repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.AliquotasLei14973.getNomeArquivo(), colecaoAliquotasLei14973, testarCRC);
            CadastroTabelasGCAP.colecaoAliquotasLei14973 = colecaoAliquotasLei14973;
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static List recuperarSiglasUFs(int pColunaDeOrdenacao) {
        try {
            if (colecaoUFs == null) {
                colecaoUFs = repositorioTabelasBasicas.recuperarObjetosTabela("ufssigla.xml", testarCRC);
            }
            CadastroTabelasGCAP.ordenarElementosPorColuna(pColunaDeOrdenacao, colecaoUFs);
            Iterator<ElementoTabela> iterator = colecaoUFs.iterator();
            while (iterator.hasNext()) {
                ElementoTabela o;
                ElementoTabela et = o = iterator.next();
                String cod = et.getConteudo(0);
                et.setConteudo(1, cod);
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoUFs;
    }

    private static void ordenarElementosPorColuna(final int pColuna, List pColecao) {
        Collections.sort(pColecao, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ElementoTabela elemento1 = (ElementoTabela)arg0;
                ElementoTabela elemento2 = (ElementoTabela)arg1;
                if (pColuna >= elemento1.size()) {
                    return UtilitariosString.removeAcentos((String)elemento1.getConteudo(0)).compareTo(UtilitariosString.removeAcentos((String)elemento2.getConteudo(0)));
                }
                return UtilitariosString.removeAcentos((String)elemento1.getConteudo(pColuna)).compareTo(UtilitariosString.removeAcentos((String)elemento2.getConteudo(pColuna)));
            }
        });
    }

    public static List<ElementoTabela> recuperarMunicipios(String uf, int pColunaDeOrdenacao) {
        try {
            if (tabelaMunicipios.containsKey(uf)) {
                return tabelaMunicipios.get(uf);
            }
            List<ElementoTabela> novaColecaoMunicipios = repositorioTabelasBasicas.recuperarObjetosTabela(uf + ".xml", testarCRC);
            CadastroTabelasGCAP.ordenarElementosPorColuna(pColunaDeOrdenacao, novaColecaoMunicipios);
            tabelaMunicipios.put(uf, novaColecaoMunicipios);
            return novaColecaoMunicipios;
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
            return null;
        }
    }

    public static List<ElementoTabela> recuperarDatasVencimento(int colunaOrdenacao) {
        if (colecaoDatasVencimento == null) {
            CadastroTabelasGCAP.carregarDatasVencimento();
        }
        return colecaoDatasVencimento;
    }

    public static List<ElementoTabela> recuperarAliquotasLei14973() {
        if (colecaoAliquotasLei14973 == null) {
            CadastroTabelasGCAP.carregarAliquotasLei14973();
        }
        return colecaoAliquotasLei14973;
    }

    public static void atualizarHash(String arqXml) throws RepositorioException {
        repositorioTabelasBasicas.salvar(arqXml, repositorioTabelasBasicas.recuperarObjetosTabela(arqXml, false));
    }

    public static void main(String[] args) {
        try {
            CadastroTabelasGCAP.atualizarHash("resources/aliquotasLei14973-2024.xml");
        }
        catch (RepositorioException e) {
            e.printStackTrace();
        }
    }

    static {
        trataErro = FabricaTratamentoErro.getTrataErroSistemico();
        testarCRC = true;
    }

    public static class RepositorioTabelasBasicasIRPF
    implements RepositorioTabelasBasicasIf {
        private SimpleDateFormat dtFormat = new SimpleDateFormat("yyyyMMdd");
        private Map<String, String> mapCRCs = new HashMap<String, String>();
        private Map<String, String> mapVigencias = new HashMap<String, String>();

        public Document lerArquivo(String path) {
            Document tabelasDOM = null;
            InputStream in = null;
            in = UtilitariosArquivo.getResource((String)("/" + path), RepositorioTabelasBasicasXML.class);
            if (in == null) {
                try {
                    in = new FileInputStream(System.getProperty("user.dir") + File.separator + "lib" + File.separator + path);
                }
                catch (FileNotFoundException ex) {
                    LogPPGD.erro((String)("Erro tentando ler arquivo: " + path + " via diret\u00f3rio de usu\u00e1rio."));
                }
            }
            if (in == null) {
                try {
                    String caminhoJar = new File(CadastroTabelasGCAP.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParent();
                    in = new FileInputStream(caminhoJar + File.separator + "lib" + File.separator + path);
                }
                catch (FileNotFoundException | URISyntaxException ex) {
                    LogPPGD.erro((String)("Erro tentando ler arquivo: " + path + " via classpath."));
                }
            }
            if (path != null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                try {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    tabelasDOM = builder.parse(in);
                    LogPPGD.debug((String)tabelasDOM.getImplementation().toString());
                }
                catch (SAXParseException e) {
                    LogPPGD.erro((String)("Erro de parsing de " + e.getSystemId() + ". linha " + e.getLineNumber() + ": " + e.getMessage()));
                }
                catch (SAXException e) {
                    Exception x = e;
                    if (e.getException() != null) {
                        x = e.getException();
                    }
                    LogPPGD.erro((String)("Erro de parsing: " + ((Throwable)x).getMessage()));
                }
                catch (ParserConfigurationException e) {
                    LogPPGD.erro((String)("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage()));
                }
                catch (IOException e) {
                    LogPPGD.erro((String)("Erro de I/O: " + e.getMessage()));
                }
            }
            return tabelasDOM;
        }

        public List<ElementoTabela> recuperarObjetosTabela(String pNomeArquivoOuTabela, boolean testarCRC) throws RepositorioException {
            ArrayList<ElementoTabela> lstElementoTabela = new ArrayList<ElementoTabela>();
            this.recuperarObjetosTabela(pNomeArquivoOuTabela, lstElementoTabela, testarCRC);
            return lstElementoTabela;
        }

        public String recuperarObjetosTabela(String pNomeArquivoOuTabela, List<ElementoTabela> lista, boolean testarCRC) throws RepositorioException {
            Element element;
            String CRCLido = null;
            Document tabelasDOM = this.lerArquivo(pNomeArquivoOuTabela);
            if (tabelasDOM != null && (element = tabelasDOM.getDocumentElement()).hasChildNodes()) {
                NodeList filhos = element.getChildNodes();
                String CRCCalculado = "0";
                for (int i = 0; i < filhos.getLength(); ++i) {
                    if (filhos.item(i).getNodeType() != 1) continue;
                    Element elementFilho = (Element)filhos.item(i);
                    CRCLido = elementFilho.getAttribute("CRC");
                    if (CRCLido.equals("")) {
                        String s;
                        int j = 0;
                        do {
                            if ((s = elementFilho.getAttribute("COL" + ++j)).equals("")) continue;
                            CRCCalculado = UtilitariosString.GerarCRC((String)CRCCalculado, (String)s);
                        } while (!s.equals(""));
                        ElementoTabela elementoTabela = new ElementoTabela();
                        for (int k = 1; k < j; ++k) {
                            elementoTabela.setConteudo(k - 1, elementFilho.getAttribute("COL" + k));
                        }
                        if (lista == null) continue;
                        lista.add(elementoTabela);
                        continue;
                    }
                    this.mapCRCs.put(pNomeArquivoOuTabela, CRCLido);
                    String vigencia = elementFilho.getAttribute("VIGENCIA");
                    if (vigencia != null && vigencia.length() > 0) {
                        try {
                            this.dtFormat.parse(vigencia);
                            this.mapVigencias.put(pNomeArquivoOuTabela, vigencia);
                        }
                        catch (ParseException e) {
                            throw new RepositorioXMLException("Data de Vigencia de tabela b\u00e1sica inv\u00e1lida");
                        }
                    }
                    if (CRCLido.compareTo(CRCCalculado) == 0 || !testarCRC) continue;
                    throw new RepositorioXMLException("Checksum de tabela b\u00e1sica inv\u00e1lido");
                }
            }
            if (lista != null && lista.size() == 0) {
                throw new RepositorioXMLException("Tabela b\u00e1sica inv\u00e1lida");
            }
            return CRCLido;
        }

        public void salvar(String pNomeArquivoOuTabela, List<ElementoTabela> lst) throws RepositorioException {
            this.salvar(pNomeArquivoOuTabela, lst, this.dtFormat.format(new Date()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void salvar(String pNomeArquivoOuTabela, List<ElementoTabela> lst, String vigencia) throws RepositorioException {
            Document idsDOM = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            try {
                Element node;
                DocumentBuilder builder = factory.newDocumentBuilder();
                idsDOM = builder.newDocument();
                Element root = idsDOM.createElement("TABELA");
                idsDOM.appendChild(root);
                root.setAttribute("xmlns", ConstantesGlobais.XMLNS);
                String CRCCalculado = "0";
                for (int i = 0; i < lst.size(); ++i) {
                    node = idsDOM.createElement("ITEM");
                    root.appendChild(node);
                    ElementoTabela elementoTabela = lst.get(i);
                    for (int j = 1; j < elementoTabela.size() + 1; ++j) {
                        node.setAttribute("COL" + j, elementoTabela.getConteudo(j - 1));
                        CRCCalculado = UtilitariosString.GerarCRC((String)CRCCalculado, (String)elementoTabela.getConteudo(j - 1));
                    }
                }
                node = idsDOM.createElement("ITEM");
                root.appendChild(node);
                node.setAttribute("CRC", CRCCalculado);
                node.setAttribute("VIGENCIA", vigencia);
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.getMessage());
            }
            idsDOM.normalize();
            try {
                System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
                URL url = RepositorioTabelasBasicasXML.class.getResource("/" + pNomeArquivoOuTabela);
                File arquivoXML = null;
                boolean erro = false;
                try {
                    arquivoXML = new File(url.getPath());
                    if (arquivoXML == null) {
                        erro = true;
                    }
                }
                catch (Exception ex) {
                    erro = true;
                }
                finally {
                    if (erro) {
                        arquivoXML = new File(System.getProperty("user.dir") + File.separator + "lib" + File.separator + pNomeArquivoOuTabela);
                    }
                }
                FileOutputStream os = new FileOutputStream(arquivoXML);
                StreamResult result = new StreamResult(os);
                DOMSource source = new DOMSource(idsDOM);
                TransformerFactory transFactory = TransformerFactory.newInstance();
                String XMLConstants_ACCESS_EXTERNAL_DTD = "http://javax.xml.XMLConstants/property/accessExternalDTD";
                String XMLConstants_ACCESS_EXTERNAL_STYLESHEET = "http://javax.xml.XMLConstants/property/accessExternalStylesheet";
                transFactory.setAttribute(XMLConstants_ACCESS_EXTERNAL_DTD, "");
                transFactory.setAttribute(XMLConstants_ACCESS_EXTERNAL_STYLESHEET, "");
                Transformer transformer = transFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(source, result);
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.getMessage());
            }
        }

        public String getCRC(String nomeArquivo) {
            return this.mapCRCs.get(nomeArquivo);
        }

        public String getVigencia(String nomeArquivo) {
            return this.mapVigencias.get(nomeArquivo);
        }
    }

    public static enum TabelasBasicas {
        DatasVencimento("DATAS", "Vencimentos", new CarregarTabelaIF("resources/datasVencimentoGCAP.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasGCAP.carregarDatasVencimento();
            }
        }),
        DatasIRPF("DATAS_IRPF", "Datas Entrega do IRPF", new CarregarTabelaIF("resources/datasPrazoIrpf.xml"){

            @Override
            public void carregarTabela() {
                TabelaDatasIRPF.carregarDatas();
            }

            @Override
            public String getHash() {
                return TabelaDatasIRPF.getHash();
            }

            @Override
            public String getVersao() {
                return TabelaDatasIRPF.getVersao();
            }
        }),
        AliquotasLei14973("Lei14973", "AliquotasLei14973", new CarregarTabelaIF("resources/aliquotasLei14973-2024.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasGCAP.carregarAliquotasLei14973();
            }
        });

        private String identificador;
        private String descricao;
        private String hash;
        private String versao;
        private CarregarTabelaIF carregadorTabela;

        private TabelasBasicas(String identificador, String descricao, CarregarTabelaIF carregadorTabela) {
            this.descricao = descricao;
            this.identificador = identificador;
            this.carregadorTabela = carregadorTabela;
        }

        public String getIdentificador() {
            return this.identificador;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public void carregarTabela() {
            this.carregadorTabela.carregarTabela();
            this.setHash(this.carregadorTabela.getHash());
            this.setVersao(this.carregadorTabela.getVersao());
        }

        public String getHash() {
            if (this.hash == null) {
                this.carregarTabela();
            }
            return this.hash;
        }

        public String getVersao() {
            if (this.versao == null) {
                this.carregarTabela();
            }
            return this.versao;
        }

        private void setHash(String hash) {
            this.hash = hash;
        }

        private void setVersao(String versao) {
            this.versao = versao;
        }

        public String getNomeArquivo() {
            return this.carregadorTabela.getNomeArquivo();
        }

        private static abstract class CarregarTabelaIF {
            public String nomeArquivo;

            public CarregarTabelaIF(String nomeArquivo) {
                this.nomeArquivo = nomeArquivo;
            }

            public abstract void carregarTabela();

            public String getHash() {
                return repositorioTabelasBasicas.getCRC(this.getNomeArquivo());
            }

            public String getVersao() {
                return repositorioTabelasBasicas.getVigencia(this.getNomeArquivo());
            }

            public String getNomeArquivo() {
                return this.nomeArquivo;
            }
        }
    }
}

