/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.tabelas;

import br.gov.serpro.gcap.exception.AplicacaoException;
import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import br.gov.serpro.gcap.util.DataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.repositorio.RepositorioException;

public class TabelaDatasIRPF {
    private static Map<String, String> datas = new HashMap<String, String>();
    private static CadastroTabelasGCAP.RepositorioTabelasBasicasIRPF repositorioTabelasBasicas = new CadastroTabelasGCAP.RepositorioTabelasBasicasIRPF();
    public static final String NOME_ARQUIVO_DATAS_IRPF = "resources/datasPrazoIrpf.xml";

    public static Map<String, String> getDatas() {
        if (datas.isEmpty()) {
            TabelaDatasIRPF.carregarDatas();
        }
        return datas;
    }

    public static String obterVencimentoExercicio(String exercicio) throws AplicacaoException {
        return DataUtil.converterFormatoDatayyyyMMddParaddMMyyyy(TabelaDatasIRPF.getDatas().get("irpf" + exercicio), true);
    }

    public static void carregarDatas() {
        ArrayList<ElementoTabela> colecaoDatas = new ArrayList<ElementoTabela>();
        try {
            repositorioTabelasBasicas.recuperarObjetosTabela(NOME_ARQUIVO_DATAS_IRPF, colecaoDatas, true);
            datas.clear();
            for (ElementoTabela et : colecaoDatas) {
                datas.put(et.getConteudo(0), et.getConteudo(1));
            }
        }
        catch (RepositorioException e) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico((Throwable)e);
        }
    }

    public static String getHash() {
        return repositorioTabelasBasicas.getCRC(NOME_ARQUIVO_DATAS_IRPF);
    }

    public static String getVersao() {
        return repositorioTabelasBasicas.getVigencia(NOME_ARQUIVO_DATAS_IRPF);
    }
}

