/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.txt.gravacaorestauracao;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import java.io.File;
import java.io.IOException;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.negocio.ConstantesGlobais;

public class ImportadorTxt {
    private RepositorioDeclaracaoCentralTxt repositorioTxt;

    public static ImportadorTxt getInstanciaArqExercicioAnterior(File file) throws GeracaoTxtException {
        ImportadorTxt importador = new ImportadorTxt();
        importador.setRepositorioTxt(new RepositorioDeclaracaoCentralTxt("ARQ_COPIA_SEG_ANO_ANTERIOR", file));
        return importador;
    }

    public IdDemonstrativoGCAP importarIdDeclaracao() throws GeracaoTxtException, IOException {
        return this.getRepositorioTxt().recuperarIdDeclaracao();
    }

    public void importarDeclaracao(DemonstrativoGCAP dec) throws Exception {
        if (this.getRepositorioTxt().getArquivo().getTipoArquivo().equals("ARQ_COPIA_SEG_ANO_ANTERIOR")) {
            this.getRepositorioTxt().importarDeclaracaoAnoAnterior(dec);
        }
    }

    public void restaurarDeclaracao(File file) throws Exception {
        if (this.getRepositorioTxt() == null) {
            this.setRepositorioTxt(new RepositorioDeclaracaoCentralTxt("ARQ_COPIA_SEG", file));
        }
        IdDemonstrativoGCAP idDecl = this.getRepositorioTxt().recuperarIdDeclaracao();
        if (file.toString().toUpperCase().endsWith(".DEC")) {
            this.getRepositorioTxt().lerDeclaracaoValidando();
        }
        this.getRepositorioTxt().recuperarDeclaracao(idDecl);
    }

    public IdDemonstrativoGCAP restaurarIdDeclaracao(File file) throws GeracaoTxtException, IOException {
        if (this.getRepositorioTxt() == null) {
            this.setRepositorioTxt(new RepositorioDeclaracaoCentralTxt("ARQ_COPIA_SEG", file));
        }
        return this.getRepositorioTxt().recuperarIdDeclaracaoNaoPersistido();
    }

    public boolean existeDeclaracaoExercicioAtual(File file, boolean fileEhAnoAnterior) throws GeracaoTxtException, IOException {
        if (this.getRepositorioTxt() == null) {
            this.setRepositorioTxt(new RepositorioDeclaracaoCentralTxt("ARQ_COPIA_SEG", file));
        }
        IdDemonstrativoGCAP idDecl = null;
        idDecl = fileEhAnoAnterior ? this.getRepositorioTxt().recuperarIdDeclaracaoNaoPersistidoAnoAnterior() : this.getRepositorioTxt().recuperarIdDeclaracaoNaoPersistido();
        idDecl.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
        return GCAPFacade.existeDeclaracao(idDecl);
    }

    protected RepositorioDeclaracaoCentralTxt getRepositorioTxt() {
        return this.repositorioTxt;
    }

    public void setRepositorioTxt(RepositorioDeclaracaoCentralTxt repositorioTxt) {
        this.repositorioTxt = repositorioTxt;
    }
}

