/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.util;

import br.gov.serpro.gcap.exception.AplicacaoException;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.DataHora;
import serpro.ppgd.negocio.RetornoValidacao;

public class DataUtil {
    public static Date obterDataAtual() {
        return new Date();
    }

    public static Integer obterAnoExercicio() {
        String lAnoExercicio = AplicacaoPropertiesUtil.getExercicio();
        return new Integer(lAnoExercicio);
    }

    public static Integer obterAnoAnteriorExercicio() {
        return DataUtil.obterAnoExercicio() - 1;
    }

    public static boolean isDataHoje(Date pData) {
        Calendar lHoje = Calendar.getInstance();
        DataUtil.zerarHorario(lHoje);
        Calendar lData = Calendar.getInstance();
        lData.setTime(pData);
        DataUtil.zerarHorario(lData);
        return lHoje.equals(lData);
    }

    public static boolean isDataHoje(Data pData) {
        return DataUtil.isDataHoje(pData.asDate());
    }

    public static boolean isDataHoje(DataHora pData) {
        return DataUtil.isDataHoje(pData.asDate());
    }

    public static void zerarHorario(Calendar pCalendario) {
        pCalendario.set(11, 0);
        pCalendario.set(12, 0);
        pCalendario.set(13, 0);
        pCalendario.set(14, 0);
    }

    public static void zerarData(Calendar pCalendario) {
        pCalendario.set(5, 0);
        pCalendario.set(2, 0);
        pCalendario.set(1, 0);
    }

    public static boolean isDataNoAnoExercicio(Data data) {
        if (!data.isVazio()) {
            String anoAtual = DataUtil.obterAnoExercicio().toString();
            if (data.getAno().equals(anoAtual)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAnoDataAnteriorAoAnoExercicio(Data data) {
        try {
            if (data.asString().trim().length() == 0) {
                return false;
            }
            if (new Integer(data.getAno()) < DataUtil.obterAnoExercicio()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isAnoDataAnteriorAoAnoExercicioGCAP(Data data) {
        try {
            if (data.naoFormatado().trim().length() == 0) {
                return false;
            }
            if (Integer.valueOf(data.getAno()) < DataUtil.obterAnoExercicio() - 1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isAnoDataAnteriorAno(Data data, Integer pAno) {
        try {
            if (data.asString().trim().length() == 0) {
                return false;
            }
            if (new Integer(data.getAno()) < pAno) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean verificarIntercecaoPeriodos(Date pDataInicio1, Date pDataFim1, Date pDataInicio2, Date pDataFim2) {
        return pDataFim1.after(pDataInicio2) && pDataInicio1.before(pDataFim2);
    }

    public static boolean verificarIntercecaoPeriodos(Data pDataInicio1, Data pDataFim1, Data pDataInicio2, Data pDataFim2) {
        return DataUtil.verificarIntercecaoPeriodos(pDataInicio1.asDate(), pDataFim1.asDate(), pDataInicio2.asDate(), pDataFim2.asDate());
    }

    public static Date getPrimeiroDiaDoAno() {
        String pAnoExercicio = AplicacaoPropertiesUtil.getExercicio();
        Calendar lCal = Calendar.getInstance();
        lCal.set(1, Integer.parseInt(pAnoExercicio));
        lCal.set(5, 1);
        lCal.set(2, 0);
        return lCal.getTime();
    }

    public static Date getUltimoDiaDoAno() {
        String pAnoExercicio = AplicacaoPropertiesUtil.getExercicio();
        Calendar lCal = Calendar.getInstance();
        lCal.set(1, Integer.parseInt(pAnoExercicio));
        lCal.set(5, 31);
        lCal.set(2, 11);
        return lCal.getTime();
    }

    public static boolean isDataValida(Data pData) {
        return pData != null && pData.validar().isTodosValidos();
    }

    public static String obterPrimeiroDiaAposDataInformada(String data) {
        Data dataAux = new Data();
        dataAux.setConteudo(data);
        Calendar c = Calendar.getInstance(new Locale("pt", "BR"));
        c.set(1, Integer.valueOf(dataAux.getAno()));
        c.set(2, Integer.valueOf(dataAux.getMes()) - 1);
        c.set(5, Integer.valueOf(dataAux.getDia()));
        c.add(5, 1);
        return DataUtil.formatarData(c.getTime());
    }

    public static int getNumeroMesPorNomeExtenso(String nomeMes) {
        if (nomeMes.equalsIgnoreCase("janeiro")) {
            return 0;
        }
        if (nomeMes.equalsIgnoreCase("fevereiro")) {
            return 1;
        }
        if (nomeMes.equalsIgnoreCase("mar\u00e7o") || nomeMes.equalsIgnoreCase("marco")) {
            return 2;
        }
        if (nomeMes.equalsIgnoreCase("abril")) {
            return 3;
        }
        if (nomeMes.equalsIgnoreCase("maio")) {
            return 4;
        }
        if (nomeMes.equalsIgnoreCase("junho")) {
            return 5;
        }
        if (nomeMes.equalsIgnoreCase("julho")) {
            return 6;
        }
        if (nomeMes.equalsIgnoreCase("agosto")) {
            return 7;
        }
        if (nomeMes.equalsIgnoreCase("setembro")) {
            return 8;
        }
        if (nomeMes.equalsIgnoreCase("outubro")) {
            return 9;
        }
        if (nomeMes.equalsIgnoreCase("novembro")) {
            return 10;
        }
        if (nomeMes.equalsIgnoreCase("dezembro")) {
            return 11;
        }
        return -1;
    }

    public static int obterAnoEmQuatroDigitos(int ano) {
        Object anoString = Integer.valueOf(ano).toString();
        if (((String)anoString).length() <= 2) {
            int dezenaAnoExercicio = Integer.parseInt(ConstantesGlobais.EXERCICIO.substring(2));
            int anoInt = Integer.parseInt((String)anoString);
            anoString = anoInt >= 0 && anoInt < 10 ? "200" + String.valueOf(anoInt) : (anoInt >= 10 && anoInt <= dezenaAnoExercicio ? "20" + String.valueOf(anoInt) : "19" + String.valueOf(anoInt));
            ano = Integer.valueOf((String)anoString);
        }
        return ano;
    }

    public static Date obterUltimoDiaMes(int ano, int mes) {
        Calendar.getInstance().getActualMaximum(5);
        Calendar c = Calendar.getInstance(new Locale("pt", "BR"));
        c.clear();
        c.set(ano, mes - 1, 1);
        c.set(5, c.getActualMaximum(5));
        return c.getTime();
    }

    public static RetornoValidacao validarData(String data, int anoLimite) {
        int inAno;
        int inMes;
        int inDia;
        if (data == null || data.equals("  /  /    ")) {
            return new RetornoValidacao("Data inv\u00e1lida", 3);
        }
        int maxDia = 31;
        StringTokenizer tokenizer = new StringTokenizer(data, "/");
        if (tokenizer.countTokens() != 3) {
            return new RetornoValidacao("Data inv\u00e1lida", 3);
        }
        String token = tokenizer.nextToken();
        try {
            inDia = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao("Data com dia inv\u00e1lido", 3);
        }
        token = tokenizer.nextToken();
        try {
            inMes = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao("Data inv\u00e1lida", 3);
        }
        token = tokenizer.nextToken();
        try {
            inAno = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao("Data com ano inv\u00e1lido", 3);
        }
        if (inMes <= 0 || inMes >= 13) {
            return new RetornoValidacao("Data inv\u00e1lida", 3);
        }
        if (inAno <= 0 || inAno >= anoLimite || inAno < 1851 && inAno != 0) {
            return new RetornoValidacao("Data com ano inv\u00e1lido", 3);
        }
        maxDia = DataUtil.calculaDiasMes(inMes, inAno);
        if (inDia <= 0 || inDia > maxDia) {
            if (maxDia == 28 && inDia == 29) {
                return new RetornoValidacao("Confirma dia, m\u00eas e ano da data de nascimento?", 2);
            }
            return new RetornoValidacao("Data com dia inv\u00e1lido", 3);
        }
        if (inAno <= 0 || inAno >= anoLimite || inAno < 1851 && inAno != 0) {
            return new RetornoValidacao("Data com ano inv\u00e1lido", 3);
        }
        if (inAno < 1901 && inAno > 1850) {
            return new RetornoValidacao("O ano da data informada \u00e9 anterior a " + (DataUtil.obterAnoExercicio() - 200) + ".", 2);
        }
        return null;
    }

    private static int calculaDiasMes(int mes, int ano) {
        int retorno = 31;
        switch (mes) {
            case 1: {
                retorno = 31;
                break;
            }
            case 2: {
                GregorianCalendar calendar = new GregorianCalendar();
                if (calendar.isLeapYear(ano)) {
                    retorno = 29;
                    break;
                }
                retorno = 28;
                break;
            }
            case 3: {
                retorno = 31;
                break;
            }
            case 4: {
                retorno = 30;
                break;
            }
            case 5: {
                retorno = 31;
                break;
            }
            case 6: {
                retorno = 30;
                break;
            }
            case 7: {
                retorno = 31;
                break;
            }
            case 8: {
                retorno = 31;
                break;
            }
            case 9: {
                retorno = 30;
                break;
            }
            case 10: {
                retorno = 31;
                break;
            }
            case 11: {
                retorno = 30;
                break;
            }
            case 12: {
                retorno = 31;
            }
        }
        return retorno;
    }

    public static boolean isDataAposExercicio(Data lData) {
        try {
            if (!lData.isVazio()) {
                int anoAtual = Integer.valueOf(DataUtil.obterAnoExercicio().toString());
                int anoData = Integer.valueOf(lData.getAno());
                if (anoData > anoAtual) {
                    return true;
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isDataPreenchida(Data data) {
        boolean valida = true;
        try {
            int ano = Integer.parseInt(data.getAno());
            int mes = Integer.parseInt(data.getMes());
            int n = Integer.parseInt(data.getDia());
        }
        catch (Exception ex) {
            valida = false;
        }
        return valida;
    }

    public static String formatarDataSemBarras(Date pData) {
        SimpleDateFormat lSdf = new SimpleDateFormat("ddMMyyyy");
        return lSdf.format(pData);
    }

    public static String formatarData(Date pData) {
        SimpleDateFormat lSdf = new SimpleDateFormat("dd/MM/yyyy");
        return lSdf.format(pData);
    }

    public static String converterFormatoDatayyyyMMddParaddMMyyyy(String yyyyMMdd, boolean incluirBarras) throws AplicacaoException {
        if (yyyyMMdd.length() == 8) {
            String dataFormatada = null;
            dataFormatada = incluirBarras ? yyyyMMdd.substring(6) + "/" + yyyyMMdd.substring(4, 6) + "/" + yyyyMMdd.substring(0, 4) : yyyyMMdd.substring(6) + yyyyMMdd.substring(4, 6) + yyyyMMdd.substring(0, 4);
            return dataFormatada;
        }
        throw new AplicacaoException("tabela.datasVencimento.data.invalida");
    }
}

