/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.util;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.gui.ControladorGui;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class GcapUtil {
    private static final String ARQUIVO_INI = "GCAP.INI";
    public static final int EM_TELA_PRINCIPAL = -1;
    public static final int EM_PREENCHIMENTO = 0;
    public static final int EM_PENDENCIA = 1;
    public static final int EM_IMPORTACAO = 2;
    private static String nomeArquivo = null;
    private static int estadoSistema = 0;
    public static String DIR_DADOS;
    public static String DIR_TMP;
    public static String PATH_XML_ID_DEMONSTRATIVOS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String abreArquivo(String pFilePath) {
        StringBuilder lConteudo = new StringBuilder(200);
        InputStream lInputStream = null;
        InputStreamReader lInputStreamReader = null;
        BufferedReader lBuffer = null;
        try {
            lInputStream = GcapUtil.class.getResourceAsStream(pFilePath);
            lInputStreamReader = new InputStreamReader(lInputStream);
            lBuffer = new BufferedReader(lInputStreamReader);
            String lLinha = null;
            while ((lLinha = lBuffer.readLine()) != null) {
                lConteudo.append(lLinha);
                lConteudo.append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException e) {
            ControladorGui.tratarException(e);
        }
        catch (IOException e) {
            ControladorGui.tratarException(e);
        }
        finally {
            try {
                lBuffer.close();
                lInputStreamReader.close();
                lInputStream.close();
            }
            catch (Exception e) {}
        }
        return lConteudo.toString();
    }

    public static boolean isDeclaracaoBrasileira(Alienacao alienacao) {
        return "105".equals(alienacao.getPaisResidencia().naoFormatado());
    }

    public static boolean isDeclaracaoBrasileira() {
        return true;
    }

    public static void desabilitarValidadores(Informacao<?> info) {
        List validadores = info.getListaValidadores();
        for (ValidadorIf v : validadores) {
            ((ValidadorDefault)v).setValidadorAtivo(false);
        }
    }

    public static void habilitarValidadores(Informacao<?> info) {
        List validadores = info.getListaValidadores();
        for (ValidadorIf v : validadores) {
            ((ValidadorDefault)v).setValidadorAtivo(true);
        }
    }

    public static ValorPositivo getPercentualLei7713(Integer pAno) {
        if (!GcapUtil.isDeclaracaoBrasileira()) {
            return new ValorPositivo();
        }
        ValorPositivo percentual = new ValorPositivo();
        return percentual;
    }

    public static ValorPositivo getPercentualFR2Lei11196(Integer pMesAquisicao, Integer pAnoAquisicao, Data pDataAlienacao) {
        ValorPositivo percentual;
        Integer mesAlienacao;
        Integer anoAlienacao;
        if (!GcapUtil.isDeclaracaoBrasileira()) {
            ValorPositivo valor = new ValorPositivo();
            valor.setConteudo("0,00");
            return valor;
        }
        try {
            anoAlienacao = new Integer(pDataAlienacao.getAno());
            mesAlienacao = new Integer(pDataAlienacao.getMes());
        }
        catch (Exception e) {
            return new ValorPositivo();
        }
        if (anoAlienacao < 2005 || anoAlienacao == 2005 && mesAlienacao < 12) {
            percentual = new ValorPositivo(null, null, 3, 6);
        } else {
            Long mesReferencia;
            Long anoReferencia;
            if (pAnoAquisicao < 2005) {
                anoReferencia = 2005L;
                mesReferencia = 12L;
            } else {
                anoReferencia = pAnoAquisicao.longValue();
                mesReferencia = pAnoAquisicao == 2005 ? Long.valueOf(12L) : Long.valueOf(pMesAquisicao.longValue());
            }
            Long m2 = ((long)anoAlienacao.intValue() - anoReferencia) * 12L + ((long)mesAlienacao.intValue() - mesReferencia) + 1L;
            ValorPositivo lFracao = new ValorPositivo();
            lFracao.setConteudo(100L);
            lFracao.converteQtdCasasDecimais(6);
            lFracao.append('/', new BigDecimal(Math.pow(1.0035, m2.longValue())).toString());
            percentual = new ValorPositivo();
            percentual.setConteudo(100L);
            percentual.converteQtdCasasDecimais(6);
            percentual.append('-', lFracao);
        }
        return percentual;
    }

    public static ValorPositivo getPercentualFR1Lei11196(Integer pAno, Integer pMes) {
        ValorPositivo percentual;
        if (!GcapUtil.isDeclaracaoBrasileira()) {
            ValorPositivo valor = new ValorPositivo();
            valor.setConteudo("0,00");
            return valor;
        }
        if (pAno > 2005 || pAno == 2005 && pMes > 11) {
            percentual = new ValorPositivo();
        } else {
            Long mesReferencia;
            Long anoReferencia;
            if (pAno < 1996) {
                anoReferencia = 1996L;
                mesReferencia = 1L;
            } else {
                anoReferencia = pAno.longValue();
                mesReferencia = pMes.longValue();
            }
            Long m1 = (2005L - anoReferencia) * 12L + (11L - mesReferencia) + 1L;
            ValorPositivo lFracao = new ValorPositivo();
            lFracao.setConteudo(100L);
            lFracao.converteQtdCasasDecimais(6);
            lFracao.append('/', String.valueOf(Math.pow(1.006, m1.longValue())));
            percentual = new ValorPositivo();
            percentual.setConteudo(100L);
            percentual.converteQtdCasasDecimais(6);
            percentual.append('-', lFracao);
        }
        return percentual;
    }

    public static void setEstadoSistema(int estadoSistema) {
        GcapUtil.estadoSistema = estadoSistema;
    }

    public static int getEstadoSistema() {
        return estadoSistema;
    }

    public static boolean deleteDir(String dir) {
        return GcapUtil.deleteDir(new File(dir));
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = GcapUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    static {
        String executandoSobJWS = System.getProperty("ppgd.jws");
        if (executandoSobJWS != null && executandoSobJWS.trim().equals("true")) {
            DIR_DADOS = System.getProperty("user.home") + "/GCAP" + ConstantesGlobais.EXERCICIO + "/aplicacao/dados";
        } else {
            String arqConf = UtilitariosArquivo.getPathAplicacao() + ARQUIVO_INI;
            if (new File(arqConf).exists()) {
                try {
                    Properties prop = new Properties();
                    prop.load(new FileInputStream(arqConf));
                    String dirDados = (String)prop.get("aplicacao.diretorio.dados");
                    if (!dirDados.trim().equals("")) {
                        FabricaUtilitarios.getProperties().setProperty("aplicacao.diretorio.dados", dirDados);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            DIR_DADOS = UtilitariosArquivo.getPathDados();
            DIR_TMP = DIR_DADOS + System.getProperty("file.separator") + "tmp";
            PATH_XML_ID_DEMONSTRATIVOS = DIR_DADOS + File.separator + "iddemonstrativos.xml";
        }
    }
}

