/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.util;

import java.io.UnsupportedEncodingException;
import java.util.Random;

public final class ObfuscatedString {
    private static final String UTF8 = new String(new char[]{'U', 'T', 'F', '8'});
    private final long[] obfuscated;

    private static void appendHexLiteral(StringBuffer sb, long l) {
        sb.append('0');
        sb.append('x');
        sb.append(Long.toHexString(l).toUpperCase());
        sb.append('L');
    }

    private static long toLong(byte[] bytes, int off) {
        int end = Math.min(bytes.length, off + 8);
        long l = 0L;
        int i = end;
        while (--i >= off) {
            l <<= 8;
            l |= (long)(bytes[i] & 0xFF);
        }
        return l;
    }

    private static void toBytes(long l, byte[] bytes, int off) {
        int end = Math.min(bytes.length, off + 8);
        for (int i = off; i < end; ++i) {
            bytes[i] = (byte)l;
            l >>= 8;
        }
    }

    public ObfuscatedString(long[] obfuscated) {
        this.obfuscated = (long[])obfuscated.clone();
        this.obfuscated[0] = obfuscated[0];
    }

    public String toString() {
        String decoded;
        int length = this.obfuscated.length;
        byte[] encoded = new byte[8 * (length - 1)];
        long seed = this.obfuscated[0];
        Random prng = new Random(seed);
        for (int i = 1; i < length; ++i) {
            long key = prng.nextLong();
            ObfuscatedString.toBytes(this.obfuscated[i] ^ key, encoded, 8 * (i - 1));
        }
        try {
            decoded = new String(encoded, UTF8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
        int i = decoded.indexOf(0);
        return -1 == i ? decoded : decoded.substring(0, i);
    }
}

