/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import ml.options.Options;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class OpcoesApp {
    private static final String ARG_NO_LOG = "-nolog";
    private Options opt;

    public OpcoesApp(String[] args) {
        this.opt = new Options(args);
        this.opt.getSet().addOption(ARG_NO_LOG, Options.Multiplicity.ZERO_OR_ONE);
    }

    public void processaArgs() {
        if (!this.opt.check()) {
            System.out.println(this.opt.getCheckErrors());
        } else {
            this.argNoLog();
        }
    }

    private void argNoLog() {
        if (this.opt.getSet().isSet(ARG_NO_LOG)) {
            System.out.println("Desligando log...");
        } else {
            String nomeArquivoLog = ConstantesGlobais.NOME_PROGRAMA + ConstantesGlobais.EXERCICIO + ".log";
            System.out.println("Redirecionando msgs de erro para '" + nomeArquivoLog + "'...");
            try {
                String pathArquivoLog = null;
                pathArquivoLog = FabricaUtilitarios.isLinux() || FabricaUtilitarios.isMac() ? UtilitariosArquivo.getPathUsuario() : UtilitariosArquivo.getPathAplicacao();
                File diretorio = new File(pathArquivoLog);
                if (diretorio.exists() || !diretorio.mkdirs()) {
                    // empty if block
                }
                System.setErr(new PrintStream(new FileOutputStream(new File(diretorio, nomeArquivoLog), true)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            System.err.println("Sistema: " + System.getProperty("os.name"));
            System.err.println("Java: " + System.getProperty("java.version"));
        }
    }
}

