/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.util.update;

import br.gov.serpro.gcap.exception.AplicacaoException;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.ConstantesGlobaisGCAP;
import br.gov.serpro.gcap.util.update.PGDAppUpdateProperties;
import br.gov.serpro.updater.AtualizacaoException;
import br.gov.serpro.updater.PgdUpdater;
import br.gov.serpro.updater.ReleaseUpdateProperties;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import jupar.Downloader;
import jupar.objects.Release;
import org.apache.commons.io.FileUtils;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class PGDAppUpdater {
    public final String SIGLA_PROGRAMA;
    public final String NOME_REDUZIDO_PROGRAMA;
    public final String NOME_ARQ_LATEST = "latest.xml";
    public final String NOME_ARQ_PROPRIEDADES = "release_properties.xml";
    public final String NOME_ARQ_UPDATE_JAR = "pgd-updater.jar";
    public final String SEPARADOR_PARAMETROS_COMANDO = "#";
    public final String PATH_PASTA_UPDATE_DESENVOLVIMENTO;
    public final String PATH_PASTA_UPDATE_HOMOLOGACAO;
    public final String PATH_PASTA_UPDATE_PRODUCAO;
    public final String PATH_PASTA_UPDATE_HOMOLOGACAO_IRPF;
    public final String PATH_PASTA_UPDATE_PRODUCAO_IRPF;
    public final String PATH_ENDERECO_UPDATE_DESENVOLVIMENTO;
    public final String PATH_ENDERECO_UPDATE_HOMOLOGACAO;
    public final String PATH_ENDERECO_UPDATE_PRODUCAO;
    public final String NOME_PASTA_TEMP;
    public final String NOME_PASTA_APLICATIVO;
    public final String NOME_APP_MAC;
    public final String NOME_EXE_WIN;
    public final String NOME_APLICATIVO_JAR;
    public static int TIPO_AMBIENTE_UPDATER_DESENVOLVIMENTO = 1;
    public static int TIPO_AMBIENTE_UPDATER_HOMOLOGACAO = 2;
    public static int TIPO_AMBIENTE_UPDATER_PRODUCAO = 3;
    private int ambienteUpdater;
    private PgdUpdater updater;
    private File pastaBase;
    private static PGDAppUpdater instance = null;
    private Release ultimaVersao;

    protected PGDAppUpdater() {
        this.NOME_REDUZIDO_PROGRAMA = this.SIGLA_PROGRAMA = ConstantesGlobais.NOME_PROGRAMA;
        this.NOME_ARQ_LATEST = "latest.xml";
        this.NOME_ARQ_PROPRIEDADES = "release_properties.xml";
        this.NOME_ARQ_UPDATE_JAR = "pgd-updater.jar";
        this.SEPARADOR_PARAMETROS_COMANDO = "#";
        this.PATH_PASTA_UPDATE_DESENVOLVIMENTO = "http://webdesdr.sdr.serpro/de5ps/" + this.SIGLA_PROGRAMA.toLowerCase() + "-update-desenvolvimento/";
        this.PATH_PASTA_UPDATE_HOMOLOGACAO = "https://downloadirpf.receita.fazenda.gov.br/irpf/HOM/" + ConstantesGlobais.EXERCICIO + "/" + this.NOME_REDUZIDO_PROGRAMA.toLowerCase() + "/update/";
        this.PATH_PASTA_UPDATE_PRODUCAO = "https://downloadirpf.receita.fazenda.gov.br/irpf/" + ConstantesGlobais.EXERCICIO + "/" + this.NOME_REDUZIDO_PROGRAMA.toLowerCase() + "/update/";
        this.PATH_PASTA_UPDATE_HOMOLOGACAO_IRPF = "https://downloadirpf.receita.fazenda.gov.br/irpf/HOM/" + ConstantesGlobais.EXERCICIO + "/update/";
        this.PATH_PASTA_UPDATE_PRODUCAO_IRPF = "https://downloadirpf.receita.fazenda.gov.br/irpf/" + ConstantesGlobais.EXERCICIO + "/irpf/update/";
        this.PATH_ENDERECO_UPDATE_DESENVOLVIMENTO = this.PATH_PASTA_UPDATE_DESENVOLVIMENTO + "latest.xml";
        this.PATH_ENDERECO_UPDATE_HOMOLOGACAO = this.PATH_PASTA_UPDATE_HOMOLOGACAO + "latest.xml";
        this.PATH_ENDERECO_UPDATE_PRODUCAO = this.PATH_PASTA_UPDATE_PRODUCAO + "latest.xml";
        this.NOME_PASTA_TEMP = "tmp_" + this.SIGLA_PROGRAMA + ConstantesGlobais.EXERCICIO;
        this.NOME_PASTA_APLICATIVO = "." + this.SIGLA_PROGRAMA.toLowerCase();
        this.NOME_APP_MAC = this.SIGLA_PROGRAMA + ConstantesGlobais.EXERCICIO + ".app";
        this.NOME_EXE_WIN = this.SIGLA_PROGRAMA + ConstantesGlobais.EXERCICIO + ".exe";
        this.NOME_APLICATIVO_JAR = this.SIGLA_PROGRAMA + ".jar";
        this.ambienteUpdater = TIPO_AMBIENTE_UPDATER_HOMOLOGACAO;
        this.updater = null;
        this.pastaBase = null;
    }

    public static PGDAppUpdater getInstance() {
        if (instance == null) {
            instance = new PGDAppUpdater();
        }
        return instance;
    }

    protected PgdUpdater getPgdUpdater() {
        if (this.updater == null) {
            this.updater = new PgdUpdater();
            this.updater.setReleasePropertiesPath(new File(UtilitariosArquivo.getPathDados() + File.separator + "release_properties.xml").getAbsolutePath());
            try {
                this.updater.setLogFile(new File(UtilitariosArquivo.getPathUsuario() + File.separator + "updater.log"));
            }
            catch (AtualizacaoException e) {
                e.printStackTrace();
            }
        }
        return this.updater;
    }

    protected String obterIdentificadorVersao(String versao, String release) {
        Object strVersao = versao;
        try {
            if (release != null && release.trim().length() > 0 && Integer.parseInt(release) > 0) {
                strVersao = (String)strVersao + "_Testes_" + release;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strVersao;
    }

    protected PGDAppUpdateProperties obterUpdateProperties(Release latest) throws AplicacaoException {
        try {
            String ultimaVersao = this.obterIdentificadorVersao(latest.getPkgver(), latest.getPkgrel());
            String versaoAtual = this.obterIdentificadorVersao(AplicacaoPropertiesUtil.getVersao(), ConstantesGlobaisGCAP.VERSAO_TESTES ? AplicacaoPropertiesUtil.getVersaoTeste() : null);
            Gson g = new Gson();
            PGDAppUpdateProperties updateProperties = (PGDAppUpdateProperties)g.fromJson(latest.getMessage(), PGDAppUpdateProperties.class);
            updateProperties.setUltimaVersao(ultimaVersao);
            updateProperties.setVersaoAtual(versaoAtual);
            updateProperties.setTipoAtualizacao(PGDAppUpdateProperties.TipoAtualizacao.valueOf(latest.getSeverity()));
            if (updateProperties.getArquivoZip() != null && updateProperties.getArquivoZip().trim().length() > 0) {
                updateProperties.setArquivoZip(updateProperties.getArquivoZip().replaceAll("\\@", updateProperties.getVersaoAtual() + "_update_" + updateProperties.getUltimaVersao()));
            }
            if (updateProperties.getUltimaVersaoManual() != null && !updateProperties.getUltimaVersaoManual().trim().isEmpty()) {
                Release relVersaoManual = new Release();
                Release relVersaoAtual = new Release();
                relVersaoAtual.setPkgver(AplicacaoPropertiesUtil.getVersao());
                relVersaoAtual.setPkgrel(AplicacaoPropertiesUtil.getVersaoTeste());
                String[] versaoManual = updateProperties.getUltimaVersaoManual().split("_");
                relVersaoManual.setPkgver(versaoManual[0]);
                if (versaoManual.length > 1) {
                    relVersaoManual.setPkgrel(versaoManual[1]);
                }
                updateProperties.setDownloadManual(relVersaoManual.compareTo((Object)relVersaoAtual) > 0);
            }
            return updateProperties;
        }
        catch (Exception e) {
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
    }

    public PGDAppUpdateProperties temAtualizacaoCompletada() throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        PGDAppUpdateProperties pgdProperties = null;
        try {
            ReleaseUpdateProperties properies = updater.getReleaseUpdateProperties();
            if (properies != null && properies.getUpdateStatus() == ReleaseUpdateProperties.UpdateStatus.UpdateCompleted) {
                pgdProperties = this.obterUpdateProperties(properies.getLatestRelease());
            }
        }
        catch (AtualizacaoException e) {
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
        return pgdProperties;
    }

    public PGDAppUpdateProperties atualizacaoPendente() throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        PGDAppUpdateProperties updateProperties = null;
        try {
            ReleaseUpdateProperties releaseProperties = updater.registerUpdateStatusUpdateNotStarted();
            if (releaseProperties != null) {
                updateProperties = this.obterUpdateProperties(releaseProperties.getLatestRelease());
            }
        }
        catch (AtualizacaoException e) {
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
        return updateProperties;
    }

    public void resetUpdateStatus() {
        this.getPgdUpdater().resetUpdateStatus();
    }

    public boolean verificarUltimaVersaoAposPeriodo() throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        try {
            ReleaseUpdateProperties releaseProperties = updater.getReleaseUpdateProperties();
            if (releaseProperties != null && releaseProperties.getUpdateStatus() != ReleaseUpdateProperties.UpdateStatus.UpdateCompleted) {
                PGDAppUpdateProperties updateProperties = this.obterUpdateProperties(releaseProperties.getLatestRelease());
                String dataUltimaConsulta = releaseProperties.getQueryDate();
                Calendar cal = Calendar.getInstance();
                cal.setLenient(false);
                cal.clear();
                cal.set(Integer.parseInt(dataUltimaConsulta.substring(0, 4)), Integer.parseInt(dataUltimaConsulta.substring(4, 6)) - 1, Integer.parseInt(dataUltimaConsulta.substring(6, 8)), Integer.parseInt(dataUltimaConsulta.substring(8, 10)), Integer.parseInt(dataUltimaConsulta.substring(10, 12)));
                cal.add(12, updateProperties.getPeriodoEspera());
                long dataProximaConsulta = Long.parseLong(updater.getDateTime(cal.getTime()));
                long dataAtual = Long.parseLong(updater.getDateTime(new Date()));
                if (dataAtual <= dataProximaConsulta) {
                    return false;
                }
            }
        }
        catch (AtualizacaoException | NumberFormatException e) {
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
        return true;
    }

    public PGDAppUpdateProperties obterUpdatePropertiesUltimaVersao() throws AplicacaoException {
        Release versaoAtual;
        PGDAppUpdateProperties updateProperties = null;
        if (this.ultimaVersao != null && this.ultimaVersao.compareTo((Object)(versaoAtual = new Release(AplicacaoPropertiesUtil.getVersao(), AplicacaoPropertiesUtil.getVersaoTeste()))) > 0) {
            updateProperties = this.obterUpdateProperties(this.ultimaVersao);
        }
        return updateProperties;
    }

    public void verificarUltimaVersao() throws AplicacaoException {
        try {
            this.ultimaVersao = this.getPgdUpdater().getLatestRelease(this.getEnderecoArqUltimaVersao());
        }
        catch (Exception e) {
            throw new AplicacaoException("atualizar.erro.verificacao", e);
        }
    }

    public boolean temNovaVersaoArquivo(String idArquivo, String h) {
        Release.FileInfo ultimaVersaoArquivo = (Release.FileInfo)this.ultimaVersao.getFiles().get(idArquivo);
        return ultimaVersaoArquivo != null && !h.equals(ultimaVersaoArquivo.getHash());
    }

    public PGDAppUpdateProperties verificarUltimaVersaoOnline() throws AplicacaoException {
        this.verificarUltimaVersao();
        PGDAppUpdateProperties updateProperties = this.obterUpdatePropertiesUltimaVersao();
        return updateProperties;
    }

    public String getJavaCommand() {
        Object javaCommand = "java";
        File javaHomePath = new File(System.getProperty("java.home") + File.separator + "bin");
        if (javaHomePath.exists() && javaHomePath.isDirectory()) {
            javaCommand = javaHomePath.getAbsolutePath() + File.separator + (String)javaCommand;
        }
        return javaCommand;
    }

    public void execNavegador(String endereco) throws AplicacaoException {
        if (endereco == null) {
            endereco = "http://idg.receita.fazenda.gov.br/programas-para-download/programas-para-voce";
        }
        File baseDir = this.obterPastaBase();
        File updaterJar = new File(baseDir, "pgd-updater.jar");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getJavaCommand());
        cmd.add("-jar");
        cmd.add(updaterJar.getAbsolutePath());
        cmd.add("-B");
        cmd.add("-appName");
        cmd.add(this.SIGLA_PROGRAMA + ConstantesGlobais.EXERCICIO);
        cmd.add("-url");
        cmd.add(endereco);
        System.err.println("cmdDir=" + String.valueOf(baseDir));
        System.err.println("cmd=" + cmd.toString());
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.directory(baseDir);
            processBuilder.start();
        }
        catch (Throwable ex) {
            throw new AplicacaoException("atualizar.erro.navegador", new String[]{endereco, ConstantesGlobais.EXERCICIO}, ex);
        }
    }

    public void execUpdate(PGDAppUpdateProperties updateProperties) throws AplicacaoException {
        File baseDir = this.obterPastaBase();
        String releaseUpdateProperties = this.getPgdUpdater().getReleasePropertiesPath();
        File updaterJar = new File(baseDir, "pgd-updater.jar");
        File tempDir = this.obterPastaTemp();
        File logFile = this.getPgdUpdater().getLogFile();
        Object comando = null;
        ArrayList<String> cmd = new ArrayList<String>();
        String javaCommand = this.getJavaCommand();
        File pgdExecFile = null;
        comando = FabricaUtilitarios.isWindows() && (pgdExecFile = new File(baseDir, this.NOME_EXE_WIN)).exists() ? pgdExecFile.getAbsolutePath() : (FabricaUtilitarios.isMac() && (pgdExecFile = new File(baseDir.getParentFile().getParentFile().getParentFile(), this.NOME_APP_MAC)).exists() ? "open " + pgdExecFile.getAbsolutePath() : javaCommand + "#-jar#" + this.NOME_APLICATIVO_JAR);
        cmd.add(javaCommand);
        cmd.add("-jar");
        cmd.add(updaterJar.getAbsolutePath());
        cmd.add("-U");
        cmd.add("-W");
        cmd.add("-appName");
        cmd.add(this.SIGLA_PROGRAMA + ConstantesGlobais.EXERCICIO);
        cmd.add("-tempDir");
        cmd.add(tempDir.getAbsolutePath());
        cmd.add("-destDir");
        cmd.add(baseDir.getAbsolutePath());
        cmd.add("-zipFile");
        cmd.add(updateProperties.getArquivoZip());
        cmd.add("-releaseUpdateProperties");
        cmd.add(releaseUpdateProperties);
        cmd.add("-logFile");
        cmd.add(logFile.getAbsolutePath());
        cmd.add("-appComand");
        cmd.add((String)comando);
        cmd.add("-appComandSeparator");
        cmd.add("#");
        System.err.println("cmdDir=" + String.valueOf(baseDir));
        System.err.println("cmd=" + cmd.toString());
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.directory(baseDir);
            processBuilder.start();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new AplicacaoException("atualizar.erro.update", ex);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new AplicacaoException("atualizar.erro.update", ex);
        }
    }

    public File criarPastaTemporaria() throws AplicacaoException {
        File tempDir = this.obterPastaTemp();
        try {
            if (tempDir.exists()) {
                FileUtils.deleteDirectory((File)tempDir);
            }
            FileUtils.forceMkdir((File)tempDir);
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
            throw new AplicacaoException("atualizar.erro.download", e);
        }
        return tempDir;
    }

    public void update(Collection<String> filesIds) throws AplicacaoException {
        String[] zipFilesNames = new String[filesIds.size()];
        String[] filesPaths = new String[filesIds.size()];
        int i = 0;
        for (String id : filesIds) {
            Release.FileInfo fileInfo = (Release.FileInfo)this.ultimaVersao.getFiles().get(id);
            if (fileInfo != null) {
                zipFilesNames[i] = fileInfo.getPackName();
                filesPaths[i] = fileInfo.getPath();
            }
            ++i;
        }
        try {
            this.getPgdUpdater().updateFiles(this.obterPastaTemp().getAbsolutePath(), this.obterPastaBase().getAbsolutePath(), zipFilesNames, filesPaths);
        }
        catch (AtualizacaoException e) {
            e.printStackTrace();
            LogPPGD.erro((String)e.getMessage());
            throw new AplicacaoException("atualizar.erro.update", e);
        }
    }

    public void download(Collection<String> filesIds, Downloader.DownloadProgress progress) throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        updater.setDownloadProgress(progress);
        PGDAppUpdateProperties updateProperties = (PGDAppUpdateProperties)new Gson().fromJson(this.ultimaVersao.getMessage(), PGDAppUpdateProperties.class);
        File tempDir = this.criarPastaTemporaria();
        try {
            updater.getLogger().info("Iniciando download de arquivos internos: " + String.valueOf(filesIds) + ".");
            String[] zipFilesNames = new String[filesIds.size()];
            int i = 0;
            Iterator<String> iterator = filesIds.iterator();
            while (iterator.hasNext()) {
                Release.FileInfo fileInfo = (Release.FileInfo)this.ultimaVersao.getFiles().get(iterator.next());
                if (fileInfo != null) {
                    zipFilesNames[i] = fileInfo.getPackName();
                }
                ++i;
            }
            updater.executarDownload(updateProperties.getEnderecoServidorTabelas(), tempDir.getAbsolutePath(), zipFilesNames);
        }
        catch (AtualizacaoException e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof SocketTimeoutException) {
                throw new AplicacaoException("atualizar.erro.download.timeout", e);
            }
            throw new AplicacaoException("atualizar.erro.download", e);
        }
    }

    public void download(PGDAppUpdateProperties updateProperties, Downloader.DownloadProgress progress) throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        updater.setDownloadProgress(progress);
        File tempDir = this.obterPastaTemp();
        try {
            if (tempDir.exists()) {
                FileUtils.deleteDirectory((File)tempDir);
            }
            FileUtils.forceMkdir((File)tempDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AplicacaoException("atualizar.erro.download", e);
        }
        try {
            updater.getLogger().info("Iniciando download da vers\u00e3o: " + updateProperties.getUltimaVersao() + " (" + String.valueOf((Object)updateProperties.getTipoAtualizacao()) + "). Vers\u00e3o Atual: " + updateProperties.getVersaoAtual() + ".");
            updater.executarDownload(updateProperties.getEnderecoServidor(), tempDir.getAbsolutePath(), updateProperties.getArquivoZip());
        }
        catch (AtualizacaoException e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof SocketTimeoutException) {
                throw new AplicacaoException("atualizar.erro.download.timeout", e);
            }
            throw new AplicacaoException("atualizar.erro.download", e);
        }
    }

    public boolean temPermissaoEscritaPastaBase() {
        try {
            return this.obterPastaBase() != null;
        }
        catch (AplicacaoException aplicacaoException) {
            return false;
        }
    }

    public boolean temPermissaoEscritaPasta(File pasta) {
        try {
            File arquivoTeste = new File(pasta, "test.txt");
            arquivoTeste.createNewFile();
            arquivoTeste.delete();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public File obterPastaTemp() throws AplicacaoException {
        return new File(this.obterPastaAplicativo(), this.NOME_PASTA_TEMP);
    }

    public File obterPastaAplicativo() throws AplicacaoException {
        File appHomeDir = null;
        try {
            appHomeDir = new File(new File(System.getProperty("user.home")), this.NOME_PASTA_APLICATIVO);
            if (!appHomeDir.exists()) {
                FileUtils.forceMkdir((File)appHomeDir);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
        return appHomeDir;
    }

    public File obterPastaBase() throws AplicacaoException {
        if (this.pastaBase == null) {
            try {
                this.pastaBase = new File(PGDAppUpdater.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new AplicacaoException("atualizar.erro.generico", ex);
            }
            if (this.pastaBase.isFile()) {
                this.pastaBase = this.pastaBase.getParentFile();
            }
            if (!this.temPermissaoEscritaPasta(this.pastaBase)) {
                throw new AplicacaoException("atualizar.erro.generico");
            }
        }
        return this.pastaBase;
    }

    public String getEnderecoArqUltimaVersao() {
        if (ConstantesGlobaisGCAP.VERSAO_TESTES) {
            if (this.getAmbienteUpdater() == TIPO_AMBIENTE_UPDATER_DESENVOLVIMENTO) {
                return this.PATH_ENDERECO_UPDATE_DESENVOLVIMENTO;
            }
            return this.PATH_ENDERECO_UPDATE_HOMOLOGACAO;
        }
        return this.PATH_ENDERECO_UPDATE_PRODUCAO;
    }

    public int getAmbienteUpdater() {
        return this.ambienteUpdater;
    }

    public void setAmbienteUpdater(int ambienteUpdater) {
        this.ambienteUpdater = ambienteUpdater;
    }
}

