/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.validador;

import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.lang.ref.WeakReference;
import java.util.GregorianCalendar;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ValidadorIsencao180DiasDataPrimeiraAlienacao
extends ValidadorNaoNulo {
    WeakReference<AlienacaoBemImovel> weakAlienacao;

    public ValidadorIsencao180DiasDataPrimeiraAlienacao(AlienacaoBemImovel alienacao) {
        super((byte)3);
        this.weakAlienacao = new WeakReference<AlienacaoBemImovel>(alienacao);
    }

    public RetornoValidacao validarImplementado() {
        if (((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getPerguntas().isValorReaplicadoPrimeiraAlienacao()) {
            if (this.getInformacao().isVazio()) {
                return super.validarImplementado();
            }
            if (((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getDataAlienacao().isValido()) {
                try {
                    int diaDI = Integer.parseInt(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getPerguntas().getDataPrimeiraAlienacao().getDia());
                    int mesDI = Integer.parseInt(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getPerguntas().getDataPrimeiraAlienacao().getMes());
                    int anoDI = Integer.parseInt(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getPerguntas().getDataPrimeiraAlienacao().getAno());
                    int diaDF = Integer.parseInt(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getDataAlienacao().getDia());
                    int mesDF = Integer.parseInt(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getDataAlienacao().getMes());
                    int anoDF = Integer.parseInt(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getDataAlienacao().getAno());
                    GregorianCalendar dI = new GregorianCalendar(anoDI, mesDI - 1, diaDI);
                    GregorianCalendar dF = new GregorianCalendar(anoDF, mesDF - 1, diaDF);
                    long difMilisegundos = dF.getTimeInMillis() - dI.getTimeInMillis();
                    long difDias = difMilisegundos / 86400000L;
                    if (difDias > 180L || difDias < 0L) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("dataPrimeiraAlienacaoFora180Dias"));
                    }
                }
                catch (Exception ex) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCampoInvalido", new String[]{this.getInformacao().getNomeCampo()}));
                }
                if (ControladorGui.getDemonstrativoAberto() == null) {
                    return new RetornoValidacao(0);
                }
                Data dataMaisAntiga = ControladorGui.getDemonstrativoAberto().getBensImoveis().obterData180DiasMaisAntigaPossivel(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getBemImovel().getEspecificacao().naoFormatado(), ((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getDataAlienacao(), ((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getPerguntas().getDataPrimeiraAlienacao());
                if (dataMaisAntiga == null || !((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getPerguntas().getDataPrimeiraAlienacao().igual(dataMaisAntiga)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCaso02Isencao180Dias", new String[]{((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getPerguntas().getDataPrimeiraAlienacao().formatado()}));
                }
            }
        }
        return new RetornoValidacao(0);
    }
}

