/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.cachenomes;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import serpro.ppgd.infraestrutura.cachenomes.CacheNaoEncontrado;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class CacheNomes {
    private static CacheNomes instancia = new CacheNomes();
    private ArrayList<LinkNINome> listaNIs = new ArrayList();

    private CacheNomes() {
    }

    public void link(CPF aCpf, Alfa nome) {
        this.listaNIs.add(new LinkNINome((Informacao)aCpf, nome));
        aCpf.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            }
        });
        nome.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            }
        });
    }

    public static CacheNomes getInstancia() {
        return instancia;
    }

    public String buscaCacheDeNomePorNI(String strNi) throws CacheNaoEncontrado {
        String nomeEncontrado = null;
        for (LinkNINome link : this.listaNIs) {
            Alfa alfa;
            Informacao ni = (Informacao)link.refNi.get();
            if (ni == null || !ni.naoFormatado().equals(strNi) || (alfa = (Alfa)link.refNome.get()) == null) continue;
            nomeEncontrado = alfa.naoFormatado();
            break;
        }
        if (nomeEncontrado == null) {
            throw new CacheNaoEncontrado();
        }
        return nomeEncontrado;
    }

    public LinkNINome buscaLinkDoNI(Informacao<?> ni) {
        LinkNINome linkEncontrado = null;
        for (LinkNINome link : this.listaNIs) {
            Informacao linkNi = (Informacao)link.refNi.get();
            if (linkNi == null || linkNi != ni) continue;
            linkEncontrado = link;
            break;
        }
        return linkEncontrado;
    }

    class LinkNINome {
        public WeakReference<Informacao> refNi;
        public WeakReference<Alfa> refNome;

        public LinkNINome(Informacao aNi, Alfa aNome) {
            this.refNi = new WeakReference<Informacao>(aNi);
            this.refNome = new WeakReference<Alfa>(aNome);
        }

        public Informacao<?> getNI() {
            return (Informacao)this.refNi.get();
        }

        public Alfa getNome() {
            return (Alfa)this.refNome.get();
        }
    }
}

