/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Names;
import org.icepdf.core.pobjects.OptionalContent;
import org.icepdf.core.pobjects.Outlines;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.ViewerPreferences;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Catalog
extends Dictionary {
    private static final Logger logger = Logger.getLogger(Catalog.class.toString());
    public static final Name TYPE = new Name("Catalog");
    public static final Name DESTS_KEY = new Name("Dests");
    public static final Name VIEWERPREFERENCES_KEY = new Name("ViewerPreferences");
    public static final Name NAMES_KEY = new Name("Names");
    public static final Name OUTLINES_KEY = new Name("Outlines");
    public static final Name OCPROPERTIES_KEY = new Name("OCProperties");
    public static final Name PAGES_KEY = new Name("Pages");
    public static final Name PAGELAYOUT_KEY = new Name("PageLayout");
    public static final Name PAGEMODE_KEY = new Name("PageMode");
    public static final Name COLLECTION_KEY = new Name("Collection");
    private PageTree pageTree;
    private Outlines outlines;
    private Names names;
    private OptionalContent optionalContent;
    private Dictionary dests;
    private ViewerPreferences viewerPref;
    private boolean outlinesInited = false;
    private boolean namesTreeInited = false;
    private boolean destsInited = false;
    private boolean viewerPrefInited = false;
    private boolean optionalContentInited = false;

    public Catalog(Library l, HashMap<Object, Object> h) {
        super(l, h);
    }

    @Override
    public synchronized void init() {
        Object tmp = this.library.getObject(this.entries, PAGES_KEY);
        this.pageTree = null;
        if (tmp instanceof PageTree) {
            this.pageTree = (PageTree)tmp;
        } else if (tmp instanceof HashMap) {
            this.pageTree = new PageTree(this.library, (HashMap)tmp);
        } else if (tmp instanceof Page) {
            Page tmpPage = (Page)tmp;
            HashMap<String, Serializable> tmpPages = new HashMap<String, Serializable>();
            ArrayList<Reference> kids = new ArrayList<Reference>();
            kids.add(tmpPage.getPObjectReference());
            tmpPages.put("Kids", kids);
            tmpPages.put("Count", Integer.valueOf(1));
            this.pageTree = new PageTree(this.library, tmpPages);
        }
        if (this.pageTree != null) {
            this.pageTree.init();
        }
        if ((tmp = this.library.getObject(this.entries, NAMES_KEY)) != null) {
            this.names = new Names(this.library, (HashMap)tmp);
            this.names.init();
        }
    }

    public PageTree getPageTree() {
        return this.pageTree;
    }

    public Outlines getOutlines() {
        if (!this.outlinesInited) {
            this.outlinesInited = true;
            Object o = this.library.getObject(this.entries, OUTLINES_KEY);
            if (o != null) {
                this.outlines = new Outlines(this.library, (HashMap)o);
            }
        }
        return this.outlines;
    }

    public Names getNames() {
        return this.names;
    }

    public Dictionary getDestinations() {
        if (!this.destsInited) {
            this.destsInited = true;
            Object o = this.library.getObject(this.entries, DESTS_KEY);
            if (o != null) {
                this.dests = new Dictionary(this.library, (HashMap)o);
                this.dests.init();
            }
        }
        return this.dests;
    }

    public ViewerPreferences getViewerPreferences() {
        if (!this.viewerPrefInited) {
            this.viewerPrefInited = true;
            Object o = this.library.getObject(this.entries, VIEWERPREFERENCES_KEY);
            if (o != null) {
                this.viewerPref = new ViewerPreferences(this.library, (HashMap)o);
                this.viewerPref.init();
            }
        }
        return this.viewerPref;
    }

    public OptionalContent getOptionalContent() {
        if (!this.optionalContentInited) {
            this.optionalContentInited = true;
            Object o = this.library.getObject(this.entries, OCPROPERTIES_KEY);
            if (o != null && o instanceof HashMap) {
                this.optionalContent = new OptionalContent(this.library, (HashMap)o);
                this.optionalContent.init();
            } else {
                this.optionalContent = new OptionalContent(this.library, new HashMap());
                this.optionalContent.init();
            }
        }
        return this.optionalContent;
    }

    @Override
    public String toString() {
        return "CATALOG= " + this.entries.toString();
    }

    static {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("ICEsoft ICEpdf Core " + Document.getLibraryVersion());
        }
    }
}

