/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.txt;

import java.util.Iterator;
import serpro.ppgd.formatosexternos.txt.CampoReg;
import serpro.ppgd.formatosexternos.txt.CampoTXT;
import serpro.ppgd.formatosexternos.txt.DocumentoTXT;
import serpro.ppgd.formatosexternos.txt.MapeamentoTXT;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.negocio.CNPJ;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class ConversorRegistroParaObjeto {
    public void preencheObjetoNegocio(ObjetoNegocio pObj, DocumentoTXT pDoc) throws GeracaoTxtException {
        for (String tipoRegAtual : MapeamentoTXT.getInstance().getTiposDeRegistrosArquivo(pDoc.getTipoArquivo())) {
            Iterator<RegistroTxt> itRegistrosAtuais = pDoc.getRegistrosTxt(tipoRegAtual).iterator();
            String colecaoRegistros = MapeamentoTXT.getInstance().getColecaoRegistroMultipo(pDoc.getTipoArquivo(), tipoRegAtual);
            Colecao col = null;
            if (colecaoRegistros.trim().length() != 0) {
                col = colecaoRegistros.toUpperCase().equals("THIS") ? (Colecao)pObj : (Colecao)FabricaUtilitarios.obtemAtributo((ObjetoNegocio)pObj, (String)colecaoRegistros);
                col.recuperarLista().clear();
            }
            while (itRegistrosAtuais.hasNext()) {
                RegistroTxt regAtual = itRegistrosAtuais.next();
                if (!regAtual.isParticipaImportacao()) continue;
                this.antesDeCarregarRegistro(pObj, regAtual);
                if (colecaoRegistros.trim().length() != 0) {
                    this.preencheRegistroMultiplo(col, regAtual, pObj);
                    continue;
                }
                this.preencheRegistroComum(regAtual, pObj);
            }
        }
    }

    protected void antesDeCarregarRegistro(ObjetoNegocio pDec, RegistroTxt pReg) throws GeracaoTxtException {
    }

    protected void preencheRegistroMultiplo(Colecao pCol, RegistroTxt pReg, ObjetoNegocio pObj) throws GeracaoTxtException {
        try {
            ObjetoNegocio itemColecao = FabricaUtilitarios.instanciaObjetoNegocio((Class)pCol.getTipoItens());
            for (CampoReg campoAtual : pReg.objListaCampos) {
                if (!campoAtual.isParticipaImportacao()) continue;
                if (campoAtual.getAtributoObjetoNegocio().trim().length() != 0) {
                    String atributoObjetoNegocio = campoAtual.getAtributoObjetoNegocio().trim();
                    int posicaoLasanha = atributoObjetoNegocio.indexOf("#");
                    if (posicaoLasanha == -1) {
                        Informacao info = (Informacao)FabricaUtilitarios.obtemAtributo((ObjetoNegocio)itemColecao, (String)campoAtual.getAtributoObjetoNegocio());
                        this.preencheCampoInformacao(campoAtual.getCampoTXT(), info);
                        continue;
                    }
                    ObjetoNegocio obj = null;
                    obj = posicaoLasanha == 0 ? itemColecao : (ObjetoNegocio)FabricaUtilitarios.obtemAtributo((ObjetoNegocio)itemColecao, (String)atributoObjetoNegocio.substring(0, posicaoLasanha));
                    String nomeMetodo = atributoObjetoNegocio.substring(posicaoLasanha + 1, atributoObjetoNegocio.length());
                    FabricaUtilitarios.invocaMetodo((String)nomeMetodo, (Object)obj, (Class[])new Class[]{String.class}, (Object[])new Object[]{campoAtual.getCampoTXT().asString()});
                    continue;
                }
                this.preencheOutrosCampos(pObj, pReg, campoAtual.getCampoTXT());
            }
            pCol.recuperarLista().add(itemColecao);
        }
        catch (Exception e) {
            throw new GeracaoTxtException(e);
        }
    }

    protected void preencheRegistroComum(RegistroTxt pReg, ObjetoNegocio pObj) throws GeracaoTxtException {
        for (CampoReg campoAtual : pReg.objListaCampos) {
            if (campoAtual.getCampoTXT().getNome().equals("CPF CONTRIBUINTE")) {
                // empty if block
            }
            if (!campoAtual.isParticipaImportacao()) continue;
            if (campoAtual.getAtributoObjetoNegocio().trim().length() != 0) {
                String atributoObjetoNegocio = campoAtual.getAtributoObjetoNegocio().trim();
                int posicaoLasanha = atributoObjetoNegocio.indexOf("#");
                if (posicaoLasanha == -1) {
                    Informacao info = (Informacao)FabricaUtilitarios.obtemAtributo((ObjetoNegocio)pObj, (String)campoAtual.getAtributoObjetoNegocio());
                    this.preencheCampoInformacao(campoAtual.getCampoTXT(), info);
                    continue;
                }
                ObjetoNegocio obj = null;
                obj = posicaoLasanha == 0 ? pObj : (ObjetoNegocio)FabricaUtilitarios.obtemAtributo((ObjetoNegocio)pObj, (String)atributoObjetoNegocio.substring(0, posicaoLasanha));
                String nomeMetodo = atributoObjetoNegocio.substring(posicaoLasanha + 1, atributoObjetoNegocio.length());
                FabricaUtilitarios.invocaMetodo((String)nomeMetodo, (Object)obj, (Class[])new Class[]{String.class}, (Object[])new Object[]{campoAtual.getCampoTXT().asString()});
                continue;
            }
            this.preencheOutrosCampos(pObj, pReg, campoAtual.getCampoTXT());
        }
    }

    protected void preencheOutrosCampos(ObjetoNegocio pDec, RegistroTxt pReg, CampoTXT pCampoTxt) throws GeracaoTxtException {
    }

    protected void preencheCampoInformacao(CampoTXT pCampoTxt, Informacao pInfo) {
        if (pCampoTxt.getNome().equals("TIPO LOGRADOURO IMOVEL")) {
            // empty if block
        }
        if ((pCampoTxt.getTipo().equals("N") || pInfo instanceof NI || pInfo instanceof CPF || pInfo instanceof CNPJ || pInfo instanceof Data) && pCampoTxt.asString().trim().length() > 0) {
            try {
                if (Long.parseLong(pCampoTxt.asString()) == 0L) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
        }
        if (pInfo instanceof Valor) {
            Valor val = pCampoTxt.asValor();
            pInfo.setConteudo(val.getConteudoFormatado());
        } else {
            pInfo.setConteudo(pCampoTxt.asString().trim());
        }
    }
}

