/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.txt;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.formatosexternos.txt.DadosMapeamentoRegistro;
import serpro.ppgd.formatosexternos.txt.DadosMapeamentoTipoArquivo;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class MapeamentoTXT {
    private static MapeamentoTXT instancia = null;
    private Document mapeamentoDOM;

    protected MapeamentoTXT(InputStream streamXml) {
        this.mapeamentoDOM = this.carregarDOM(streamXml);
    }

    protected MapeamentoTXT() {
        String pathArquivoMapeamento = FabricaUtilitarios.getProperties().getProperty("aplicacao.formatosexternos.mapeamento", "mapeamentoTxt");
        this.mapeamentoDOM = this.carregarDOM(Thread.currentThread().getContextClassLoader().getResourceAsStream(pathArquivoMapeamento));
    }

    public static MapeamentoTXT getInstance() {
        if (instancia == null) {
            instancia = new MapeamentoTXT();
        }
        return instancia;
    }

    public static MapeamentoTXT getInstancia() {
        if (instancia == null) {
            instancia = new MapeamentoTXT();
        }
        return instancia;
    }

    public static MapeamentoTXT getInstancia(InputStream streamXml) {
        if (instancia == null) {
            instancia = new MapeamentoTXT(streamXml);
        }
        return instancia;
    }

    private Document carregarDOM(InputStream arquivoMapeamento) {
        Document mapeamento = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            mapeamento = builder.parse(arquivoMapeamento);
        }
        catch (SAXParseException e) {
            LogPPGD.erro((String)("Erro de parsing de " + e.getSystemId() + ". linha " + e.getLineNumber() + ": " + e.getMessage()));
        }
        catch (SAXException e) {
            Exception x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            LogPPGD.erro((String)("Erro de parsing: " + x.getMessage()));
        }
        catch (ParserConfigurationException e) {
            LogPPGD.erro((String)("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage()));
        }
        catch (IOException e) {
            LogPPGD.erro((String)("Erro de I/O: " + e.getMessage()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        return mapeamento;
    }

    public String getColecaoRegistroMultipo(String tipoArquivo, String pTipoReg) {
        Element documentElement = this.mapeamentoDOM.getDocumentElement();
        LogPPGD.debug((String)documentElement.getNodeName());
        NodeList filhos = documentElement.getChildNodes();
        for (int i = 0; i < filhos.getLength(); ++i) {
            if (!(filhos.item(i) instanceof Element) || !filhos.item(i).getNodeName().equals("DeclaracaoTXT")) continue;
            Element nodeFilho = (Element)filhos.item(i);
            String temp = nodeFilho.getAttribute("TipoArquivo");
            if (!nodeFilho.getAttribute("TipoArquivo").equals(tipoArquivo)) continue;
            NodeList netos = nodeFilho.getChildNodes();
            for (int j = 0; j < netos.getLength(); ++j) {
                Element nodeNeto;
                if (!(netos.item(j) instanceof Element) || !netos.item(j).getNodeName().equals("Registro") || !(nodeNeto = (Element)netos.item(j)).getAttribute("Identificador").equals(pTipoReg)) continue;
                return nodeNeto.getAttribute("Colecao").trim();
            }
        }
        return "";
    }

    public boolean participaImportacao(String tipoArquivo, String pTipoReg) {
        Element documentElement = this.mapeamentoDOM.getDocumentElement();
        LogPPGD.debug((String)documentElement.getNodeName());
        NodeList filhos = documentElement.getChildNodes();
        for (int i = 0; i < filhos.getLength(); ++i) {
            if (!(filhos.item(i) instanceof Element) || !filhos.item(i).getNodeName().equals("DeclaracaoTXT")) continue;
            Element nodeFilho = (Element)filhos.item(i);
            String temp = nodeFilho.getAttribute("TipoArquivo");
            if (!nodeFilho.getAttribute("TipoArquivo").equals(tipoArquivo)) continue;
            NodeList netos = nodeFilho.getChildNodes();
            for (int j = 0; j < netos.getLength(); ++j) {
                Element nodeNeto;
                if (!(netos.item(j) instanceof Element) || !netos.item(j).getNodeName().equals("Registro") || !(nodeNeto = (Element)netos.item(j)).getAttribute("Identificador").equals(pTipoReg)) continue;
                return !nodeNeto.getAttribute("ParticipaImportacao").trim().equals("false");
            }
        }
        return true;
    }

    public boolean participaGravacao(String tipoArquivo, String pTipoReg) {
        Element documentElement = this.mapeamentoDOM.getDocumentElement();
        LogPPGD.debug((String)documentElement.getNodeName());
        NodeList filhos = documentElement.getChildNodes();
        for (int i = 0; i < filhos.getLength(); ++i) {
            if (!(filhos.item(i) instanceof Element) || !filhos.item(i).getNodeName().equals("DeclaracaoTXT")) continue;
            Element nodeFilho = (Element)filhos.item(i);
            String temp = nodeFilho.getAttribute("TipoArquivo");
            if (!nodeFilho.getAttribute("TipoArquivo").equals(tipoArquivo)) continue;
            NodeList netos = nodeFilho.getChildNodes();
            for (int j = 0; j < netos.getLength(); ++j) {
                Element nodeNeto;
                if (!(netos.item(j) instanceof Element) || !netos.item(j).getNodeName().equals("Registro") || !(nodeNeto = (Element)netos.item(j)).getAttribute("Identificador").equals(pTipoReg)) continue;
                return !nodeNeto.getAttribute("ParticipaGravacao").trim().equals("false");
            }
        }
        return true;
    }

    public NodeList getRelacaoCamposRegistro(String tipoArquivo, String identificador) {
        Element documentElement = this.mapeamentoDOM.getDocumentElement();
        LogPPGD.debug((String)documentElement.getNodeName());
        NodeList filhos = documentElement.getChildNodes();
        for (int i = 0; i < filhos.getLength(); ++i) {
            if (!(filhos.item(i) instanceof Element) || !filhos.item(i).getNodeName().equals("DeclaracaoTXT")) continue;
            Element nodeFilho = (Element)filhos.item(i);
            String temp = nodeFilho.getAttribute("TipoArquivo");
            if (!nodeFilho.getAttribute("TipoArquivo").equals(tipoArquivo)) continue;
            NodeList netos = nodeFilho.getChildNodes();
            for (int j = 0; j < netos.getLength(); ++j) {
                Element nodeNeto;
                if (!(netos.item(j) instanceof Element) || !netos.item(j).getNodeName().equals("Registro") || !(nodeNeto = (Element)netos.item(j)).getAttribute("Identificador").equals(identificador)) continue;
                NodeList bisnetos = nodeNeto.getChildNodes();
                LogPPGD.debug((String)nodeFilho.getNodeName());
                return bisnetos;
            }
        }
        return null;
    }

    public List<String> getTiposDeRegistrosArquivo(String tipoArquivo) {
        ArrayList<String> retorno = new ArrayList<String>();
        Element documentElement = this.mapeamentoDOM.getDocumentElement();
        LogPPGD.debug((String)documentElement.getNodeName());
        NodeList filhos = documentElement.getChildNodes();
        for (int i = 0; i < filhos.getLength(); ++i) {
            if (!(filhos.item(i) instanceof Element) || !filhos.item(i).getNodeName().equals("DeclaracaoTXT")) continue;
            Element nodeFilho = (Element)filhos.item(i);
            String temp = nodeFilho.getAttribute("TipoArquivo");
            if (!nodeFilho.getAttribute("TipoArquivo").equals(tipoArquivo)) continue;
            NodeList netos = nodeFilho.getChildNodes();
            for (int j = 0; j < netos.getLength(); ++j) {
                if (!(netos.item(j) instanceof Element) || !netos.item(j).getNodeName().equals("Registro")) continue;
                Element nodeNeto = (Element)netos.item(j);
                retorno.add(nodeNeto.getAttribute("Identificador"));
            }
        }
        return retorno;
    }

    public List<DadosMapeamentoRegistro> getTiposDeRegistros(String tipoArquivo) {
        ArrayList<DadosMapeamentoRegistro> retorno = new ArrayList<DadosMapeamentoRegistro>();
        Element documentElement = this.mapeamentoDOM.getDocumentElement();
        LogPPGD.debug((String)documentElement.getNodeName());
        NodeList filhos = documentElement.getChildNodes();
        for (int i = 0; i < filhos.getLength(); ++i) {
            if (!(filhos.item(i) instanceof Element) || !filhos.item(i).getNodeName().equals("DeclaracaoTXT")) continue;
            Element nodeFilho = (Element)filhos.item(i);
            String temp = nodeFilho.getAttribute("TipoArquivo");
            if (!nodeFilho.getAttribute("TipoArquivo").equals(tipoArquivo)) continue;
            NodeList netos = nodeFilho.getChildNodes();
            for (int j = 0; j < netos.getLength(); ++j) {
                if (!(netos.item(j) instanceof Element) || !netos.item(j).getNodeName().equals("Registro")) continue;
                Element nodeNeto = (Element)netos.item(j);
                retorno.add(new DadosMapeamentoRegistro(nodeNeto.getAttribute("Identificador"), nodeNeto.getAttribute("Descricao")));
            }
        }
        return retorno;
    }

    public List<DadosMapeamentoTipoArquivo> getAllTipoArquivoAceitos() {
        ArrayList<DadosMapeamentoTipoArquivo> retorno = new ArrayList<DadosMapeamentoTipoArquivo>();
        Element documentElement = this.mapeamentoDOM.getDocumentElement();
        LogPPGD.debug((String)documentElement.getNodeName());
        NodeList filhos = documentElement.getChildNodes();
        for (int i = 0; i < filhos.getLength(); ++i) {
            if (!(filhos.item(i) instanceof Element) || !filhos.item(i).getNodeName().equals("DeclaracaoTXT")) continue;
            Element elem = (Element)filhos.item(i);
            String tipoArq = elem.getAttribute("TipoArquivo");
            String descricao = elem.getAttribute("Descricao");
            retorno.add(new DadosMapeamentoTipoArquivo(tipoArq, descricao));
        }
        return retorno;
    }

    public static void main(String[] args) {
        LogPPGD.debug((String)("Property javax.xml.parsers.DocumentBuilderFactory: " + System.getProperty("javax.xml.parsers.DocumentBuilderFactory")));
        LogPPGD.debug((String)("Implementa\u00e7\u00e3o do JAXP: " + DocumentBuilderFactory.newInstance()));
        try {
            MapeamentoTXT fabrica = new MapeamentoTXT();
            LogPPGD.debug((String)"cheguei no final");
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            e.printStackTrace();
        }
    }
}

