/*
 * Decompiled with CFR 0.152.
 */
package serpro.receitanet.carregador;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import serpro.receitanet.carregador.ExcecaoArquivoNaoEncontrado;
import serpro.receitanet.carregador.ExcecaoCarregador;
import serpro.receitanet.carregador.ExcecaoErroDeLeitura;

public class JARClassLoader
extends URLClassLoader {
    private File _arquivo;
    private JarFile _jar;

    private JARClassLoader(File arquivo) throws MalformedURLException {
        super(new URL[]{arquivo.toURL()});
        if (!arquivo.exists()) {
            throw new ExcecaoArquivoNaoEncontrado("O arquivo " + arquivo + " n\u00e3o foi encontrado.");
        }
        this._arquivo = arquivo;
        try {
            this._jar = new JarFile(arquivo);
        }
        catch (IOException e) {
            throw new ExcecaoErroDeLeitura(e);
        }
    }

    public static JARClassLoader criar(String arquivo) {
        try {
            return new JARClassLoader(new File(arquivo));
        }
        catch (MalformedURLException e) {
            throw new ExcecaoArquivoNaoEncontrado(e);
        }
    }

    public static JARClassLoader criar(File arquivo) {
        try {
            return new JARClassLoader(arquivo);
        }
        catch (MalformedURLException e) {
            throw new ExcecaoArquivoNaoEncontrado(e);
        }
    }

    public Class obterClasse(String nome) {
        if (nome == null) {
            return null;
        }
        try {
            return this.loadClass(nome);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ExcecaoErroDeLeitura("A classe " + nome + " n\u00e3o foi encontrada.", cnfe);
        }
    }

    public String completarNomeDaClasse(String nomeIncompleto) {
        if (nomeIncompleto == null) {
            return null;
        }
        if (nomeIncompleto.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Nome de classe informado provavelmente cont\u00e9m um pacote.");
        }
        Enumeration<JarEntry> e = this._jar.entries();
        while (e.hasMoreElements()) {
            String nomeCompleto;
            JarEntry entry = e.nextElement();
            if (!this.eEntradaArquivoDeClasse(entry) || !(nomeCompleto = this.extrairNomeDaClasse(entry)).endsWith(nomeIncompleto)) continue;
            return nomeCompleto;
        }
        return null;
    }

    public Class[] obterTodasAsClasses() {
        ArrayList<String> nomesDasClasses = new ArrayList<String>();
        Enumeration<JarEntry> e = this._jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!this.eEntradaArquivoDeClasse(entry)) continue;
            nomesDasClasses.add(this.extrairNomeDaClasse(entry));
        }
        Class[] classes = new Class[nomesDasClasses.size()];
        for (int i = 0; i < nomesDasClasses.size(); ++i) {
            classes[i] = this.obterClasse((String)nomesDasClasses.get(i));
        }
        return classes;
    }

    private String extrairNomeDaClasse(JarEntry entry) {
        return entry.getName().replaceAll("/", ".").substring(0, entry.getName().length() - 6);
    }

    private boolean eEntradaArquivoDeClasse(JarEntry entry) {
        return !entry.isDirectory() && entry.getName().endsWith(".class");
    }

    public void invocarClasse(String nomeDaClasse, String[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class<?> c = this.loadClass(nomeDaClasse);
        Method m = c.getMethod("main", args.getClass());
        m.setAccessible(true);
        int mods = m.getModifiers();
        if (m.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException("main");
        }
        try {
            m.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ExcecaoCarregador("Este erro nunca deveria acontecer.", e);
        }
    }

    public String obterNomeDaClassePrincipal() {
        try {
            URL u = new URL("jar", "", this._arquivo.toURL() + "!/");
            JarURLConnection uc = (JarURLConnection)u.openConnection();
            Attributes attr = uc.getMainAttributes();
            return attr != null ? attr.getValue(Attributes.Name.MAIN_CLASS) : null;
        }
        catch (IOException e) {
            throw new ExcecaoErroDeLeitura(e);
        }
    }
}

