/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.csv;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.csv.CsvDataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRCsvDataSource;

public class CsvDataAdapterService
extends AbstractDataAdapterService {
    public CsvDataAdapterService(JasperReportsContext jasperReportsContext, CsvDataAdapter csvDataAdapter) {
        super(jasperReportsContext, csvDataAdapter);
    }

    public CsvDataAdapterService(CsvDataAdapter csvDataAdapter) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), csvDataAdapter);
    }

    public CsvDataAdapter getCsvDataAdapter() {
        return (CsvDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        CsvDataAdapter csvDataAdapter = this.getCsvDataAdapter();
        if (csvDataAdapter != null) {
            String datePattern = csvDataAdapter.getDatePattern();
            String numberPattern = csvDataAdapter.getNumberPattern();
            if (csvDataAdapter.isQueryExecuterMode()) {
                parameters.put("net.sf.jasperreports.csv.source", csvDataAdapter.getFileName());
                if (csvDataAdapter.getEncoding() != null) {
                    parameters.put("net.sf.jasperreports.csv.encoding", csvDataAdapter.getEncoding());
                }
                if (datePattern != null && datePattern.length() > 0) {
                    parameters.put("CSV_DATE_FORMAT", new SimpleDateFormat(datePattern));
                }
                if (numberPattern != null && numberPattern.length() > 0) {
                    parameters.put("CSV_NUMBER_FORMAT", new DecimalFormat(numberPattern));
                }
                parameters.put("net.sf.jasperreports.csv.field.delimiter", csvDataAdapter.getFieldDelimiter());
                parameters.put("net.sf.jasperreports.csv.record.delimiter", csvDataAdapter.getRecordDelimiter());
                parameters.put("CSV_USE_FIRST_ROW_AS_HEADER", new Boolean(csvDataAdapter.isUseFirstRowAsHeader()));
                if (!csvDataAdapter.isUseFirstRowAsHeader()) {
                    parameters.put("CSV_COLUMN_NAMES_ARRAY", this.getColumnNames(csvDataAdapter));
                }
            } else {
                JRCsvDataSource ds = null;
                if (csvDataAdapter.getEncoding() == null) {
                    ds = new JRCsvDataSource(this.getJasperReportsContext(), csvDataAdapter.getFileName());
                } else {
                    try {
                        ds = new JRCsvDataSource(this.getJasperReportsContext(), csvDataAdapter.getFileName(), csvDataAdapter.getEncoding());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new JRException(e);
                    }
                }
                if (datePattern != null && datePattern.length() > 0) {
                    ds.setDateFormat(new SimpleDateFormat(datePattern));
                }
                if (numberPattern != null && numberPattern.length() > 0) {
                    ds.setNumberFormat(new DecimalFormat(numberPattern));
                }
                ds.setFieldDelimiter(csvDataAdapter.getFieldDelimiter().charAt(0));
                ds.setRecordDelimiter(csvDataAdapter.getRecordDelimiter());
                ds.setUseFirstRowAsHeader(csvDataAdapter.isUseFirstRowAsHeader());
                if (!csvDataAdapter.isUseFirstRowAsHeader()) {
                    ds.setColumnNames(this.getColumnNames(csvDataAdapter));
                }
                parameters.put("REPORT_DATA_SOURCE", ds);
            }
        }
    }

    private String[] getColumnNames(CsvDataAdapter csvDataAdapter) {
        String[] names = new String[csvDataAdapter.getColumnNames().size()];
        int i = 0;
        while (i < names.length) {
            names[i] = csvDataAdapter.getColumnNames().get(i);
            ++i;
        }
        return names;
    }
}

