/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Collection;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRJavacCompiler;
import net.sf.jasperreports.engine.design.JRJdk13Compiler;
import net.sf.jasperreports.engine.design.JRJdtCompiler;
import net.sf.jasperreports.engine.design.JRValidationFault;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JasperReportsContextAware;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public final class JasperCompileManager {
    private JasperReportsContext jasperReportsContext;

    private JasperCompileManager(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    private static JasperCompileManager getDefaultInstance() {
        return new JasperCompileManager(DefaultJasperReportsContext.getInstance());
    }

    public static JasperCompileManager getInstance(JasperReportsContext jasperReportsContext) {
        return new JasperCompileManager(jasperReportsContext);
    }

    public String compileToFile(String sourceFileName) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperDesign jasperDesign = JRXmlLoader.load(sourceFileName);
        File destFile = new File(sourceFile.getParent(), String.valueOf(jasperDesign.getName()) + ".jasper");
        String destFileName = destFile.toString();
        this.compileToFile(jasperDesign, destFileName);
        return destFileName;
    }

    public void compileToFile(String sourceFileName, String destFileName) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(sourceFileName);
        this.compileToFile(jasperDesign, destFileName);
    }

    public void compileToFile(JasperDesign jasperDesign, String destFileName) throws JRException {
        JasperReport jasperReport = this.compile(jasperDesign);
        JRSaver.saveObject((Object)jasperReport, destFileName);
    }

    public JasperReport compile(String sourceFileName) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(sourceFileName);
        return this.compile(jasperDesign);
    }

    public void compileToStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(inputStream);
        this.compileToStream(jasperDesign, outputStream);
    }

    public void compileToStream(JasperDesign jasperDesign, OutputStream outputStream) throws JRException {
        JasperReport jasperReport = this.compile(jasperDesign);
        JRSaver.saveObject((Object)jasperReport, outputStream);
    }

    public JasperReport compile(InputStream inputStream) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(inputStream);
        return this.compile(jasperDesign);
    }

    public JasperReport compile(JasperDesign jasperDesign) throws JRException {
        return this.getCompiler(jasperDesign).compileReport(jasperDesign);
    }

    public Collection<JRValidationFault> verify(JasperDesign jasperDesign) {
        return JRVerifier.verifyDesign(jasperDesign);
    }

    public JREvaluator getEvaluator(JasperReport jasperReport, JRDataset dataset) throws JRException {
        JRCompiler compiler = this.getCompiler(jasperReport);
        JREvaluator evaluator = compiler.loadEvaluator(jasperReport, dataset);
        this.initialize(evaluator);
        return evaluator;
    }

    public JREvaluator getEvaluator(JasperReport jasperReport, JRCrosstab crosstab) throws JRException {
        JRCompiler compiler = this.getCompiler(jasperReport);
        JREvaluator evaluator = compiler.loadEvaluator(jasperReport, crosstab);
        this.initialize(evaluator);
        return evaluator;
    }

    public JREvaluator getEvaluator(JasperReport jasperReport) throws JRException {
        return this.getEvaluator(jasperReport, jasperReport.getMainDataset());
    }

    protected void initialize(JREvaluator evaluator) {
        if (evaluator instanceof JasperReportsContextAware) {
            ((JasperReportsContextAware)((Object)evaluator)).setJasperReportsContext(this.jasperReportsContext);
        }
    }

    public String writeToXmlFile(String sourceFileName) throws JRException {
        File sourceFile = new File(sourceFileName);
        JRReport report = (JRReport)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), String.valueOf(report.getName()) + ".jasper.jrxml");
        String destFileName = destFile.toString();
        this.writeToXmlFile(report, destFileName);
        return destFileName;
    }

    public void writeToXmlFile(String sourceFileName, String destFileName) throws JRException {
        JRReport report = (JRReport)JRLoader.loadObjectFromFile(sourceFileName);
        this.writeToXmlFile(report, destFileName);
    }

    public void writeToXmlFile(JRReport report, String destFileName) throws JRException {
        new JRXmlWriter(this.jasperReportsContext).write(report, destFileName, "UTF-8");
    }

    public void writeToXmlStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JRReport report = (JRReport)JRLoader.loadObject(inputStream);
        this.writeToXmlStream(report, outputStream);
    }

    public void writeToXmlStream(JRReport report, OutputStream outputStream) throws JRException {
        new JRXmlWriter(this.jasperReportsContext).write(report, outputStream, "UTF-8");
    }

    public String writeToXml(JRReport report) {
        return new JRXmlWriter(this.jasperReportsContext).write(report, "UTF-8");
    }

    public static String compileReportToFile(String sourceFileName) throws JRException {
        return JasperCompileManager.getDefaultInstance().compileToFile(sourceFileName);
    }

    public static void compileReportToFile(String sourceFileName, String destFileName) throws JRException {
        JasperCompileManager.getDefaultInstance().compileToFile(sourceFileName, destFileName);
    }

    public static void compileReportToFile(JasperDesign jasperDesign, String destFileName) throws JRException {
        JasperCompileManager.getDefaultInstance().compileToFile(jasperDesign, destFileName);
    }

    public static JasperReport compileReport(String sourceFileName) throws JRException {
        return JasperCompileManager.getDefaultInstance().compile(sourceFileName);
    }

    public static void compileReportToStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperCompileManager.getDefaultInstance().compileToStream(inputStream, outputStream);
    }

    public static void compileReportToStream(JasperDesign jasperDesign, OutputStream outputStream) throws JRException {
        JasperCompileManager.getDefaultInstance().compileToStream(jasperDesign, outputStream);
    }

    public static JasperReport compileReport(InputStream inputStream) throws JRException {
        return JasperCompileManager.getDefaultInstance().compile(inputStream);
    }

    public static JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        return JasperCompileManager.getDefaultInstance().compile(jasperDesign);
    }

    public static Collection<JRValidationFault> verifyDesign(JasperDesign jasperDesign) {
        return JasperCompileManager.getDefaultInstance().verify(jasperDesign);
    }

    public static JREvaluator loadEvaluator(JasperReport jasperReport, JRDataset dataset) throws JRException {
        return JasperCompileManager.getDefaultInstance().getEvaluator(jasperReport, dataset);
    }

    public static JREvaluator loadEvaluator(JasperReport jasperReport, JRCrosstab crosstab) throws JRException {
        return JasperCompileManager.getDefaultInstance().getEvaluator(jasperReport, crosstab);
    }

    public static JREvaluator loadEvaluator(JasperReport jasperReport) throws JRException {
        return JasperCompileManager.getDefaultInstance().getEvaluator(jasperReport);
    }

    public static String writeReportToXmlFile(String sourceFileName) throws JRException {
        return JasperCompileManager.getDefaultInstance().writeToXmlFile(sourceFileName);
    }

    public static void writeReportToXmlFile(String sourceFileName, String destFileName) throws JRException {
        JasperCompileManager.getDefaultInstance().writeToXmlFile(sourceFileName, destFileName);
    }

    public static void writeReportToXmlFile(JRReport report, String destFileName) throws JRException {
        JasperCompileManager.getDefaultInstance().writeToXmlFile(report, destFileName);
    }

    public static void writeReportToXmlStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperCompileManager.getDefaultInstance().writeToXmlStream(inputStream, outputStream);
    }

    public static void writeReportToXmlStream(JRReport report, OutputStream outputStream) throws JRException {
        JasperCompileManager.getDefaultInstance().writeToXmlStream(report, outputStream);
    }

    public static String writeReportToXml(JRReport report) {
        return JasperCompileManager.getDefaultInstance().writeToXml(report);
    }

    private JRCompiler getJavaCompiler() {
        JRAbstractJavaCompiler compiler = null;
        try {
            JRClassLoader.loadClassForRealName("org.eclipse.jdt.internal.compiler.Compiler");
            compiler = new JRJdtCompiler(this.jasperReportsContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compiler == null) {
            try {
                JRClassLoader.loadClassForRealName("com.sun.tools.javac.Main");
                compiler = new JRJdk13Compiler(this.jasperReportsContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (compiler == null) {
            compiler = new JRJavacCompiler(this.jasperReportsContext);
        }
        return compiler;
    }

    private JRCompiler getCompiler(JasperReport jasperReport) throws JRException {
        Class<?> tmpCompilerClass2;
        JRCompiler compiler = null;
        String compilerClassName = jasperReport.getCompilerClass();
        Class<?> compilerClass = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                compilerClass = tmpCompilerClass2 = classLoader.loadClass(compilerClassName);
            }
            catch (ClassNotFoundException tmpCompilerClass2) {
                // empty catch block
            }
        }
        if (compilerClass == null) {
            classLoader = JasperCompileManager.class.getClassLoader();
            try {
                compilerClass = classLoader == null ? (tmpCompilerClass2 = Class.forName(compilerClassName)) : (tmpCompilerClass2 = classLoader.loadClass(compilerClassName));
            }
            catch (ClassNotFoundException e) {
                throw new JRException("Report compiler class not found : " + compilerClassName, e);
            }
        }
        try {
            Constructor<?> constructor = compilerClass.getConstructor(JasperReportsContext.class);
            compiler = (JRCompiler)constructor.newInstance(this.jasperReportsContext);
        }
        catch (Exception e) {
            throw new JRException("Could not instantiate report compiler : " + compilerClassName, e);
        }
        return compiler;
    }

    private JRCompiler getCompiler(JasperDesign jasperDesign) throws JRException {
        JRCompiler compiler = null;
        String compilerClassName = this.getCompilerClassProperty();
        if (compilerClassName == null || compilerClassName.trim().length() == 0) {
            String language = jasperDesign.getLanguage();
            compilerClassName = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty("net.sf.jasperreports.compiler." + language);
            if (compilerClassName == null || compilerClassName.trim().length() == 0) {
                if ("java".equals(language)) {
                    return this.getJavaCompiler();
                }
                throw new JRException("No report compiler set for language : " + language);
            }
        }
        try {
            Class<?> clazz = JRClassLoader.loadClassForName(compilerClassName);
            compiler = (JRCompiler)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JRException("Could not instantiate report compiler : " + compilerClassName, e);
        }
        return compiler;
    }

    private String getCompilerClassProperty() {
        return JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty("net.sf.jasperreports.compiler.class");
    }
}

