/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBaseParagraph;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRBaseTextElement
extends JRBaseElement
implements JRTextElement {
    private static final long serialVersionUID = 10200L;
    protected HorizontalAlignEnum horizontalAlignmentValue;
    protected VerticalAlignEnum verticalAlignmentValue;
    protected RotationEnum rotationValue;
    protected String markup;
    protected JRLineBox lineBox;
    protected JRParagraph paragraph;
    protected String fontName;
    protected Boolean isBold;
    protected Boolean isItalic;
    protected Boolean isUnderline;
    protected Boolean isStrikeThrough;
    protected Float fontsize;
    protected String pdfFontName;
    protected String pdfEncoding;
    protected Boolean isPdfEmbedded;
    private int PSEUDO_SERIAL_VERSION_UID = 50502;
    private Byte horizontalAlignment;
    private Byte verticalAlignment;
    private Byte rotation;
    private Byte lineSpacing;
    private LineSpacingEnum lineSpacingValue;
    private Byte border;
    private Byte topBorder;
    private Byte leftBorder;
    private Byte bottomBorder;
    private Byte rightBorder;
    private Color borderColor;
    private Color topBorderColor;
    private Color leftBorderColor;
    private Color bottomBorderColor;
    private Color rightBorderColor;
    private Integer padding;
    private Integer topPadding;
    private Integer leftPadding;
    private Integer bottomPadding;
    private Integer rightPadding;
    private Boolean isStyledText;
    private Integer fontSize;

    protected JRBaseTextElement(JRTextElement textElement, JRBaseObjectFactory factory) {
        super(textElement, factory);
        this.horizontalAlignmentValue = textElement.getOwnHorizontalAlignmentValue();
        this.verticalAlignmentValue = textElement.getOwnVerticalAlignmentValue();
        this.rotationValue = textElement.getOwnRotationValue();
        this.markup = textElement.getOwnMarkup();
        this.lineBox = textElement.getLineBox().clone(this);
        this.paragraph = textElement.getParagraph().clone(this);
        this.fontName = textElement.getOwnFontName();
        this.isBold = textElement.isOwnBold();
        this.isItalic = textElement.isOwnItalic();
        this.isUnderline = textElement.isOwnUnderline();
        this.isStrikeThrough = textElement.isOwnStrikeThrough();
        this.fontsize = textElement.getOwnFontsize();
        this.pdfFontName = textElement.getOwnPdfFontName();
        this.pdfEncoding = textElement.getOwnPdfEncoding();
        this.isPdfEmbedded = textElement.isOwnPdfEmbedded();
    }

    @Override
    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return JRStyleResolver.getHorizontalAlignmentValue(this);
    }

    @Override
    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return this.horizontalAlignmentValue;
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignmentValue) {
        HorizontalAlignEnum old = this.horizontalAlignmentValue;
        this.horizontalAlignmentValue = horizontalAlignmentValue;
        this.getEventSupport().firePropertyChange("horizontalAlignment", old, this.horizontalAlignmentValue);
    }

    @Override
    public VerticalAlignEnum getVerticalAlignmentValue() {
        return JRStyleResolver.getVerticalAlignmentValue(this);
    }

    @Override
    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return this.verticalAlignmentValue;
    }

    @Override
    public void setVerticalAlignment(VerticalAlignEnum verticalAlignmentValue) {
        VerticalAlignEnum old = this.verticalAlignmentValue;
        this.verticalAlignmentValue = verticalAlignmentValue;
        this.getEventSupport().firePropertyChange("verticalAlignment", old, this.verticalAlignmentValue);
    }

    @Override
    public RotationEnum getRotationValue() {
        return JRStyleResolver.getRotationValue(this);
    }

    @Override
    public RotationEnum getOwnRotationValue() {
        return this.rotationValue;
    }

    @Override
    public void setRotation(RotationEnum rotationValue) {
        RotationEnum old = this.rotationValue;
        this.rotationValue = rotationValue;
        this.getEventSupport().firePropertyChange("rotation", old, this.rotationValue);
    }

    @Override
    public LineSpacingEnum getLineSpacingValue() {
        return this.getParagraph().getLineSpacing();
    }

    @Override
    public LineSpacingEnum getOwnLineSpacingValue() {
        return this.getParagraph().getOwnLineSpacing();
    }

    @Override
    public void setLineSpacing(LineSpacingEnum lineSpacing) {
        this.getParagraph().setLineSpacing(lineSpacing);
    }

    @Override
    public String getMarkup() {
        return JRStyleResolver.getMarkup(this);
    }

    @Override
    public String getOwnMarkup() {
        return this.markup;
    }

    @Override
    public void setMarkup(String markup) {
        String old = this.markup;
        this.markup = markup;
        this.getEventSupport().firePropertyChange("markup", old, this.markup);
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public JRParagraph getParagraph() {
        return this.paragraph;
    }

    public JRFont getFont() {
        return this;
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return this.fontName;
    }

    @Override
    public void setFontName(String fontName) {
        String old = this.fontName;
        this.fontName = fontName;
        this.getEventSupport().firePropertyChange("fontName", old, this.fontName);
    }

    @Override
    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return this.isBold;
    }

    @Override
    public void setBold(boolean isBold) {
        this.setBold(isBold ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setBold(Boolean isBold) {
        Boolean old = this.isBold;
        this.isBold = isBold;
        this.getEventSupport().firePropertyChange("isBold", old, this.isBold);
    }

    @Override
    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    @Override
    public void setItalic(boolean isItalic) {
        this.setItalic(isItalic ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setItalic(Boolean isItalic) {
        Boolean old = this.isItalic;
        this.isItalic = isItalic;
        this.getEventSupport().firePropertyChange("isItalic", old, this.isItalic);
    }

    @Override
    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    @Override
    public void setUnderline(boolean isUnderline) {
        this.setUnderline(isUnderline ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setUnderline(Boolean isUnderline) {
        Boolean old = this.isUnderline;
        this.isUnderline = isUnderline;
        this.getEventSupport().firePropertyChange("isUnderline", old, this.isUnderline);
    }

    @Override
    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    @Override
    public void setStrikeThrough(boolean isStrikeThrough) {
        this.setStrikeThrough(isStrikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setStrikeThrough(Boolean isStrikeThrough) {
        Boolean old = this.isStrikeThrough;
        this.isStrikeThrough = isStrikeThrough;
        this.getEventSupport().firePropertyChange("isStrikeThrough", old, this.isStrikeThrough);
    }

    @Override
    public float getFontsize() {
        return JRStyleResolver.getFontsize(this);
    }

    @Override
    public Float getOwnFontsize() {
        return this.fontsize;
    }

    @Override
    public void setFontSize(Float fontSize) {
        Float old = this.fontsize;
        this.fontsize = fontSize;
        this.getEventSupport().firePropertyChange("fontSize", old, this.fontsize);
    }

    @Override
    public int getFontSize() {
        return (int)this.getFontsize();
    }

    @Override
    public Integer getOwnFontSize() {
        return this.fontsize == null ? null : Integer.valueOf(this.fontsize.intValue());
    }

    @Override
    public void setFontSize(int fontSize) {
        this.setFontSize(Float.valueOf(fontSize));
    }

    @Override
    public void setFontSize(Integer fontSize) {
        this.setFontSize(fontSize == null ? null : Float.valueOf(fontSize.floatValue()));
    }

    @Override
    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
        String old = this.pdfFontName;
        this.pdfFontName = pdfFontName;
        this.getEventSupport().firePropertyChange("pdfFontName", old, this.pdfFontName);
    }

    @Override
    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
        String old = this.pdfEncoding;
        this.pdfEncoding = pdfEncoding;
        this.getEventSupport().firePropertyChange("pdfEncoding", old, this.pdfEncoding);
    }

    @Override
    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    @Override
    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        Boolean old = this.isPdfEmbedded;
        this.isPdfEmbedded = isPdfEmbedded;
        this.getEventSupport().firePropertyChange("isPdfEmbedded", old, this.isPdfEmbedded);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public Object clone() {
        JRBaseTextElement clone = (JRBaseTextElement)super.clone();
        clone.lineBox = this.lineBox.clone(clone);
        clone.paragraph = this.paragraph.clone(clone);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.horizontalAlignmentValue = HorizontalAlignEnum.getByValue(this.horizontalAlignment);
            this.verticalAlignmentValue = VerticalAlignEnum.getByValue(this.verticalAlignment);
            this.rotationValue = RotationEnum.getByValue(this.rotation);
            this.lineSpacingValue = LineSpacingEnum.getByValue(this.lineSpacing);
            this.horizontalAlignment = null;
            this.verticalAlignment = null;
            this.rotation = null;
            this.lineSpacing = null;
        }
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        if (this.isStyledText != null) {
            this.markup = this.isStyledText != false ? "styled" : "none";
            this.isStyledText = null;
        }
        if (this.paragraph == null) {
            this.paragraph = new JRBaseParagraph(this);
            this.paragraph.setLineSpacing(this.lineSpacingValue);
            this.lineSpacingValue = null;
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 50502) {
            this.fontsize = this.fontSize == null ? null : Float.valueOf(this.fontSize.floatValue());
            this.fontSize = null;
        }
    }
}

