/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;

public abstract class AbstractXlsDataSource
extends JRAbstractTextDataSource
implements JRRewindableDataSource {
    protected String sheetSelection;
    protected DateFormat dateFormat = new SimpleDateFormat();
    protected NumberFormat numberFormat = new DecimalFormat();
    protected Map<String, Integer> columnNames = new LinkedHashMap<String, Integer>();
    protected boolean useFirstRowAsHeader;

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.checkReadStarted();
        this.dateFormat = dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.checkReadStarted();
        this.numberFormat = numberFormat;
    }

    public void setColumnNames(String[] columnNames) {
        this.checkReadStarted();
        int i = 0;
        while (i < columnNames.length) {
            this.columnNames.put(columnNames[i], i);
            ++i;
        }
    }

    public void setColumnNames(String[] columnNames, int[] columnIndexes) {
        this.checkReadStarted();
        if (columnNames.length != columnIndexes.length) {
            throw new JRRuntimeException("The number of column names must be equal to the number of column indexes.");
        }
        int i = 0;
        while (i < columnNames.length) {
            this.columnNames.put(columnNames[i], columnIndexes[i]);
            ++i;
        }
    }

    public void setColumnIndexes(Integer[] columnIndexes) {
        this.checkReadStarted();
        int i = 0;
        while (i < columnIndexes.length) {
            this.columnNames.put("COLUMN_" + i, columnIndexes[i]);
            ++i;
        }
    }

    public void setUseFirstRowAsHeader(boolean useFirstRowAsHeader) {
        this.checkReadStarted();
        this.useFirstRowAsHeader = useFirstRowAsHeader;
    }

    public abstract void close();

    protected abstract void checkReadStarted();

    public Map<String, Integer> getColumnNames() {
        return this.columnNames;
    }

    public String getSheetSelection() {
        return this.sheetSelection;
    }

    public void setSheetSelection(String sheetSelection) {
        this.checkReadStarted();
        this.sheetSelection = sheetSelection;
    }
}

