/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AwtTextRenderer;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterContext;
import net.sf.jasperreports.engine.export.draw.FrameDrawer;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.export.Graphics2DExporterConfiguration;
import net.sf.jasperreports.export.Graphics2DExporterOutput;
import net.sf.jasperreports.export.Graphics2DReportConfiguration;
import net.sf.jasperreports.export.parameters.ParametersGraphics2DExporterOutput;

public class JRGraphics2DExporter
extends JRAbstractExporter<Graphics2DReportConfiguration, Graphics2DExporterConfiguration, Graphics2DExporterOutput, JRGraphics2DExporterContext> {
    private static final float DEFAULT_ZOOM = 1.0f;
    public static final String MINIMIZE_PRINTER_JOB_SIZE = "net.sf.jasperreports.export.graphics2d.min.job.size";
    private static final String GRAPHICS2D_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.graphics2d.";
    public static final String GRAPHICS2D_EXPORTER_KEY = "net.sf.jasperreports.graphics2d";
    protected AwtTextRenderer textRenderer;
    protected FrameDrawer frameDrawer;

    public JRGraphics2DExporter() throws JRException {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRGraphics2DExporter(JasperReportsContext jasperReportsContext) throws JRException {
        super(jasperReportsContext);
        JRGraphEnvInitializer.initializeGraphEnv();
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<Graphics2DExporterConfiguration> getConfigurationInterface() {
        return Graphics2DExporterConfiguration.class;
    }

    @Override
    protected Class<Graphics2DReportConfiguration> getItemConfigurationInterface() {
        return Graphics2DReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersGraphics2DExporterOutput(this.parameters);
        }
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        Graphics2D grx = ((Graphics2DExporterOutput)this.getExporterOutput()).getGraphics2D();
        try {
            this.exportReportToGraphics2D(grx);
        }
        finally {
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
        this.setOffset(false);
        Graphics2DReportConfiguration configuration = (Graphics2DReportConfiguration)this.getCurrentItemConfiguration();
        Boolean isMinimizePrinterJobSize = configuration.isMinimizePrinterJobSize();
        Boolean isIgnoreMissingFont = configuration.isIgnoreMissingFont();
        this.textRenderer = new AwtTextRenderer(this.jasperReportsContext, isMinimizePrinterJobSize == null ? Boolean.TRUE : isMinimizePrinterJobSize, isIgnoreMissingFont == null ? Boolean.FALSE : isIgnoreMissingFont);
        this.frameDrawer = new FrameDrawer((JRGraphics2DExporterContext)this.exporterContext, this.filter, this.textRenderer);
    }

    public void exportReportToGraphics2D(Graphics2D grx) throws JRException {
        grx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        grx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        grx.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.setCurrentExporterInputItem(this.exporterInput.getItems().get(0));
        Object configuration = this.getCurrentItemConfiguration();
        AffineTransform atrans = new AffineTransform();
        atrans.translate(configuration.getOffsetX() == null ? 0 : configuration.getOffsetX(), configuration.getOffsetY() == null ? 0 : configuration.getOffsetY());
        float zoom = this.getZoom();
        atrans.scale(zoom, zoom);
        grx.transform(atrans);
        List<JRPrintPage> pages = this.jasperPrint.getPages();
        if (pages != null) {
            JRAbstractExporter.PageRange pageRange = this.getPageRange();
            int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
            Shape oldClipShape = grx.getClip();
            grx.clip(new Rectangle(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight()));
            try {
                JRPrintPage page = pages.get(startPageIndex);
                this.exportPage(grx, page);
            }
            finally {
                grx.setClip(oldClipShape);
            }
        }
    }

    protected void exportPage(Graphics2D grx, JRPrintPage page) throws JRException {
        grx.setColor(Color.white);
        grx.fillRect(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.frameDrawer.draw(grx, (Collection<JRPrintElement>)page.getElements(), this.getOffsetX(), this.getOffsetY());
        JRExportProgressMonitor progressMonitor = ((Graphics2DReportConfiguration)this.getCurrentItemConfiguration()).getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    @Override
    public String getExporterKey() {
        return GRAPHICS2D_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return GRAPHICS2D_EXPORTER_PROPERTIES_PREFIX;
    }

    public FrameDrawer getFrameDrawer() {
        return this.frameDrawer;
    }

    private float getZoom() {
        float zoom = 1.0f;
        Float zoomRatio = ((Graphics2DReportConfiguration)this.getCurrentItemConfiguration()).getZoomRatio();
        if (zoomRatio != null && (zoom = zoomRatio.floatValue()) <= 0.0f) {
            throw new JRRuntimeException("Invalid zoom ratio : " + zoom);
        }
        return zoom;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRGraphics2DExporterContext {
        protected ExporterContext() {
        }
    }
}

