/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.fill.DatasetSortUtil;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillDatasetRun;
import net.sf.jasperreports.engine.fill.SortInfo;
import net.sf.jasperreports.engine.fill.SortedDataSource;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;

class SortFillDatasetRun
extends JRFillDatasetRun {
    private JRSortField[] allSortFields;
    private SortInfo sortInfo;
    private int recordIndex;
    private List<SortedDataSource.SortRecord> records;

    public SortFillDatasetRun(JRBaseFiller filler, JRFillDataset dataset, SortInfo sortInfo) throws JRException {
        super(filler, (JRDatasetRun)new JRDesignDatasetRun(), dataset);
        this.allSortFields = DatasetSortUtil.getAllSortFields(dataset);
        this.sortInfo = sortInfo;
    }

    public List<SortedDataSource.SortRecord> sort() throws JRException {
        this.recordIndex = 0;
        this.records = new ArrayList<SortedDataSource.SortRecord>();
        try {
            this.iterate();
        }
        finally {
            this.dataset.closeQueryExecuter();
            this.dataset.reset();
        }
        return this.records;
    }

    @Override
    protected void detail() throws JRScriptletException, JRException {
        int i;
        super.detail();
        int fieldCount = this.sortInfo.fieldNames.size();
        JRField[] fields = this.dataset.getFields();
        Object[] record = new Object[fieldCount];
        if (fields != null) {
            i = 0;
            while (i < fields.length) {
                record[i] = this.dataset.getFieldValue(fields[i].getName());
                ++i;
            }
        }
        i = 0;
        while (i < this.allSortFields.length) {
            JRSortField sortField = this.allSortFields[i];
            if (sortField.getType() == SortFieldTypeEnum.VARIABLE) {
                record[this.sortInfo.sortFieldInfo[i].index] = this.dataset.getVariableValue(sortField.getName());
            }
            ++i;
        }
        SortedDataSource.SortRecord sortRecord = new SortedDataSource.SortRecord(record, this.recordIndex);
        ++this.recordIndex;
        this.records.add(sortRecord);
    }

    @Override
    protected boolean advanceDataset() throws JRException {
        return this.dataset.next(true);
    }
}

