/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class JRStringUtil {
    protected static final String JAVA_IDENTIFIER_PREFIX = "j";

    public static String replaceCRwithLF(String text) {
        if (text != null) {
            int length = text.length();
            char[] chars = text.toCharArray();
            int r = 0;
            boolean dirty = false;
            int i = 0;
            while (i < length) {
                char ch = chars[i];
                if (ch == '\r') {
                    dirty = true;
                    if (i + 1 < length && chars[i + 1] == '\n') {
                        ++r;
                    } else {
                        chars[i - r] = 10;
                    }
                } else {
                    chars[i - r] = ch;
                }
                ++i;
            }
            return dirty ? new String(chars, 0, length - r) : text;
        }
        return null;
    }

    public static String xmlEncode(String text) {
        return JRStringUtil.xmlEncode(text, null);
    }

    public static String xmlEncode(String text, String invalidCharReplacement) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int length = text.length();
        StringBuffer ret = new StringBuffer(length * 12 / 10);
        int last = 0;
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            if (Character.isISOControl(c) && c != '\t' && c != '\r' && c != '\n') {
                last = JRStringUtil.appendText(text, ret, i, last);
                if (invalidCharReplacement == null) {
                    ret.append(c);
                } else if (!"".equals(invalidCharReplacement)) {
                    ret.append(invalidCharReplacement);
                }
            } else {
                switch (c) {
                    case '&': {
                        last = JRStringUtil.appendText(text, ret, i, last);
                        ret.append("&amp;");
                        break;
                    }
                    case '>': {
                        last = JRStringUtil.appendText(text, ret, i, last);
                        ret.append("&gt;");
                        break;
                    }
                    case '<': {
                        last = JRStringUtil.appendText(text, ret, i, last);
                        ret.append("&lt;");
                        break;
                    }
                    case '\"': {
                        last = JRStringUtil.appendText(text, ret, i, last);
                        ret.append("&quot;");
                        break;
                    }
                    case '\'': {
                        last = JRStringUtil.appendText(text, ret, i, last);
                        ret.append("&apos;");
                        break;
                    }
                }
            }
            ++i;
        }
        JRStringUtil.appendText(text, ret, length, last);
        return ret.toString();
    }

    public static String encodeXmlAttribute(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int length = text.length();
        StringBuffer ret = new StringBuffer(length * 12 / 10);
        int last = 0;
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&amp;");
                    break;
                }
                case '>': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&gt;");
                    break;
                }
                case '<': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&lt;");
                    break;
                }
                case '\"': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&quot;");
                    break;
                }
                case '\'': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&apos;");
                    break;
                }
                case '\t': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&#x9;");
                    break;
                }
                case '\r': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&#xD;");
                    break;
                }
                case '\n': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&#xA;");
                    break;
                }
            }
            ++i;
        }
        if (last == 0) {
            return text;
        }
        JRStringUtil.appendText(text, ret, length, last);
        return ret.toString();
    }

    private static int appendText(String text, StringBuffer ret, int current, int old) {
        if (old < current) {
            ret.append(text.substring(old, current));
        }
        return current + 1;
    }

    public static String htmlEncode(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int length = text.length();
        StringBuffer ret = new StringBuffer(length * 12 / 10);
        boolean isEncodeSpace = true;
        int last = 0;
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            switch (c) {
                case ' ': {
                    if (isEncodeSpace) {
                        if (last < i) {
                            ret.append(text.substring(last, i));
                        }
                        last = i + 1;
                        ret.append("&nbsp;");
                        isEncodeSpace = false;
                        break;
                    }
                    isEncodeSpace = true;
                    break;
                }
                case '&': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("&amp;");
                    isEncodeSpace = false;
                    break;
                }
                case '>': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("&gt;");
                    isEncodeSpace = false;
                    break;
                }
                case '<': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("&lt;");
                    isEncodeSpace = false;
                    break;
                }
                case '\"': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("&quot;");
                    isEncodeSpace = false;
                    break;
                }
                case '\n': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("<br/>");
                    isEncodeSpace = false;
                    break;
                }
                default: {
                    isEncodeSpace = false;
                }
            }
            ++i;
        }
        if (last < length) {
            ret.append(text.substring(last));
        }
        return ret.toString();
    }

    public static String getJavaIdentifier(String name) {
        if (JRStringUtil.isValidJavaIdentifier(name)) {
            return name;
        }
        StringBuffer buffer = new StringBuffer(name.length() + 5);
        char[] literalChars = new char[name.length()];
        name.getChars(0, literalChars.length, literalChars, 0);
        int i = 0;
        while (i < literalChars.length) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                buffer.append(JAVA_IDENTIFIER_PREFIX);
                buffer.append((int)literalChars[i]);
            } else if (i != 0 && !Character.isJavaIdentifierPart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
            } else {
                buffer.append(literalChars[i]);
            }
            ++i;
        }
        return buffer.toString();
    }

    private static boolean isValidJavaIdentifier(String literal) {
        boolean result = true;
        char[] literalChars = new char[literal.length()];
        literal.getChars(0, literalChars.length, literalChars, 0);
        int i = 0;
        while (i < literalChars.length) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                result = false;
                break;
            }
            if (i != 0 && !Character.isJavaIdentifierPart(literalChars[i])) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public static String escapeJavaStringLiteral(String text) {
        if (text == null) {
            return text;
        }
        StringBuffer sbuffer = new StringBuffer();
        StringTokenizer tkzer = new StringTokenizer(text, "\\\"\n\r\t", true);
        while (tkzer.hasMoreTokens()) {
            String token = tkzer.nextToken();
            if ("\\".equals(token)) {
                sbuffer.append("\\\\");
                continue;
            }
            if ("\"".equals(token)) {
                sbuffer.append("\\\"");
                continue;
            }
            if ("\n".equals(token)) {
                sbuffer.append("\\n");
                continue;
            }
            if ("\r".equals(token)) {
                sbuffer.append("\\r");
                continue;
            }
            if ("\t".equals(token)) {
                sbuffer.append("\\t");
                continue;
            }
            sbuffer.append(token);
        }
        return sbuffer.toString();
    }

    public static String escapeJavaScript(String input) {
        if (input == null) {
            return input;
        }
        StringBuilder filtered = new StringBuilder(input.length());
        char prevChar = '\u0000';
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == '\"') {
                filtered.append("\\\"");
            } else if (c == '\'') {
                filtered.append("\\'");
            } else if (c == '\\') {
                filtered.append("\\\\");
            } else if (c == '/') {
                filtered.append("\\/");
            } else if (c == '\t') {
                filtered.append("\\t");
            } else if (c == '\n') {
                if (prevChar != '\r') {
                    filtered.append("\\n");
                }
            } else if (c == '\r') {
                filtered.append("\\n");
            } else if (c == '\f') {
                filtered.append("\\f");
            } else {
                filtered.append(c);
            }
            prevChar = c;
            ++i;
        }
        return filtered.toString();
    }

    public static String escapeString4JavaScript(String input) {
        if (input == null) {
            return input;
        }
        StringBuilder filtered = new StringBuilder(input.length());
        char prevChar = '\u0000';
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == '\"') {
                filtered.append("\\\"");
            } else if (c == '\\') {
                filtered.append("\\\\");
            } else if (c == '/') {
                filtered.append("\\/");
            } else if (c == '\t') {
                filtered.append("\\t");
            } else if (c == '\n') {
                if (prevChar != '\r') {
                    filtered.append("\\n");
                }
            } else if (c == '\r') {
                filtered.append("\\n");
            } else if (c == '\f') {
                filtered.append("\\f");
            } else {
                filtered.append(c);
            }
            prevChar = c;
            ++i;
        }
        return filtered.toString();
    }

    public static List<Integer> getTabIndexes(String text) {
        int index;
        ArrayList<Integer> tabIndexes = null;
        if (text != null && (index = text.indexOf(9)) >= 0) {
            tabIndexes = new ArrayList<Integer>();
            do {
                tabIndexes.add(index);
            } while ((index = text.indexOf(9, index + 1)) >= 0);
        }
        return tabIndexes;
    }

    public static List<String> split(String[] srcArray, String delimiterRegExp) {
        ArrayList<String> tokens = null;
        if (srcArray != null) {
            tokens = new ArrayList<String>();
            int i = 0;
            while (i < srcArray.length) {
                if (srcArray[i] == null) {
                    tokens.add(null);
                } else {
                    String[] currentTokensArray = srcArray[i].split(delimiterRegExp);
                    int j = 0;
                    while (j < currentTokensArray.length) {
                        tokens.add(currentTokensArray[j].trim());
                        ++j;
                    }
                }
                ++i;
            }
        }
        return tokens;
    }

    public static String getString(Object value) {
        return value == null ? null : value.toString();
    }

    public static String escapeJSONString(String text) {
        if (text == null) {
            return null;
        }
        char[] escapedChars = JsonStringEncoder.getInstance().quoteAsString(text);
        if (text.contentEquals(CharBuffer.wrap(escapedChars))) {
            return text;
        }
        return String.valueOf(escapedChars);
    }

    private JRStringUtil() {
    }
}

