/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.util.Map;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignFont;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import org.xml.sax.Attributes;

public abstract class JRFontFactory
extends JRBaseFactory {
    public abstract JRFont getFont();

    public abstract void setStyle(JRFont var1, Attributes var2);

    public Object createObject(Attributes atts) {
        JRFont font = this.getFont();
        if (atts.getValue("fontName") != null) {
            font.setFontName(atts.getValue("fontName"));
        }
        if (atts.getValue("isBold") != null) {
            font.setBold(Boolean.valueOf(atts.getValue("isBold")));
        }
        if (atts.getValue("isItalic") != null) {
            font.setItalic(Boolean.valueOf(atts.getValue("isItalic")));
        }
        if (atts.getValue("isUnderline") != null) {
            font.setUnderline(Boolean.valueOf(atts.getValue("isUnderline")));
        }
        if (atts.getValue("isStrikeThrough") != null) {
            font.setStrikeThrough(Boolean.valueOf(atts.getValue("isStrikeThrough")));
        }
        if (atts.getValue("size") != null) {
            font.setFontSize(Float.valueOf(Float.parseFloat(atts.getValue("size"))));
        }
        if (atts.getValue("pdfFontName") != null) {
            font.setPdfFontName(atts.getValue("pdfFontName"));
        }
        if (atts.getValue("pdfEncoding") != null) {
            font.setPdfEncoding(atts.getValue("pdfEncoding"));
        }
        if (atts.getValue("isPdfEmbedded") != null) {
            font.setPdfEmbedded(Boolean.valueOf(atts.getValue("isPdfEmbedded")));
        }
        this.setStyle(font, atts);
        return font;
    }

    public static class ChartFontFactory
    extends JRFontFactory {
        @Override
        public JRFont getFont() {
            int i = 0;
            JRChart chart = null;
            while (chart == null && i < this.digester.getCount()) {
                Object obj = this.digester.peek(i);
                chart = obj instanceof JRChart ? (JRChart)obj : null;
                ++i;
            }
            return new JRDesignFont(chart);
        }

        @Override
        public void setStyle(JRFont font, Attributes atts) {
            JRDesignFont designFont = (JRDesignFont)font;
            String styleName = atts.getValue("reportFont");
            if (styleName != null) {
                JasperDesign jasperDesign = (JasperDesign)this.digester.peek(this.digester.getCount() - 2);
                Map<String, JRStyle> stylesMap = jasperDesign.getStylesMap();
                if (stylesMap.containsKey(styleName)) {
                    JRStyle style = stylesMap.get(styleName);
                    designFont.setStyle(style);
                } else {
                    designFont.setStyleNameReference(styleName);
                }
            }
        }
    }

    public static class TextElementFontFactory
    extends JRFontFactory {
        @Override
        public JRFont getFont() {
            return (JRFont)this.digester.peek();
        }

        @Override
        public void setStyle(JRFont font, Attributes atts) {
            String styleName;
            JRDesignElement element = (JRDesignElement)((Object)font);
            if (element.getStyle() == null && element.getStyleNameReference() == null && (styleName = atts.getValue("reportFont")) != null) {
                JasperDesign jasperDesign = (JasperDesign)this.digester.peek(this.digester.getCount() - 2);
                Map<String, JRStyle> stylesMap = jasperDesign.getStylesMap();
                if (stylesMap.containsKey(styleName)) {
                    JRStyle style = stylesMap.get(styleName);
                    element.setStyle(style);
                } else {
                    element.setStyleNameReference(styleName);
                }
            }
        }
    }
}

