/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.JREnum;
import net.sf.jasperreports.export.CommonExportConfiguration;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.annotations.ExporterProperty;
import org.apache.commons.lang.ClassUtils;

public class PropertiesDefaultsConfigurationFactory<C extends CommonExportConfiguration> {
    private final JasperReportsContext jasperReportsContext;

    public PropertiesDefaultsConfigurationFactory(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public C getConfiguration(Class<C> configurationInterface) {
        return this.getProxy(configurationInterface, new PropertiesDefaultsInvocationHandler());
    }

    private final C getProxy(Class<?> clazz, InvocationHandler handler) {
        ArrayList allInterfaces = new ArrayList();
        if (clazz.isInterface()) {
            allInterfaces.add(clazz);
        } else {
            List lcInterfaces = ClassUtils.getAllInterfaces(clazz);
            allInterfaces.addAll(lcInterfaces);
        }
        CommonExportConfiguration proxy = (CommonExportConfiguration)Proxy.newProxyInstance(ExporterConfiguration.class.getClassLoader(), allInterfaces.toArray(new Class[allInterfaces.size()]), handler);
        return (C)proxy;
    }

    protected Object getPropertyValue(Method method) {
        Object value = null;
        ExporterProperty exporterProperty = method.getAnnotation(ExporterProperty.class);
        if (exporterProperty != null) {
            value = PropertiesDefaultsConfigurationFactory.getPropertyValue(this.jasperReportsContext, exporterProperty, method.getReturnType());
        }
        return value;
    }

    public static Object getPropertyValue(JasperReportsContext jasperReportsContext, ExporterProperty exporterProperty, Class<?> type) {
        Object value = null;
        String propertyName = exporterProperty.value();
        JRPropertiesUtil propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        if (String[].class.equals(type)) {
            List<JRPropertiesUtil.PropertySuffix> properties = propertiesUtil.getProperties(propertyName);
            if (properties != null && !properties.isEmpty()) {
                String[] values = new String[properties.size()];
                int i = 0;
                while (i < values.length) {
                    values[i] = properties.get(i).getValue();
                    ++i;
                }
                value = values;
            }
        } else {
            String strValue = propertiesUtil.getProperty(propertyName);
            if (String.class.equals(type)) {
                value = strValue;
            } else if (Character.class.equals(type)) {
                value = JRPropertiesUtil.asCharacter(strValue);
            } else if (Integer.class.equals(type)) {
                if (strValue == null) {
                    if (!exporterProperty.acceptNull()) {
                        value = exporterProperty.intDefault();
                    }
                } else {
                    value = JRPropertiesUtil.asInteger(strValue);
                }
            } else if (Long.class.equals(type)) {
                if (strValue == null) {
                    if (!exporterProperty.acceptNull()) {
                        value = exporterProperty.longDefault();
                    }
                } else {
                    value = JRPropertiesUtil.asLong(strValue);
                }
            } else if (Float.class.equals(type)) {
                if (strValue == null) {
                    if (!exporterProperty.acceptNull()) {
                        value = Float.valueOf(exporterProperty.floatDefault());
                    }
                } else {
                    value = Float.valueOf(JRPropertiesUtil.asFloat(strValue));
                }
            } else if (Boolean.class.equals(type)) {
                if (strValue == null) {
                    if (!exporterProperty.acceptNull()) {
                        value = exporterProperty.booleanDefault();
                    }
                } else {
                    value = JRPropertiesUtil.asBoolean(strValue);
                }
            } else if (JREnum.class.isAssignableFrom(type)) {
                if (strValue != null) {
                    try {
                        Method byNameMethod = type.getMethod("getByName", String.class);
                        value = byNameMethod.invoke(null, strValue);
                    }
                    catch (NoSuchMethodException e) {
                        throw new JRRuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new JRRuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new JRRuntimeException(e);
                    }
                }
            } else {
                throw new JRRuntimeException("Export property type " + type + " not supported.");
            }
        }
        return value;
    }

    class PropertiesDefaultsInvocationHandler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return PropertiesDefaultsConfigurationFactory.this.getPropertyValue(method);
        }
    }
}

