/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap.mapping;

import net.sf.jasperreports.olap.mapping.Axis;
import net.sf.jasperreports.olap.mapping.MemberDepth;
import net.sf.jasperreports.olap.mapping.TuplePosition;
import net.sf.jasperreports.olap.result.JROlapMember;

public class Member {
    private final TuplePosition pos;
    private final MemberDepth depth;

    public Member(TuplePosition pos, MemberDepth depth) {
        this.pos = pos;
        this.depth = depth;
    }

    public Axis getAxis() {
        return this.pos.getAxis();
    }

    public MemberDepth getDepth() {
        return this.depth;
    }

    public TuplePosition getPosition() {
        return this.pos;
    }

    public boolean matches(JROlapMember member) {
        int memberDepth = member.getDepth();
        boolean match = this.depth == null ? true : memberDepth == this.depth.getDepth();
        return match;
    }

    public JROlapMember ancestorMatch(JROlapMember member) {
        JROlapMember ancestor;
        int memberDepth = member.getDepth();
        if (this.depth == null) {
            ancestor = member;
        } else if (this.depth.getDepth() <= memberDepth) {
            ancestor = member;
            int i = this.depth.getDepth();
            while (i < memberDepth && ancestor != null) {
                ancestor = ancestor.getParentMember();
                ++i;
            }
        } else {
            ancestor = null;
        }
        return ancestor;
    }
}

