/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap.xmla;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.olap.result.JROlapHierarchy;
import net.sf.jasperreports.olap.result.JROlapMemberTuple;
import net.sf.jasperreports.olap.result.JROlapResultAxis;
import net.sf.jasperreports.olap.xmla.JRXmlaHierarchy;
import net.sf.jasperreports.olap.xmla.JRXmlaMember;
import net.sf.jasperreports.olap.xmla.JRXmlaMemberTuple;

public class JRXmlaResultAxis
implements JROlapResultAxis {
    private final String axisName;
    private final List<JRXmlaHierarchy> hierarchyList;
    private JRXmlaHierarchy[] hierarchies;
    private final List<JRXmlaMemberTuple> tuples;

    public JRXmlaResultAxis(String axisName) {
        this.axisName = axisName;
        this.hierarchyList = new ArrayList<JRXmlaHierarchy>();
        this.tuples = new ArrayList<JRXmlaMemberTuple>();
    }

    public String getAxisName() {
        return this.axisName;
    }

    @Override
    public JROlapHierarchy[] getHierarchiesOnAxis() {
        return this.ensureHierarchyArray();
    }

    @Override
    public JROlapMemberTuple getTuple(int index) {
        if (index < 0 || index >= this.tuples.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.tuples.size());
        }
        return this.tuples.get(index);
    }

    @Override
    public int getTupleCount() {
        return this.tuples.size();
    }

    public void addHierarchy(JRXmlaHierarchy hierarchy) {
        this.hierarchyList.add(hierarchy);
        this.resetHierarchyArray();
    }

    public void addTuple(JRXmlaMemberTuple tuple) {
        this.tuples.add(tuple);
        this.copyLevelInfo(tuple);
    }

    protected void copyLevelInfo(JRXmlaMemberTuple tuple) {
        JRXmlaMember[] members = tuple.getXmlaMembers();
        int idx = 0;
        Iterator<JRXmlaHierarchy> it = this.hierarchyList.iterator();
        while (it.hasNext() && idx < members.length) {
            JRXmlaHierarchy hierarchy = it.next();
            JRXmlaMember member = members[idx];
            if (hierarchy.getDimensionName().equals(member.getDimensionName())) {
                hierarchy.setLevel(member.getLevelName(), member.getDepth());
            }
            ++idx;
        }
    }

    protected JRXmlaHierarchy[] ensureHierarchyArray() {
        if (this.hierarchies == null) {
            this.hierarchies = new JRXmlaHierarchy[this.hierarchyList.size()];
            this.hierarchies = this.hierarchyList.toArray(this.hierarchies);
        }
        return this.hierarchies;
    }

    protected void resetHierarchyArray() {
        this.hierarchies = null;
    }
}

