/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.Random;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.util.Validador;

public class CNPJ
extends Informacao<CNPJ> {
    public CNPJ() {
    }

    public CNPJ(ObjetoNegocio owner, String nomeCampo) {
        super(owner, nomeCampo);
    }

    @Override
    public String getConteudoFormatado() {
        return UtilitariosString.formataCNPJ(this.asString());
    }

    @Override
    public void setConteudo(String conteudo) {
        super.setConteudo(UtilitariosString.retiraMascara(conteudo));
    }

    @Override
    public void setConteudo(CNPJ pValor) {
        this.setConteudo(pValor.naoFormatado());
    }

    @Override
    public String formatado() {
        return UtilitariosString.formataCNPJ(this.naoFormatado());
    }

    public static String gerarAleatorio() {
        Random r = new Random();
        StringBuilder sbCnpjNumber = new StringBuilder();
        for (int i = 0; i < 12; ++i) {
            sbCnpjNumber.append(r.nextInt(9));
        }
        return CNPJ.generateDigits(sbCnpjNumber.toString());
    }

    private static String generateDigits(String baseCnpj) {
        String dv1 = String.valueOf(Validador.calcularModulo11(baseCnpj, "543298765432", 2));
        String dv2 = String.valueOf(Validador.calcularModulo11(baseCnpj + dv1, "6543298765432", 2));
        return baseCnpj + dv1 + dv2;
    }
}

