/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.Random;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.UtilitariosString;

public class CPF
extends Informacao<CPF> {
    public CPF() {
    }

    public CPF(ObjetoNegocio owner, String nomeCampo) {
        super(owner, nomeCampo);
    }

    @Override
    public String getConteudoFormatado() {
        return UtilitariosString.formataCPF(this.asString());
    }

    @Override
    public void setConteudo(String conteudo) {
        super.setConteudo(UtilitariosString.retiraMascara(conteudo));
    }

    @Override
    public void setConteudo(CPF pValor) {
        this.setConteudo(pValor.naoFormatado());
    }

    @Override
    public String formatado() {
        return UtilitariosString.formataCPF(this.naoFormatado());
    }

    public static String gerarAleatorio() {
        Random r = new Random();
        StringBuilder sbCpfNumber = new StringBuilder();
        for (int i = 0; i < 9; ++i) {
            sbCpfNumber.append(r.nextInt(9));
        }
        return CPF.generateDigits(sbCpfNumber.toString());
    }

    private static String generateDigits(String digitsBase) {
        StringBuilder sbCpfNumber = new StringBuilder(digitsBase);
        int total = 0;
        int multiple = digitsBase.length() + 1;
        for (char digit : digitsBase.toCharArray()) {
            long parcial = Integer.parseInt(String.valueOf(digit)) * multiple--;
            total = (int)((long)total + parcial);
        }
        int resto = Integer.parseInt(String.valueOf(Math.abs(total % 11)));
        resto = resto < 2 ? 0 : 11 - resto;
        sbCpfNumber.append(resto);
        if (sbCpfNumber.length() < 11) {
            return CPF.generateDigits(sbCpfNumber.toString());
        }
        return sbCpfNumber.toString();
    }
}

