/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.OpcaoLogico;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.ValidadorImpeditivoLogico;
import serpro.ppgd.negocio.util.LogPPGD;

public class Logico
extends Informacao<Logico> {
    private String conteudo = "";
    public static String SIM = "1";
    public static String NAO = "0";
    public static String LABEL_SIM = "Sim";
    public static String LABEL_NAO = "N\u00e3o";
    public boolean selecaoMultipla = false;
    private Map<String, OpcaoLogico> opcoes;
    private LinkedList<OpcaoLogico> listaOrdenada;
    private List<ValidadorIf> listaValidadoresImpeditivosTemporaria;

    public Logico() {
        super("");
    }

    @Override
    public void addValidador(ValidadorIf validador) {
        if (validador instanceof ValidadorImpeditivoDefault && !(validador instanceof ValidadorImpeditivoLogico)) {
            throw new IllegalArgumentException("O Validador adicionado n\u00e3o \u00e9 do tipo ValidadorImpeditivoLogico.\n Fa\u00e7a com que esse herde de ValidadorImpeditivoLogico.");
        }
        if (validador instanceof ValidadorImpeditivoDefault) {
            super.getListaValidadoresImpeditivos().add(validador);
        } else {
            this.getListaValidadores().add(validador);
        }
        validador.setInformacao(this);
        validador.setRetornosValidacoes(this.getRetornoTodasValidacoes());
    }

    public void atualizaListaValidadoresImpeditivos(String proximaOpcao) {
        ArrayList<ValidadorImpeditivoLogico> lista = new ArrayList<ValidadorImpeditivoLogico>(super.getListaValidadoresImpeditivos().size());
        for (ValidadorImpeditivoLogico validadorImpeditivoLogico : super.getListaValidadoresImpeditivos()) {
            if (validadorImpeditivoLogico.getValorOpcaoDoLogico().trim().equals("") || !this.getOpcoes().containsKey(validadorImpeditivoLogico.getValorOpcaoDoLogico().trim()) || !proximaOpcao.equals(validadorImpeditivoLogico.getValorOpcaoDoLogico())) continue;
            lista.add(validadorImpeditivoLogico);
        }
        this.getListaValidadoresImpeditivos().clear();
        this.getListaValidadoresImpeditivos().addAll(lista);
    }

    @Override
    public void ordenaListaValidadoreImpeditivos() {
        LinkedList<ValidadorImpeditivoDefault> retorno = new LinkedList<ValidadorImpeditivoDefault>();
        for (ValidadorImpeditivoDefault validadorImpeditivoDefault : this.getListaValidadoresImpeditivos()) {
            if (validadorImpeditivoDefault.getSeveridade() == 5) {
                retorno.addFirst(validadorImpeditivoDefault);
                continue;
            }
            if (validadorImpeditivoDefault.getSeveridade() != 4) continue;
            retorno.addLast(validadorImpeditivoDefault);
        }
        this.getListaValidadoresImpeditivos().clear();
        this.getListaValidadoresImpeditivos().addAll(retorno);
    }

    @Override
    public List<ValidadorIf> getListaValidadoresImpeditivos() {
        if (this.listaValidadoresImpeditivosTemporaria == null) {
            this.listaValidadoresImpeditivosTemporaria = new ArrayList<ValidadorIf>(5);
        }
        return this.listaValidadoresImpeditivosTemporaria;
    }

    public void adicionaOpcao(String lbl, String val) {
        if (this.getOpcoes().containsKey(val)) {
            this.getListaOrdenada().remove(this.getOpcoes().get(val));
        }
        OpcaoLogico o = new OpcaoLogico(lbl, val);
        this.getOpcoes().put(val, o);
        this.getListaOrdenada().addLast(o);
    }

    public void addOpcao(String codigo, String label) {
        if (this.getOpcoes().containsKey(codigo)) {
            this.getListaOrdenada().remove(this.getOpcoes().get(codigo));
        }
        OpcaoLogico o = new OpcaoLogico(label, codigo);
        this.getOpcoes().put(codigo, o);
        this.getListaOrdenada().addLast(o);
    }

    public String getLabelOpcao(String valor) {
        if (this.getOpcoes().containsKey(valor)) {
            return this.getOpcoes().get((Object)valor).labelOpcao;
        }
        return "";
    }

    public String getValorOpcao(String lbl) {
        String retorno = "";
        for (OpcaoLogico o : this.getOpcoes().values()) {
            if (!o.labelOpcao.trim().equals(lbl.trim())) continue;
            return o.valorOpcao;
        }
        return retorno;
    }

    public Logico(ObjetoNegocio owner, String nomeCampo) {
        super(owner, nomeCampo);
    }

    public void converteEmTipoSimNao(String valorInicial) {
        this.adicionaOpcao(LABEL_SIM, SIM);
        this.adicionaOpcao(LABEL_NAO, NAO);
        this.setConteudo(valorInicial);
    }

    @Override
    public void clear() {
        this.setConteudo("");
    }

    @Override
    public String asString() {
        for (OpcaoLogico o : this.getOpcoes().values()) {
            if (!o.selecionado) continue;
            return o.valorOpcao;
        }
        return this.conteudo;
    }

    @Override
    public String naoFormatado() {
        for (OpcaoLogico o : this.getOpcoes().values()) {
            if (!o.selecionado) continue;
            return o.valorOpcao;
        }
        return this.conteudo;
    }

    @Override
    public String getConteudoFormatado() {
        return this.asString();
    }

    @Override
    public void setConteudo(String val) {
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + String.valueOf(this.conteudo));
        String antigo = this.conteudo;
        this.clearRetornosValidacoes();
        if (!this.getOpcoes().containsKey(val)) {
            val = "";
        }
        this.conteudo = val;
        for (OpcaoLogico o : this.getOpcoes().values()) {
            if (o.valorOpcao.trim().equals(val.trim())) {
                o.selecionado = true;
                continue;
            }
            o.selecionado = false;
        }
        this.disparaObservadores(antigo);
    }

    @Override
    public boolean isVazio() {
        return this.asString() == null || this.asString().trim().length() == 0;
    }

    public Map<String, OpcaoLogico> getOpcoes() {
        if (this.opcoes == null) {
            this.opcoes = new Hashtable<String, OpcaoLogico>();
        }
        return this.opcoes;
    }

    public void setOpcoes(Map<String, OpcaoLogico> opcoes) {
        this.opcoes = opcoes;
    }

    public LinkedList<OpcaoLogico> getListaOrdenada() {
        if (this.listaOrdenada == null) {
            this.listaOrdenada = new LinkedList();
        }
        return this.listaOrdenada;
    }

    public boolean isSelecaoMultipla() {
        return this.selecaoMultipla;
    }

    public void setSelecaoMultipla(boolean selecaoMultipla) {
        this.selecaoMultipla = selecaoMultipla;
    }

    @Override
    public void setConteudo(Logico pValor) {
        this.setConteudo(pValor.asString());
    }

    @Override
    public String formatado() {
        return this.naoFormatado();
    }
}

