/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public abstract class ObjetoNegocio
extends Observador {
    protected String ficha = "";

    protected boolean testaVazio(Informacao pInfo) {
        return true;
    }

    public boolean isVazio() {
        try {
            for (Field lField : FabricaUtilitarios.getAllFields(this.getClass())) {
                ObjetoNegocio obj;
                Informacao info;
                boolean acessible = lField.isAccessible();
                lField.setAccessible(true);
                if (Informacao.class.isAssignableFrom(lField.getType()) ? this.testaVazio(info = (Informacao)lField.get(this)) && !info.isVazio() : ObjetoNegocio.class.isAssignableFrom(lField.getType()) && (obj = (ObjetoNegocio)lField.get(this)) != null && !(obj instanceof IdDeclaracao) && !obj.isVazio()) {
                    return false;
                }
                lField.setAccessible(acessible);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(e);
        }
        return true;
    }

    public List<Informacao> recuperarCamposInformacao() {
        List<Field> fields = FabricaUtilitarios.getAllFields(this.getClass());
        ArrayList<Informacao> retorno = new ArrayList<Informacao>(fields.size());
        try {
            for (Field f : fields) {
                boolean acessible = f.isAccessible();
                f.setAccessible(true);
                if (Informacao.class.isAssignableFrom(f.getType())) {
                    Informacao info = (Informacao)f.get(this);
                    retorno.add(info);
                }
                f.setAccessible(acessible);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(e);
        }
        return retorno;
    }

    public void clear() {
        List<Informacao> lListaInformacao = this.recuperarCamposInformacao();
        for (Informacao informacao : lListaInformacao) {
            informacao.clear();
        }
    }

    @Override
    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
    }

    public void setValidadoresAtivos(boolean opcao) {
        try {
            for (Field f : FabricaUtilitarios.getAllFields(this.getClass())) {
                ObjetoNegocio obj;
                boolean acessible = f.isAccessible();
                f.setAccessible(true);
                if (Informacao.class.isAssignableFrom(f.getType())) {
                    Informacao info = (Informacao)f.get(this);
                    if (info != null) {
                        info.setValidadoresAtivos(opcao);
                    }
                } else if (!IdDeclaracao.class.isAssignableFrom(f.getType()) && ObjetoNegocio.class.isAssignableFrom(f.getType()) && (obj = (ObjetoNegocio)f.get(this)) != null) {
                    obj.setValidadoresAtivos(opcao);
                }
                f.setAccessible(acessible);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(e);
        }
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        ArrayList<Pendencia> listaPendencias = new ArrayList<Pendencia>(this.recuperarListaCamposPendencia().size());
        for (Informacao informacao : this.recuperarListaCamposPendencia()) {
            Enumeration<RetornoValidacao> retornosValidacoes = informacao.validar().elements();
            while (retornosValidacoes.hasMoreElements()) {
                RetornoValidacao retornoValidacao = retornosValidacoes.nextElement();
                if (retornoValidacao.getSeveridade() <= 0) continue;
                Pendencia pendencia = new Pendencia(retornoValidacao.getSeveridade(), informacao, informacao.getNomeCampo(), retornoValidacao.getMensagemValidacao(), numeroItem);
                if (this instanceof ObjetoFicha) {
                    pendencia.setClassePainel(((ObjetoFicha)((Object)this)).getClasseFicha());
                    pendencia.setNomeAba(((ObjetoFicha)((Object)this)).getNomeAba());
                }
                listaPendencias.add(pendencia);
            }
        }
        return listaPendencias;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        ArrayList<Informacao> listaCamposPendencia = new ArrayList<Informacao>(5);
        return listaCamposPendencia;
    }

    public void setFicha(String pFicha) {
        this.ficha = pFicha;
        for (Informacao informacao : this.recuperarListaCamposPendencia()) {
            informacao.setFicha(this.ficha);
        }
    }

    public String getFicha() {
        return this.ficha;
    }

    public void removeObservadoresAnonimosDesnecessarios(Class<?> pClasse) {
        try {
            for (Field f : FabricaUtilitarios.getAllFields(this.getClass())) {
                ObjetoNegocio obj;
                boolean acessivel;
                if (Modifier.isTransient(f.getModifiers())) continue;
                if (Informacao.class.isAssignableFrom(f.getType())) {
                    Informacao info;
                    acessivel = f.isAccessible();
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    if ((info = (Informacao)f.get(this)) != null) {
                        info.removeObservadoresAnonimosDesnecessarios(pClasse);
                    }
                    f.setAccessible(acessivel);
                    continue;
                }
                if (IdDeclaracao.class.isAssignableFrom(f.getType()) || !ObjetoNegocio.class.isAssignableFrom(f.getType())) continue;
                acessivel = f.isAccessible();
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((obj = (ObjetoNegocio)f.get(this)) != null) {
                    obj.removeObservadoresAnonimosDesnecessarios(pClasse);
                }
                f.setAccessible(acessivel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeObservadores(Class<?>[] pClasse) {
        try {
            for (Field f : FabricaUtilitarios.getAllFields(this.getClass())) {
                ObjetoNegocio obj;
                boolean acessivel;
                if (Modifier.isTransient(f.getModifiers())) continue;
                if (Informacao.class.isAssignableFrom(f.getType())) {
                    Informacao info;
                    acessivel = f.isAccessible();
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    if ((info = (Informacao)f.get(this)) != null) {
                        info.removeObservadores(pClasse);
                    }
                    f.setAccessible(acessivel);
                    continue;
                }
                if (IdDeclaracao.class.isAssignableFrom(f.getType()) || !ObjetoNegocio.class.isAssignableFrom(f.getType())) continue;
                acessivel = f.isAccessible();
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((obj = (ObjetoNegocio)f.get(this)) != null) {
                    obj.removeObservadores(pClasse);
                }
                f.setAccessible(acessivel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

