/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.styles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import net.java.balloontip.styles.BalloonTipStyle;

public class MinimalBalloonStyle
extends BalloonTipStyle {
    private final int arcWidth;
    private final Color fillColor;

    public MinimalBalloonStyle(Color fillColor, int arcWidth) {
        this.fillColor = fillColor;
        this.arcWidth = arcWidth;
    }

    public Insets getBorderInsets(Component c) {
        if (this.flipY) {
            return new Insets(this.verticalOffset + this.arcWidth, this.arcWidth, this.arcWidth, this.arcWidth);
        }
        return new Insets(this.arcWidth, this.arcWidth, this.arcWidth + this.verticalOffset, this.arcWidth);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int yBottom;
        int yTop;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.flipY) {
            yTop = y + this.verticalOffset;
            yBottom = y + height;
        } else {
            yTop = y;
            yBottom = y + height - this.verticalOffset;
        }
        GeneralPath outline = new GeneralPath();
        outline.moveTo(x + this.arcWidth, yTop);
        outline.quadTo(x, yTop, x, yTop + this.arcWidth);
        outline.lineTo(x, yBottom - this.arcWidth);
        outline.quadTo(x, yBottom, x + this.arcWidth, yBottom);
        if (!this.flipX && !this.flipY) {
            outline.lineTo(x + this.horizontalOffset - this.verticalOffset, yBottom);
            outline.lineTo(x + this.horizontalOffset, yBottom + this.verticalOffset);
            outline.lineTo(x + this.horizontalOffset + this.verticalOffset, yBottom);
        } else if (this.flipX && !this.flipY) {
            outline.lineTo(x + width - this.horizontalOffset - this.verticalOffset, yBottom);
            outline.lineTo(x + width - this.horizontalOffset, yBottom + this.verticalOffset);
            outline.lineTo(x + width - this.horizontalOffset + this.verticalOffset, yBottom);
        }
        outline.lineTo(x + width - this.arcWidth, yBottom);
        outline.quadTo(x + width, yBottom, x + width, yBottom - this.arcWidth);
        outline.lineTo(x + width, yTop + this.arcWidth);
        outline.quadTo(x + width, yTop, x + width - this.arcWidth, yTop);
        if (!this.flipX && this.flipY) {
            outline.lineTo(x + this.horizontalOffset + this.verticalOffset, yTop);
            outline.lineTo(x + this.horizontalOffset, yTop - this.verticalOffset);
            outline.lineTo(x + this.horizontalOffset - this.verticalOffset, yTop);
        } else if (this.flipX && this.flipY) {
            outline.lineTo(x + width - this.horizontalOffset + this.verticalOffset, yTop);
            outline.lineTo(x + width - this.horizontalOffset, yTop - this.verticalOffset);
            outline.lineTo(x + width - this.horizontalOffset - this.verticalOffset, yTop);
        }
        outline.closePath();
        g2d.setPaint(this.fillColor);
        g2d.fill(outline);
    }

    public int getMinimalHorizontalOffset() {
        return this.arcWidth + this.verticalOffset;
    }

    public boolean isBorderOpaque() {
        return this.fillColor.getAlpha() == 255;
    }
}

