/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.logging.Logger;

public class Name {
    private static final Logger logger = Logger.getLogger(Name.class.toString());
    private static final int HEX_CHAR = 35;
    private String name;

    public Name(String name) {
        if (name != null) {
            this.name = this.convertHexChars(new StringBuilder(name));
        }
    }

    public Name(StringBuilder name) {
        this.name = this.convertHexChars(name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Name) {
            return this.equals((Name)obj);
        }
        return obj != null && this.name.equals(obj);
    }

    public boolean equals(Name obj) {
        return obj != null && this.name.equals(obj.getName());
    }

    public boolean equals(String obj) {
        return obj != null && this.name.equals(obj);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private String convertHexChars(StringBuilder name) {
        try {
            for (int i = 0; i < name.length(); ++i) {
                if (name.charAt(i) != '#') continue;
                String hex = name.substring(i + 1, i + 3);
                name.delete(i, i + 3);
                int charDd = Integer.parseInt(hex, 16);
                if (charDd <= 127) {
                    name.insert(i, (char)charDd);
                    continue;
                }
                name.insert(i, this.convert(hex));
            }
        }
        catch (Throwable e) {
            logger.finer("Error parsing hexadecimal characters.");
            return name.toString();
        }
        return name.toString();
    }

    private String convert(String hex) {
        StringBuilder output = new StringBuilder();
        output.append("\\u");
        int max = 4 - hex.length();
        for (int j = 0; j < max; ++j) {
            output.append("0");
        }
        output.append(hex.toLowerCase());
        return output.toString();
    }
}

