/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.pendencia;

import javax.swing.ImageIcon;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.negocio.Pendencia;

public class LinhaPendencia {
    private byte severidade;
    private String campo;
    private ImageIcon tipo;
    private Pendencia pendencia;

    public LinhaPendencia(byte severidade, String campo, Pendencia pendencia) {
        this.setSeveridade(severidade);
        this.setCampo(campo);
        this.tipo = this.getIconeSeveridade(severidade);
        this.pendencia = pendencia;
    }

    public void setSeveridade(byte severidade) {
        this.severidade = severidade;
    }

    public ImageIcon getTipo() {
        if (this.tipo != null) {
            return this.tipo;
        }
        return new ImageIcon();
    }

    public byte getSeveridade() {
        return this.severidade;
    }

    public String getSeveridadeAsString() {
        switch (this.severidade) {
            case 2: {
                return "AVISO";
            }
            case 3: {
                return "ERRO";
            }
            case 1: {
                return "ATEN\u00c7\u00c3O";
            }
        }
        return "";
    }

    public void setCampo(String campo) {
        this.campo = campo;
    }

    public String getCampo() {
        return this.campo;
    }

    public Pendencia getPendencia() {
        return this.pendencia;
    }

    private ImageIcon getIconeSeveridade(byte severidade) {
        switch (severidade) {
            case 0: {
                return ConstantesGlobaisGUI.ICO_VAZIO;
            }
            case 2: {
                return ConstantesGlobaisGUI.ICO_AVISO;
            }
            case 3: {
                return ConstantesGlobaisGUI.ICO_ERRO;
            }
            case 1: {
                return ConstantesGlobaisGUI.ICO_INFORMA;
            }
        }
        return null;
    }
}

