/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import javax.swing.JOptionPane;
import serpro.ppgd.gui.xbeans.JEditNumero;
import serpro.ppgd.gui.xbeans.JNavegadorColecao;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.NavegadorColecaoEvent;
import serpro.ppgd.infraestrutura.util.NavegadorColecaoListener;
import serpro.ppgd.negocio.Observador;

public class JNavegadorIndice
extends JEditNumero
implements NavegadorColecaoListener {
    private JNavegadorColecao navegadorColecao;

    public JNavegadorIndice() {
        this.getInformacao().setConteudo("1");
        this.getInformacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                JNavegadorIndice.this.digitouValor(valorNovo);
            }
        });
    }

    private void atualizaIndice() {
        if (this.navegadorColecao != null && this.navegadorColecao.getIndiceAtual() > -1) {
            this.getInformacao().setHabilitado(true);
            this.getInformacao().setConteudo(String.valueOf(this.navegadorColecao.getIndiceAtual() + 1));
        } else {
            this.exibeColecaoVazia(null);
        }
    }

    private void digitouValor(Object valorNovo) {
        try {
            if (this.getNavegadorColecao() != null) {
                int novoValor = Integer.parseInt((String)valorNovo) - 1;
                if (novoValor < this.getNavegadorColecao().getColecao().recuperarLista().size()) {
                    this.getNavegadorColecao().exibe(novoValor);
                } else {
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "N\u00e3o h\u00e1 item n\u00b0 " + valorNovo + " na lista.", "Busca por item", 1);
                    this.getInformacao().setConteudo(this.getInformacao().getConteudoAntigo());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setNavegadorColecao(JNavegadorColecao navegadorColecao) {
        if (navegadorColecao != null) {
            navegadorColecao.removeNavegadorColecaoListener(this);
        }
        this.navegadorColecao = navegadorColecao;
        navegadorColecao.addNavegadorColecaoListener(this);
        this.atualizaIndice();
    }

    public JNavegadorColecao getNavegadorColecao() {
        return this.navegadorColecao;
    }

    public void exibeOutro(NavegadorColecaoEvent evt) {
        this.atualizaIndice();
    }

    public void exibeColecaoVazia(NavegadorColecaoEvent evt) {
        this.getInformacao().setConteudo("0");
        this.getInformacao().setHabilitado(false);
    }
}

