/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.beans.PropertyChangeSupport;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ListaPPGD;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;

public abstract class Colecao<E extends ObjetoNegocio>
extends ObjetoNegocio {
    private Class<E> tipoItens;
    private String ficha = "";
    private String aba = "";
    private String nomeCampo = null;
    private List<E> lista;
    private int tamanho = 0;
    private PropertyChangeSupport observadoresLista = new PropertyChangeSupport(this);
    private boolean observadoresListaAtivos = true;
    public static final String OBJETO_INSERIDO = "ObjetoInserido";
    public static final String OBJETO_A_REMOVER = "ObjetoAremover";
    public static final String OBJETO_REMOVIDO = "ObjetoRemovido";

    public Colecao() {
        Class<?> clazz = this.getClass();
        for (Class<?> mySuperclass = this.getClass().getSuperclass(); mySuperclass != Colecao.class; mySuperclass = mySuperclass.getSuperclass()) {
            clazz = mySuperclass;
        }
        Type genericSuperclass = clazz.getGenericSuperclass();
        Type tType = ((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
        this.tipoItens = (Class)tType;
    }

    public Colecao(String pNomeCampo) {
        this();
        this.setNomeCampo(pNomeCampo);
    }

    public Colecao(String pNomeCampo, String pNomeFicha, String pNomeAba) {
        this(pNomeCampo);
        this.setFicha(pNomeFicha);
        this.setAba(pNomeAba);
    }

    public Colecao(int tamanho) {
        this();
        this.tamanho = tamanho;
    }

    @Override
    public void clear() {
        super.clear();
        this.itens().clear();
    }

    @Override
    public void setValidadoresAtivos(boolean opcao) {
        super.setValidadoresAtivos(opcao);
        Iterator<E> itItems = this.recuperarLista().iterator();
        ObjetoNegocio obj = null;
        while (itItems.hasNext()) {
            obj = (ObjetoNegocio)itItems.next();
            obj.setValidadoresAtivos(opcao);
        }
    }

    public List<E> itens() {
        if (this.lista == null) {
            this.lista = new ListaPPGD(this);
        }
        return this.lista;
    }

    public int add(E obj) {
        int index = -1;
        if (this.itens().add(obj)) {
            index = this.itens().size() - 1;
        }
        return index;
    }

    public boolean remove(E obj) {
        return this.itens().remove(obj);
    }

    public E remove(int index) {
        return (E)((ObjetoNegocio)this.itens().remove(index));
    }

    public List<E> recuperarLista() {
        if (this.lista == null) {
            this.lista = new ListaPPGD(this);
        }
        return this.lista;
    }

    public void objetoInserido(E e) {
    }

    public void objetoARemover(Object o) {
    }

    public void objetoRemovido(Object o) {
    }

    public int novoObjeto() {
        this.recuperarLista().add(this.instanciaNovoObjeto());
        return this.recuperarLista().size() - 1;
    }

    public E instanciaNovoObjeto() {
        try {
            Type mySuperclass = this.getClass().getGenericSuperclass();
            Type tType = ((ParameterizedType)mySuperclass).getActualTypeArguments()[0];
            ObjetoNegocio e = (ObjetoNegocio)((Class)tType).newInstance();
            return (E)e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removeObjeto(int i) {
        this.recuperarLista().remove(i);
    }

    @Override
    public List<Pendencia> verificarPendencias(int numeroItem) {
        List<Pendencia> listaPendenciasColecao = super.verificarPendencias(-1);
        int i = 0;
        for (ObjetoNegocio objetoNegocio : this.recuperarLista()) {
            List<Pendencia> listaPendenciasObjeto = objetoNegocio.verificarPendencias(++i);
            listaPendenciasColecao.addAll(listaPendenciasObjeto);
        }
        return listaPendenciasColecao;
    }

    @Override
    public void setFicha(String entidade) {
        this.ficha = entidade;
        for (ObjetoNegocio objetoNegocio : this.recuperarLista()) {
            objetoNegocio.setFicha(entidade);
        }
        Iterator<Informacao> itAtributosColecao = this.recuperarListaCamposPendencia().iterator();
        Informacao info = null;
        while (itAtributosColecao.hasNext()) {
            info = itAtributosColecao.next();
            info.setFicha(entidade);
        }
    }

    public int getTamanho() {
        return this.tamanho;
    }

    public int recuperarNumeroObjetosNaoNulos() {
        Iterator<E> iterator = this.recuperarLista().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ObjetoNegocio obj = (ObjetoNegocio)iterator.next();
            if (obj.isVazio()) continue;
            ++i;
        }
        return i;
    }

    public void excluirRegistrosEmBranco() {
        List<E> list = this.recuperarLista();
        for (int i = list.size() - 1; i >= 0; --i) {
            ObjetoNegocio objetoNegocio = (ObjetoNegocio)list.get(i);
            if (!objetoNegocio.isVazio()) continue;
            list.remove(i);
        }
    }

    @Override
    public boolean isVazio() {
        for (ObjetoNegocio obj : this.recuperarLista()) {
            if (obj.isVazio()) continue;
            return false;
        }
        boolean atributosDaColecaoVazios = super.isVazio();
        return atributosDaColecaoVazios;
    }

    @Override
    public void removeObservadoresAnonimosDesnecessarios(Class<?> pClasse) {
        super.removeObservadoresAnonimosDesnecessarios(pClasse);
        Iterator<E> itItems = this.recuperarLista().iterator();
        ObjetoNegocio proximo = null;
        while (itItems.hasNext()) {
            proximo = (ObjetoNegocio)itItems.next();
            proximo.removeObservadoresAnonimosDesnecessarios(pClasse);
        }
    }

    @Override
    public void removeObservadores(Class<?>[] pClasse) {
        super.removeObservadores(pClasse);
        Iterator<E> itItems = this.recuperarLista().iterator();
        ObjetoNegocio proximo = null;
        while (itItems.hasNext()) {
            proximo = (ObjetoNegocio)itItems.next();
            proximo.removeObservadores(pClasse);
        }
    }

    public PropertyChangeSupport getObservadoresLista() {
        return this.observadoresLista;
    }

    public void addObservador(Observador observador) {
        this.observadoresLista.addPropertyChangeListener(observador);
    }

    public void addObservador(String nomePropriedade, Observador observador) {
        this.observadoresLista.addPropertyChangeListener(nomePropriedade, observador);
    }

    public void removeObservador(Observador observador) {
        this.observadoresLista.removePropertyChangeListener(observador);
    }

    public void removeObservador(String nomePropriedade, Observador observador) {
        this.observadoresLista.removePropertyChangeListener(nomePropriedade, observador);
    }

    public boolean isObservadoresListaAtivos() {
        return this.observadoresListaAtivos;
    }

    public void setObservadoresAtivos(boolean observadoresAtivos) {
        this.observadoresListaAtivos = observadoresAtivos;
    }

    public String getNomeCampo() {
        return this.nomeCampo;
    }

    public void setNomeCampo(String nomeCampo) {
        this.nomeCampo = nomeCampo;
    }

    public String getAba() {
        return this.aba;
    }

    public void setAba(String aba) {
        this.aba = aba;
    }

    @Override
    public String getFicha() {
        return this.ficha;
    }

    public Class<E> getTipoItens() {
        return this.tipoItens;
    }
}

