/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.UtilitariosString;

public class Hora
extends Informacao<Hora> {
    private SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");

    public Hora() {
        this(null, "");
    }

    public Hora(ObjetoNegocio owner, String nomeCampo) {
        super(owner, nomeCampo);
    }

    @Override
    public String getConteudoFormatado() {
        return UtilitariosString.formataHora(this.asString());
    }

    @Override
    public void setConteudo(String conteudo) {
        conteudo = UtilitariosString.retiraMascara(conteudo);
        super.setConteudo(conteudo);
    }

    @Override
    public void setConteudo(Date pData) {
        Calendar calendario = Calendar.getInstance(ConstantesGlobais.LOCALIDADE);
        calendario.setTime(pData);
        this.setConteudo(calendario);
    }

    @Override
    public void setConteudo(Calendar conteudo) {
        String hora = String.valueOf(conteudo.get(11));
        String minutos = String.valueOf(conteudo.get(12));
        String segundos = String.valueOf(conteudo.get(13));
        if (hora.length() < 2) {
            hora = "0" + hora;
        }
        if (minutos.length() < 2) {
            minutos = "0" + minutos;
        }
        if (segundos.length() < 2) {
            segundos = "0" + segundos;
        }
        String stringConteudo = hora + minutos + segundos;
        this.setConteudo(stringConteudo);
    }

    public Date asDate() {
        Date lData = null;
        try {
            lData = this.sdf.parse(this.getConteudoFormatado());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return lData;
    }

    public boolean igual(Data pData) {
        Date pDataAsDate = pData.asDate();
        if (pDataAsDate == null) {
            return false;
        }
        if (this.asDate() == null) {
            return false;
        }
        return this.asDate().equals(pDataAsDate);
    }

    public String getHora() {
        return this.asString().substring(8, 10);
    }

    public String getMinuto() {
        return this.asString().substring(10, 12);
    }

    public String getSegundo() {
        return this.asString().substring(12, 14);
    }

    @Override
    public int compareTo(Data outraData) {
        if (this.asDate() == null || outraData == null || outraData.asDate() == null) {
            return -1;
        }
        return this.asDate().compareTo(outraData.asDate());
    }

    public static void main(String[] args) {
        Calendar calendar = Calendar.getInstance(ConstantesGlobais.LOCALIDADE);
        calendar.set(11, 15);
        calendar.set(12, 32);
        calendar.set(13, 40);
        Hora lData = new Hora(null, "Teste");
        lData.setConteudo(calendar);
        lData.setConteudo(calendar.getTime());
        lData.setConteudo("15:32:40");
    }

    @Override
    public void setConteudo(Hora pValor) {
        this.setConteudo(pValor.naoFormatado());
    }

    @Override
    public String formatado() {
        return UtilitariosString.formataHora(this.naoFormatado());
    }
}

