/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.List;
import java.util.ListIterator;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

class ListIteratorColecaoPPGD<E extends ObjetoNegocio>
implements ListIterator<E> {
    private ListIterator<E> implementacao;
    private Colecao<E> owner;
    private List<E> lista;
    private E objetoCorrente;

    private void verificaTamanho(int index) {
        if (this.owner.getTamanho() != 0 && index == this.owner.getTamanho()) {
            throw new IllegalArgumentException("A cole\u00e7\u00e3o ultrapassou o tamanho limite.");
        }
    }

    public ListIteratorColecaoPPGD(ListIterator<E> implementacao, Colecao<E> owner, List<E> lista) {
        this.implementacao = implementacao;
        this.owner = owner;
        this.lista = lista;
    }

    @Override
    public void add(E e) {
        this.verificaTamanho(this.lista.size());
        this.implementacao.add(e);
        this.owner.objetoInserido(e);
    }

    @Override
    public boolean hasNext() {
        return this.implementacao.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.implementacao.hasPrevious();
    }

    @Override
    public E next() {
        this.objetoCorrente = (ObjetoNegocio)this.implementacao.next();
        return this.objetoCorrente;
    }

    @Override
    public int nextIndex() {
        return this.implementacao.nextIndex();
    }

    @Override
    public E previous() {
        this.objetoCorrente = (ObjetoNegocio)this.implementacao.previous();
        return this.objetoCorrente;
    }

    @Override
    public int previousIndex() {
        return this.implementacao.previousIndex();
    }

    @Override
    public void remove() {
        this.owner.objetoARemover(this.objetoCorrente);
        this.implementacao.remove();
        this.owner.objetoRemovido(this.objetoCorrente);
    }

    @Override
    public void set(E e) {
        this.owner.objetoARemover(this.objetoCorrente);
        this.implementacao.set(e);
        this.owner.objetoRemovido(this.objetoCorrente);
        this.owner.objetoInserido(e);
    }
}

