/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.util;

import java.util.Properties;
import serpro.ppgd.negocio.exception.MensagemNaoEncontradaException;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class TabelaMensagens {
    private Properties arquivoMensagens = null;
    private static TabelaMensagens tabelaMensagens = null;

    public static TabelaMensagens getTabelaMensagens() {
        String arquivo = FabricaUtilitarios.getProperties().getProperty("arquivoMsgErro", "MsgErro.txt");
        if (tabelaMensagens == null) {
            tabelaMensagens = new TabelaMensagens(arquivo);
        }
        return tabelaMensagens;
    }

    private TabelaMensagens() {
    }

    private TabelaMensagens(String pPathRelativoParaArquivoMensagens) {
        this.arquivoMensagens = UtilitariosArquivo.loadProperties("/" + pPathRelativoParaArquivoMensagens, this.getClass());
    }

    public String msg(String pChave) throws MensagemNaoEncontradaException {
        if (!this.arquivoMensagens.containsKey(pChave)) {
            LogPPGD.erro("Mensagem " + pChave + " n\u00e3o est\u00e1 cadastrada no Mensagens.properties!");
            throw new MensagemNaoEncontradaException("C\u00f3digo " + pChave + " de Mensagem n\u00e3o encontrado");
        }
        return this.arquivoMensagens.getProperty(pChave, "");
    }

    public String msg(String pChave, String[] pParams) throws MensagemNaoEncontradaException {
        String retorno = null;
        retorno = this.msg(pChave);
        if (pParams != null) {
            for (int i = 0; i < pParams.length; ++i) {
                retorno = retorno.replaceAll("(@" + (i + 1) + ")", pParams[i]);
            }
        }
        return retorno;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

