/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.txt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import serpro.hash.Crc32;
import serpro.ppgd.formatosexternos.txt.CampoReg;
import serpro.ppgd.formatosexternos.txt.CampoTXT;
import serpro.ppgd.formatosexternos.txt.MapeamentoTXT;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.util.PLong;

public class RegistroTxt {
    protected boolean fOpcional = false;
    protected List<CampoReg> objListaCampos = new ArrayList<CampoReg>();
    protected String fTipo;
    protected String tipoArquivo;
    protected int fPosicaoAtual = 0;
    protected boolean participaImportacao = true;
    protected boolean participaGravacao = true;

    public RegistroTxt() {
    }

    public RegistroTxt(String tipoArq, String tipoReg) throws GeracaoTxtException {
        this();
        this.tipoArquivo = tipoArq;
        this.fTipo = tipoReg;
        this.inicializaLista(tipoArq, MapeamentoTXT.getInstance().getRelacaoCamposRegistro(tipoArq, tipoReg));
    }

    public RegistroTxt(String tipoArq, String tipoReg, boolean opcional) throws GeracaoTxtException {
        this(tipoArq, tipoReg);
        this.fOpcional = opcional;
    }

    protected void inicializaLista(String tipo, NodeList node) throws GeracaoTxtException {
        this.setParticipaGravacao(MapeamentoTXT.getInstance().participaGravacao(this.tipoArquivo, this.getTipo()));
        this.setParticipaImportacao(MapeamentoTXT.getInstance().participaImportacao(this.tipoArquivo, this.getTipo()));
        if (node != null) {
            for (int i = 0; i < node.getLength(); ++i) {
                Node nodeAtual = node.item(i);
                if (!(nodeAtual instanceof Element) || !nodeAtual.getNodeName().equals("Campo")) continue;
                Element nodeFilho = (Element)node.item(i);
                String decimais = nodeFilho.getAttribute("Decimais");
                String casasDecimais = nodeFilho.getAttribute("CasasDecimais");
                if (casasDecimais.trim().length() > 0) {
                    decimais = casasDecimais;
                }
                this.adicionaCampo(nodeFilho.getAttribute("Nome"), nodeFilho.getAttribute("Tipo"), nodeFilho.getAttribute("Tamanho"), decimais, nodeFilho.getAttribute("atributoObjetoNegocio"), nodeFilho.getAttribute("Conteudo"), nodeFilho.getAttribute("ParticipaImportacao"), nodeFilho.getAttribute("ParticipaGravacao"));
            }
        }
    }

    protected void adicionaCampo(String nome, String tipoSize) throws GeracaoTxtException {
        CampoReg campoReg = new CampoReg(nome, tipoSize);
        this.objListaCampos.add(campoReg);
        campoReg.setPosicaoInicial(this.fPosicaoAtual);
        this.fPosicaoAtual += campoReg.getCampoTXT().getTamanho();
    }

    protected void adicionaCampo(String nome, String tipo, String size) throws GeracaoTxtException {
        CampoReg campoReg = new CampoReg(nome, tipo.concat(size));
        this.objListaCampos.add(campoReg);
        campoReg.setPosicaoInicial(this.fPosicaoAtual);
        this.fPosicaoAtual += campoReg.getCampoTXT().getTamanho();
    }

    protected void adicionaCampo(String nome, String tipo, String size, String decimais, String pAtributoObjetoNegocio, String pConteudoEstatico, String pParticipaImportacao, String pParticipaGravacao) throws GeracaoTxtException {
        CampoReg campoReg = decimais.equals("") ? new CampoReg(nome, tipo.concat(size)) : new CampoReg(nome, tipo.concat(size).concat(",").concat(decimais));
        if (pAtributoObjetoNegocio != null && pAtributoObjetoNegocio.trim().length() != 0) {
            campoReg.setAtributoObjetoNegocio(pAtributoObjetoNegocio);
        }
        if (pConteudoEstatico != null && pConteudoEstatico.trim().length() != 0) {
            campoReg.setConteudoEstatico(pConteudoEstatico);
        }
        if (pParticipaImportacao != null && pParticipaImportacao.trim().equals("false")) {
            campoReg.setParticipaImportacao(false);
        }
        if (pParticipaGravacao != null && pParticipaGravacao.trim().equals("false")) {
            campoReg.setParticipaGravacao(false);
        }
        this.objListaCampos.add(campoReg);
        campoReg.setPosicaoInicial(this.fPosicaoAtual);
        this.fPosicaoAtual += campoReg.getCampoTXT().getTamanho();
    }

    public int getTamanho() {
        int tamanho = 0;
        Enumeration<CampoReg> enumTemp = Collections.enumeration(this.objListaCampos);
        while (enumTemp.hasMoreElements()) {
            tamanho += enumTemp.nextElement().getCampoTXT().getTamanho();
        }
        return tamanho;
    }

    public String getLinha() throws GeracaoTxtException {
        StringBuilder linha = new StringBuilder("");
        Enumeration<CampoReg> enumTemp = Collections.enumeration(this.objListaCampos);
        while (enumTemp.hasMoreElements()) {
            linha.append(enumTemp.nextElement().getCampoTXT().asTxt());
        }
        return linha.toString();
    }

    public void setLinha(String linha) throws GeracaoTxtException {
        if (linha.length() != this.getTamanho()) {
            LogPPGD.debug((String)("tamanho limite->" + this.getTamanho()));
            LogPPGD.debug((String)("Linha->" + linha));
            LogPPGD.debug((String)("tamanho linha->" + linha.length()));
            throw new GeracaoTxtException("Tamanho da linha diferente ( Registro ) " + this.getTipo() + ".");
        }
        Enumeration<CampoReg> enumTemp = Collections.enumeration(this.objListaCampos);
        while (enumTemp.hasMoreElements()) {
            CampoReg campoReg = enumTemp.nextElement();
            int inicio = campoReg.getPosicaoInicial();
            int fim = campoReg.getPosicaoFinal();
            campoReg.getCampoTXT().set(linha.substring(inicio, inicio + (fim - inicio) + 1));
        }
    }

    public String getTipo() {
        return this.fTipo;
    }

    public boolean estaPreenchido() throws NumberFormatException, GeracaoTxtException {
        boolean preenchido = true;
        Enumeration<CampoReg> enumTemp = Collections.enumeration(this.objListaCampos);
        while (enumTemp.hasMoreElements()) {
            if (!enumTemp.nextElement().getCampoTXT().estaPreenchido()) continue;
            return true;
        }
        return false;
    }

    public boolean opcional() {
        return this.fOpcional;
    }

    public CampoTXT fieldByName(String nomeCampo) throws GeracaoTxtException {
        CampoReg campoReg = null;
        Enumeration<CampoReg> enumTemp = Collections.enumeration(this.objListaCampos);
        while (enumTemp.hasMoreElements()) {
            campoReg = enumTemp.nextElement();
            if (!campoReg.getCampoTXT().getNome().equalsIgnoreCase(nomeCampo)) continue;
            return campoReg.getCampoTXT();
        }
        if (campoReg == null) {
            throw new GeracaoTxtException("Campo n\u00e3o encontrado: " + nomeCampo + " no Registro tipo " + this.fTipo + ".");
        }
        return null;
    }

    public List<CampoTXT> getAllCampoTxt() {
        ArrayList<CampoTXT> listCampos = new ArrayList<CampoTXT>();
        Enumeration<CampoReg> enumTemp = Collections.enumeration(this.objListaCampos);
        while (enumTemp.hasMoreElements()) {
            CampoReg campoReg = enumTemp.nextElement();
            listCampos.add(campoReg.getCampoTXT());
        }
        return listCampos;
    }

    public void calculaCRCRegistro() throws GeracaoTxtException {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        StringBuilder linha = new StringBuilder("");
        linha.append(UtilitariosString.retiraCaracteresEspeciais((String)this.getLinha().substring(0, this.getLinha().length() - 10)));
        long hash = crc32.CalcCrc32(linha.toString(), linha.toString().length(), pLong);
        this.fieldByName("NR_CONTROLE").set(crc32.getStrCrc32());
    }

    public String calculaCRCHeader(String filename) throws GeracaoTxtException {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        StringBuilder linha = new StringBuilder(filename);
        linha.append(UtilitariosString.retiraCaracteresEspeciais((String)this.getLinha().substring(0, this.getLinha().length() - 10)));
        long hash = crc32.CalcCrc32(linha.toString(), linha.length(), pLong);
        return crc32.getStrCrc32();
    }

    public void validar() throws GeracaoTxtException {
        String hashLido = this.fieldByName("NR_CONTROLE").asString();
        this.calculaCRCRegistro();
        if (!hashLido.equals(this.fieldByName("NR_CONTROLE").asString())) {
            throw new GeracaoTxtException("N\u00famero de controle inv\u00e1lido no registro " + this.getTipo());
        }
    }

    public static void main(String[] args) {
    }

    public boolean isParticipaGravacao() {
        return this.participaGravacao;
    }

    public void setParticipaGravacao(boolean participaGravacao) {
        this.participaGravacao = participaGravacao;
    }

    public boolean isParticipaImportacao() {
        return this.participaImportacao;
    }

    public void setParticipaImportacao(boolean participaImportacao) {
        this.participaImportacao = participaImportacao;
    }
}

