/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans.autocomplete;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteComboBox;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteComboModel;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;

public class JAutoCompleteEditNI
extends JEditCampo
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JAutoCompleteComboBox combo;

    public JAutoCompleteEditNI() {
        super((Informacao<?>)new NI());
        this.inicio();
    }

    public JAutoCompleteEditNI(Informacao<?> aCampo) {
        super(aCampo);
        this.inicio();
    }

    public JAutoCompleteEditNI(Informacao<?> aCampo, String idAjuda) {
        super(aCampo, idAjuda);
        this.inicio();
    }

    @Override
    public int getBaseline(int width, int height) {
        JComboBox editor = (JComboBox)this.getComponenteEditor();
        if (editor != null) {
            return editor.getBaseline(width, height);
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        JComboBox editor = (JComboBox)this.getComponenteEditor();
        if (editor != null) {
            return editor.getBaselineResizeBehavior();
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    private void inicio() {
        this.combo.addActionListener(this);
        this.combo.getTextComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() == null || !JAutoCompleteEditNI.this.isFocusLostAtivo()) {
                    return;
                }
                if (!JAutoCompleteEditNI.this.combo.getTextComponent().getText().isEmpty() && JAutoCompleteEditNI.this.combo.getSelectedIndex() == -1) {
                    if (JAutoCompleteEditNI.this.combo.getItemCount() == 1) {
                        JAutoCompleteEditNI.this.combo.setSelectedIndex(0);
                    } else {
                        JAutoCompleteEditNI.this.combo.getTextComponent().setText("");
                        JAutoCompleteEditNI.this.campo.setConteudo("");
                        JAutoCompleteEditNI.this.combo.setPopupVisible(false);
                    }
                }
                if (!JAutoCompleteEditNI.this.getInformacao().getListaValidadoresImpeditivos().isEmpty()) {
                    ElementoTabela elemento = (ElementoTabela)JAutoCompleteEditNI.this.combo.getModel().getSelectedItem();
                    if (!JAutoCompleteEditNI.this.verificaValidacoesImpeditivas(elemento)) {
                        return;
                    }
                    JAutoCompleteEditNI.this.setaCampo();
                }
                JAutoCompleteEditNI.this.chamaValidacao();
                JAutoCompleteEditNI.this.combo.getTextComponent().setCaretPosition(0);
            }
        });
        this.getInformacao().getObservadores().addPropertyChangeListener("ComboReiniciado", this);
    }

    public void setaCampo() {
        ElementoTabela elem = (ElementoTabela)this.combo.getSelectedItem();
        if (elem != null) {
            this.campo.setConteudo(elem.getConteudo(0));
            this.combo.getTextComponent().setCaretPosition(0);
        } else if (this.combo.getTextComponent().getText().isEmpty()) {
            this.campo.setConteudo("");
        } else {
            this.campo.setConteudo("-1");
        }
    }

    @Override
    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.combo == null) {
            this.combo = new JAutoCompleteComboBox();
        }
        this.add((Component)this.combo, "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }

    @Override
    public JComponent getComponenteEditor() {
        return this.combo;
    }

    @Override
    public JComponent getComponenteFoco() {
        return this.combo;
    }

    @Override
    protected void habilitadoPropertyChange(boolean habilitado) {
        this.combo.setEnabled(habilitado);
    }

    @Override
    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() != null && evt.getPropertyName().equals("ComboReiniciado")) {
            this.informacaoModificada();
        }
    }

    @Override
    protected void informacaoModificada() {
        this.combo.setSelectedItemPorCodigo(((NI)this.campo).formatado());
    }

    public void setDados(List<ElementoTabela> pDados) {
        if (pDados != null) {
            this.combo.setModel((ComboBoxModel)new JAutoCompleteComboModel(pDados));
            if (!pDados.isEmpty()) {
                NI lValorAtual = (NI)this.campo;
                if (!lValorAtual.isVazio()) {
                    this.informacaoModificada();
                } else {
                    this.combo.setSelectedIndex(-1);
                }
            }
        }
    }

    @Override
    protected void readOnlyPropertyChange(boolean readOnly) {
        this.combo.setEnabled(!readOnly);
    }

    @Override
    public void setEstiloFonte(int estilo) {
        Font f = this.combo.getFont();
        f = f.deriveFont(estilo);
        this.combo.setFont(f);
    }

    @Override
    public void setIncrementoTamanhoFonte(int incremento) {
        this.incrementoTamanhoFonte = incremento;
        Font f = this.combo.getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = f.getSize2D();
        }
        f = f.deriveFont(this.tamanhoOriginal + (float)incremento);
        this.combo.setFont(f);
    }

    @Override
    public int getIncrementoTamanhoFonte() {
        return this.incrementoTamanhoFonte;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.getInformacao().getListaValidadoresImpeditivos().isEmpty()) {
            return;
        }
        this.setaCampo();
    }

    @Override
    public void conteudoPropertyChange(PropertyChangeEvent arg0) {
    }
}

