/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.crypto;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.infra.IFiltro;

public class FiltroICP
implements IFiltro {
    private static List<String> oidsPessoaFisica = Arrays.asList("2.16.76.1.3.1", "2.16.76.1.3.5");
    private static List<String> oidsPessoaJuridica = Arrays.asList("2.16.76.1.3.2", "2.16.76.1.3.3", "2.16.76.1.3.4");
    private static FiltroICP _instancia = new FiltroICP();

    private FiltroICP() {
    }

    public static FiltroICP singleton() {
        return _instancia;
    }

    @Override
    public boolean isCertificadoValido(X509CertificadoWrapper certificado) {
        List<String> oids;
        try {
            oids = certificado.getOIDsSubjectAlternativeName();
        }
        catch (IOException e) {
            return false;
        }
        return oids.containsAll(oidsPessoaFisica) || oids.containsAll(oidsPessoaJuridica);
    }
}

