/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.crypto;

import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JFrame;
import jsignnet.aplicacao.ControleProgresso;
import jsignnet.aplicacao.FileInputStreamParcial;
import jsignnet.aplicacao.Hash;
import jsignnet.aplicacao.JSignNet;
import jsignnet.crypto.TipoKeyStore;
import jsignnet.crypto.X509CertificadoUtil;
import jsignnet.erro.CertificadoNaoFoiLido;
import jsignnet.erro.ErroAoGerarPKCS7;
import jsignnet.erro.ErroDeES;
import jsignnet.erro.JSignExcecaoCadeiaVazia;
import jsignnet.erro.JSignExcecaoCancelamento;
import jsignnet.erro.JSignExcecaoFatal;
import jsignnet.erro.JSignException;
import jsignnet.gui.DialogoSenha;
import jsignnet.infra.CMSProcessablePartialFile;
import jsignnet.infra.Recursos;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedGenerator;

public class X509CertificadoWrapper {
    private static final String PREFIXO_ERRO_ASSINATURA = "Erro ao assinar digitalmente. ";
    private KeyStore keystore;
    private X509Certificate[] cadeiaCertificadosX509;
    private String alias;
    private char[] senhaContainer;
    private boolean _fAddDefaultAttributes = false;
    private char[] _ultimaSenhaFornecida = null;
    private boolean _reutilizarSenha = false;
    private static final Map<Class<?>, Object> MENSAGENS_ERRO_ASSINATURA = new HashMap();

    public X509CertificadoWrapper(String alias, KeyStore ks, char[] senha) throws KeyStoreException, CertificateException, JSignExcecaoCadeiaVazia {
        this.alias = alias;
        this.keystore = ks;
        if (senha != null) {
            this.setSenhaContainer(senha);
        }
        this.populaCertificados();
    }

    public X509CertificadoWrapper(X509Certificate certificate) {
        this.cadeiaCertificadosX509 = new X509Certificate[1];
        this.cadeiaCertificadosX509[0] = certificate;
    }

    protected X509CertificadoWrapper(X509CertificadoWrapper outro) {
        this.alias = outro.alias;
        this.keystore = outro.keystore;
        if (outro.senhaContainer != null) {
            this.senhaContainer = (char[])outro.senhaContainer.clone();
        }
        if (outro.cadeiaCertificadosX509 != null) {
            this.cadeiaCertificadosX509 = (X509Certificate[])outro.cadeiaCertificadosX509.clone();
        }
        this._fAddDefaultAttributes = outro._fAddDefaultAttributes;
    }

    public void setAdicionarAtributosAssinatura(boolean f) {
        this._fAddDefaultAttributes = f;
    }

    public String getEmitidoPara() {
        return this.extraiPrimeiraEntrada("CN", this.getCertificado().getSubjectDN().toString());
    }

    public String getEmitidoPor() {
        return this.extraiPrimeiraEntrada("CN", this.getCertificado().getIssuerDN().toString());
    }

    public String getOrganizacaoEmissora() {
        return this.extraiPrimeiraEntrada("O", this.getCertificado().getIssuerDN().toString());
    }

    public String getUnidadeOrganizacionalEmissora() {
        return this.extraiPrimeiraEntrada("OU", this.getCertificado().getIssuerDN().toString());
    }

    public Date getDataEmissao() {
        return this.getCertificado().getNotBefore();
    }

    public Date getDataVencimento() {
        return this.getCertificado().getNotAfter();
    }

    private String extraiPrimeiraEntrada(String campo, String valor) {
        StringTokenizer token = new StringTokenizer(valor, ",");
        while (token.hasMoreElements()) {
            String item = token.nextToken();
            if (item.indexOf(campo + "=") <= -1) continue;
            return item.substring(item.indexOf("=") + 1);
        }
        return "";
    }

    public KeyStore getKeystore() {
        return this.keystore;
    }

    public String getAlias() {
        return this.alias;
    }

    protected X509Certificate getCertificado() {
        return this.cadeiaCertificadosX509[0];
    }

    public X509Certificate[] getCadeiaCertificados() {
        return this.cadeiaCertificadosX509;
    }

    public X509CertificadoWrapper[] getCadeiaCertificadosWrapper() {
        X509CertificadoWrapper[] cadeiaWrapper = new X509CertificadoWrapper[this.cadeiaCertificadosX509.length];
        for (int i = 0; i < this.cadeiaCertificadosX509.length; ++i) {
            cadeiaWrapper[i] = new X509CertificadoWrapper(this.cadeiaCertificadosX509[i]);
        }
        return cadeiaWrapper;
    }

    private void populaCertificados() throws KeyStoreException, CertificateException, JSignExcecaoCadeiaVazia {
        if (this.getKeystore().isKeyEntry(this.getAlias())) {
            this.cadeiaCertificadosX509 = X509CertificadoUtil.converteCertificados(this.getKeystore().getCertificateChain(this.getAlias()));
            if (this.cadeiaCertificadosX509.length <= 0) {
                throw new JSignExcecaoCadeiaVazia("N\u00e3o foi poss\u00edvel recuperar a cadeia do certificado " + this.getAlias() + '.');
            }
        } else {
            this.cadeiaCertificadosX509 = new X509Certificate[1];
            this.cadeiaCertificadosX509[0] = X509CertificadoUtil.converteCertificado(this.getKeystore().getCertificate(this.getAlias()));
        }
    }

    public String getOrganizacao() {
        return this.extraiPrimeiraEntrada("O", this.getCertificado().getIssuerDN().toString());
    }

    public String getUnidadeOrganizacional() {
        return this.extraiPrimeiraEntrada("OU", this.getCertificado().getIssuerDN().toString());
    }

    public String getSerie() {
        return this.getCertificado().getSerialNumber().toString();
    }

    public String getNumeroSerieHexa() {
        BigInteger serial = this.getCertificado().getSerialNumber();
        byte[] rbSerial = serial.toByteArray();
        StringBuffer sb = new StringBuffer();
        for (int ib = 0; ib < rbSerial.length; ++ib) {
            String byteHexa;
            int b = rbSerial[ib];
            if (b < 0) {
                b += 256;
            }
            if ((byteHexa = Integer.toHexString(b)).length() == 1) {
                sb.append('0');
            }
            sb.append(byteHexa);
        }
        return sb.toString();
    }

    public String getVersao() {
        return "Vers\u00e3o " + String.valueOf(this.getCertificado().getVersion());
    }

    public String getAlgoritmo() {
        return this.getCertificado().getSigAlgName();
    }

    public String getAssuntoPrincipal() {
        return this.getCertificado().getSubjectDN().getName();
    }

    public byte[] getEncoded() throws CertificadoNaoFoiLido {
        byte[] resposta = null;
        try {
            resposta = this.getCertificado().getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new CertificadoNaoFoiLido(e);
        }
        return resposta;
    }

    public String getSHA1FingerPrint() throws CertificadoNaoFoiLido {
        byte[] fingerprint;
        try {
            fingerprint = Hash.SHA1.geraDigest(new ByteArrayInputStream(this.getEncoded()), null);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new JSignExcecaoFatal("SHA1 n\u00e3o dispon\u00edvel.", e);
        }
        catch (IOException e) {
            JSignNet.logger.log(Level.SEVERE, "Falha ao ler a mem\u00f3ria", e);
            throw new JSignExcecaoFatal("Falha ao ler a mem\u00f3ria", e);
        }
        return X509CertificadoWrapper.formatarFingerPrint(fingerprint);
    }

    private static String formatarFingerPrint(byte[] bFingerPrint) {
        Formatter formatter = new Formatter();
        for (int i = 0; i < bFingerPrint.length - 1; ++i) {
            formatter.format("%02x:", bFingerPrint[i]);
        }
        formatter.format("%02x", bFingerPrint[bFingerPrint.length - 1]);
        String retorno = formatter.toString().toUpperCase();
        formatter.close();
        return retorno;
    }

    public String getMD5FingerPrint() throws CertificadoNaoFoiLido {
        byte[] fingerprint;
        try {
            fingerprint = Hash.MD5.geraDigest(new ByteArrayInputStream(this.getEncoded()), null);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new JSignExcecaoFatal("MD5 n\u00e3o dispon\u00edvel.", e);
        }
        catch (IOException e) {
            JSignNet.logger.log(Level.SEVERE, "Falha ao ler a mem\u00f3ria", e);
            throw new JSignExcecaoFatal("Falha ao ler a mem\u00f3ria", e);
        }
        return X509CertificadoWrapper.formatarFingerPrint(fingerprint);
    }

    public PrivateKey getChavePrivada(char[] pin) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        PrivateKey chave = (PrivateKey)this.getKeystore().getKey(this.getAlias(), pin);
        if (chave == null && (pin == null || Arrays.equals(new char[0], pin)) && this.getProvider().getName().equals("Apple")) {
            chave = (PrivateKey)this.getKeystore().getKey(this.getAlias(), new char[]{'.'});
        }
        return chave;
    }

    public PublicKey getChavePublica() {
        return this.getCertificado().getPublicKey();
    }

    public String getAlgoritmoChavePublica() {
        return this.getChavePublica().getAlgorithm();
    }

    public String getNomesAlternativos() throws IOException {
        return X509CertificadoUtil.getNomesAlternativosSujeito(this.getCertificado());
    }

    public List<X509Certificate> listaCadeiaCertificados() {
        return this.listaCadeiaCertificados(true);
    }

    public String getIdentificadorChaveAutoridade() throws IOException {
        return X509CertificadoUtil.getIdentificadorChaveAutoridade(this.getCertificado());
    }

    public List<X509Certificate> listaCadeiaCertificados(boolean flagAnexaTodaCadeia) {
        ArrayList<X509Certificate> lista = new ArrayList<X509Certificate>();
        if (flagAnexaTodaCadeia) {
            X509Certificate[] cadeiaCertificados = this.getCadeiaCertificados();
            for (int i = 0; i < cadeiaCertificados.length; ++i) {
                lista.add(cadeiaCertificados[i]);
            }
        } else {
            lista.add(this.getCertificado());
        }
        return lista;
    }

    public byte[] assinaPKCS7(Hash algoritmo, byte[] dados, char[] pin, boolean flagCadeiaCertificados, boolean flagAnexaMensagemOriginal) throws ErroAoGerarPKCS7 {
        return this.assinarDigitalmente(algoritmo, pin, flagCadeiaCertificados, flagAnexaMensagemOriginal, new CMSProcessableByteArray(dados), this._fAddDefaultAttributes, null, null);
    }

    public byte[] assinarDigitalmente(Hash algoritmo, char[] pin, boolean flagCadeiaCertificados, boolean flagAnexaMensagemOriginal, CMSProcessable dados, boolean fAdicionarAtributosPadroes, AttributeTable atributosAutenticados, AttributeTable atributosNaoAutenticados) throws ErroAoGerarPKCS7 {
        algoritmo = this.definirHashSeNecessario(algoritmo);
        if (this.eAlgoritmoCurvaEliptica() && algoritmo == Hash.MD5) {
            throw new IllegalArgumentException("Um certificado digital baseado em criptografia de curvas el\u00edpticas n\u00e3o pode usar MD5 como algoritmo de hashing. Apenas a fam\u00edlia SHA pode ser usada.");
        }
        try {
            if (!this.getKeystore().isKeyEntry(this.getAlias())) {
                return null;
            }
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            gen.addSigner(this.getChavePrivada(pin), this.getCertificado(), algoritmo.getDigestOID(), atributosAutenticados, atributosNaoAutenticados);
            CertStore certs = CertStore.getInstance("Collection", new CollectionCertStoreParameters(this.listaCadeiaCertificados(flagCadeiaCertificados)));
            gen.addCertificatesAndCRLs(certs);
            CMSSignedData data = gen.generate(CMSSignedDataGenerator.DATA, dados, flagAnexaMensagemOriginal, this.getNomeProvider(), fAdicionarAtributosPadroes);
            return data.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw X509CertificadoWrapper.encapsularExcecaoAssinatura(e);
        }
        catch (CMSException e) {
            throw X509CertificadoWrapper.encapsularExcecaoAssinatura(e);
        }
        catch (IOException e) {
            throw X509CertificadoWrapper.encapsularExcecaoAssinatura(e);
        }
    }

    private Hash definirHashSeNecessario(Hash hash) {
        if (hash.equals(Hash.MESMO_DO_CERTIFICADO)) {
            return this.getHash();
        }
        return hash;
    }

    private Hash getHash() {
        String nomeAlgoritmoHashing;
        Hash hash;
        Pattern padrao;
        Matcher matcher;
        String nomeAlgoritmoAssinatura = this.getCertificado().getSigAlgName();
        if (nomeAlgoritmoAssinatura != null && (matcher = (padrao = Pattern.compile("(\\w+)with\\w+", 2)).matcher(nomeAlgoritmoAssinatura)).matches() && (hash = Hash.getHashDeNome(nomeAlgoritmoHashing = matcher.group(1).toUpperCase())) != null) {
            return hash;
        }
        return Hash.SHA1;
    }

    public boolean eAlgoritmoCurvaEliptica() {
        int comprimentoIdentificadorHashingSHA1 = 2;
        int tamanhoParteQueDefineSomenteAlgoritmoDeAssinatura = CMSSignedGenerator.ENCRYPTION_ECDSA.length() - comprimentoIdentificadorHashingSHA1;
        String prefixo = CMSSignedGenerator.ENCRYPTION_ECDSA.substring(0, tamanhoParteQueDefineSomenteAlgoritmoDeAssinatura);
        return this.getCertificado().getSigAlgOID().startsWith(prefixo);
    }

    private static ErroAoGerarPKCS7 encapsularExcecaoAssinatura(Exception e) {
        String msg = (String)MENSAGENS_ERRO_ASSINATURA.get(e.getClass());
        if (msg == null) {
            msg = Recursos.getString("Excecao.erroAoGerarPKCS7");
        }
        return new ErroAoGerarPKCS7(e, msg);
    }

    public byte[] assinaPKCS7(Hash algoritmo, File arquivo, long tamanhoArquivo, char[] pin, boolean flagCadeiaCertificados, boolean flagAnexaMensagemOriginal) throws ErroAoGerarPKCS7 {
        return this.assinarDigitalmente(algoritmo, pin, flagCadeiaCertificados, flagAnexaMensagemOriginal, new CMSProcessablePartialFile(arquivo, tamanhoArquivo), this._fAddDefaultAttributes, null, null);
    }

    public Provider getProvider() {
        if (this.getKeystore() == null) {
            return null;
        }
        return this.getKeystore().getProvider();
    }

    public String getNomeProvider() {
        String resposta = "";
        if (this.getProvider() == null) {
            return resposta;
        }
        resposta = this.getProvider().getName();
        if (resposta.equals("SUN") || resposta.equals("Apple")) {
            resposta = "BC";
        }
        return resposta;
    }

    public String getNomeKeystore() {
        if (this.getKeystore() == null) {
            return "";
        }
        if (this.getKeystore().getType().equals(TipoKeyStore.SUNMSCAPI.toString())) {
            return "Internet Explorer";
        }
        if (this.getKeystore().getType().equals(TipoKeyStore.PKCS11.toString())) {
            String nomeProvider = this.getKeystore().getProvider().getName();
            if (nomeProvider.startsWith("SunPKCS11-")) {
                return nomeProvider.substring(10);
            }
        } else if (this.getKeystore().getType().equals(TipoKeyStore.PKCS12.toString())) {
            return "Arquivo PKCS12";
        }
        return TipoKeyStore.formataTexto(this.getKeystore().getType());
    }

    public char[] getSenhaContainer() {
        return this.senhaContainer;
    }

    protected void setSenhaContainer(char[] senha) {
        this.senhaContainer = senha;
    }

    public boolean hasPrivateKey(String alias) throws KeyStoreException {
        boolean resposta = false;
        if (this.getKeystore() != null) {
            resposta = this.getKeystore().isKeyEntry(alias);
        }
        return resposta;
    }

    public String getPontoDistribuicaoCRL() {
        String resposta = null;
        byte[] valorCampo = this.getCertificado().getExtensionValue("2.5.29.31");
        if (valorCampo != null) {
            resposta = new String(valorCampo, 12, valorCampo.length - 12);
        }
        return resposta;
    }

    public String getUsoChave() throws ErroDeES {
        try {
            return X509CertificadoUtil.getUsoChave(this.getCertificado());
        }
        catch (IOException e) {
            throw new ErroDeES(e);
        }
    }

    public String getUsoAvancadoChave() throws IOException {
        return X509CertificadoUtil.getUsoExtendidoChave(this.getCertificado());
    }

    public String getTipoKeyStore() {
        if (this.getKeystore() == null) {
            return "";
        }
        return this.getKeystore().getType();
    }

    public String getValorExtensao(String oid) throws JSignException {
        try {
            return X509CertificadoUtil.getNomesAlternativosSujeito(this.getCertificado(), oid);
        }
        catch (IOException e) {
            throw new JSignException(e, "Erro buscando extens\u00e3o " + oid + " do certificado.");
        }
    }

    public List<String> getOIDsSubjectAlternativeName() throws IOException {
        String SUBJECT_ALTERNATIVE_NAME_OID = "2.5.29.17";
        ArrayList<String> resposta = new ArrayList<String>();
        byte[] extensao = this.getCertificado().getExtensionValue("2.5.29.17");
        if (extensao != null) {
            byte[] octetos = ((DEROctetString)X509CertificadoUtil.toDER(extensao)).getOctets();
            ASN1Sequence nomes = (ASN1Sequence)X509CertificadoUtil.toDER(octetos);
            int len = nomes.size();
            for (int i = 0; i < len; ++i) {
                DERTaggedObject objeto = (DERTaggedObject)nomes.getObjectAt(i);
                if (objeto.getTagNo() != 0) continue;
                ASN1Sequence objetoCodificadoASN1 = (ASN1Sequence)objeto.getObject();
                String sOid = ((DERObjectIdentifier)objetoCodificadoASN1.getObjectAt(0)).getId();
                resposta.add(sOid);
            }
        }
        return resposta;
    }

    public List<String> getOIDsPoliticasCertificados() throws IOException {
        String CERTIFICATE_POLICIES_OID = "2.5.29.32";
        byte[] extensao = this.getCertificado().getExtensionValue("2.5.29.32");
        if (extensao == null) {
            return null;
        }
        byte[] octetos = ((DEROctetString)X509CertificadoUtil.toDER(extensao)).getOctets();
        ASN1Sequence nomes = (ASN1Sequence)X509CertificadoUtil.toDER(octetos);
        ArrayList<String> resposta = new ArrayList<String>();
        int len = nomes.size();
        for (int i = 0; i < len; ++i) {
            ASN1Sequence seq = (ASN1Sequence)nomes.getObjectAt(i);
            int n = seq.size();
            for (int j = 0; j < n; ++j) {
                if (!DERObjectIdentifier.class.isInstance(seq.getObjectAt(j))) continue;
                DERObjectIdentifier oid = (DERObjectIdentifier)seq.getObjectAt(j);
                resposta.add(oid.getId());
            }
        }
        return resposta;
    }

    public String toString() {
        StringBuffer saida = new StringBuffer();
        saida.append(this.getClass().getName());
        saida.append("\n");
        Method[] lsMetodos = this.getClass().getMethods();
        for (int i = 0; i < lsMetodos.length; ++i) {
            Method metodo = lsMetodos[i];
            if (metodo.getParameterTypes().length != 0 || metodo.getReturnType().isPrimitive() || metodo.getName().equalsIgnoreCase("tostring")) continue;
            try {
                saida.append(metodo.getName() + ":" + metodo.invoke((Object)this, new Object[0]) + "\n");
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return saida.toString();
    }

    public boolean eCertificadoMaquina() {
        try {
            return this.getUsoAvancadoChave().indexOf("1.3.6.1.5.5.7.3.1") != -1;
        }
        catch (IOException e) {
            return false;
        }
    }

    public byte[] assinar(Hash algoritmo, byte[] mensagemOriginal, char[] pin, boolean flagAnexaCadeiaCertificados, boolean flagAnexaMensagemOriginal, Window janelaPai) throws ErroAoGerarPKCS7 {
        byte[] assinatura;
        char[] senha = this._reutilizarSenha ? this._ultimaSenhaFornecida : pin;
        try {
            assinatura = this.assinaPKCS7(algoritmo, mensagemOriginal, senha, flagAnexaCadeiaCertificados, flagAnexaMensagemOriginal);
        }
        catch (ErroAoGerarPKCS7 e) {
            if (this.getKeystore().getType().equals(TipoKeyStore.SUNMSCAPI.toString())) {
                throw e;
            }
            DialogoSenha leitorSenha = JDialog.class.isInstance(janelaPai) ? new DialogoSenha((JDialog)janelaPai) : new DialogoSenha((JFrame)janelaPai);
            senha = leitorSenha.lerSenha(Recursos.getString("LoginContainer.titulo"), Recursos.getString("LoginContainer.mensagem"));
            assinatura = this.assinaPKCS7(Hash.MD5, mensagemOriginal, senha, true, true);
        }
        this._ultimaSenhaFornecida = senha;
        return assinatura;
    }

    public byte[] assinar(Hash algoritmo, File arquivo, long tamanhoArquivo, char[] pin, boolean flagAnexaCadeiaCertificados, boolean flagAnexaMensagemOriginal, Window janelaPai) throws JSignException {
        byte[] assinatura;
        char[] senha = this._reutilizarSenha ? this._ultimaSenhaFornecida : pin;
        try {
            assinatura = this.assinaPKCS7(algoritmo, arquivo, tamanhoArquivo, senha, flagAnexaCadeiaCertificados, flagAnexaMensagemOriginal);
        }
        catch (JSignException e) {
            if (this.getKeystore().getType().equals(TipoKeyStore.SUNMSCAPI.toString())) {
                throw e;
            }
            DialogoSenha leitorSenha = JDialog.class.isInstance(janelaPai) ? new DialogoSenha((JDialog)janelaPai) : new DialogoSenha((JFrame)janelaPai);
            senha = leitorSenha.lerSenha(Recursos.getString("LoginContainer.titulo"), Recursos.getString("LoginContainer.mensagem"));
            assinatura = this.assinaPKCS7(algoritmo, arquivo, tamanhoArquivo, senha, flagAnexaCadeiaCertificados, flagAnexaMensagemOriginal);
        }
        this._ultimaSenhaFornecida = senha;
        return assinatura;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] assinarHash(Hash algoritmo, File arquivo, long tamanhoArquivo, char[] pin, boolean flagAnexaCadeiaCertificados, boolean flagAnexaMensagemOriginal, ControleProgresso progresso, Window janelaPai) throws JSignException, NoSuchAlgorithmException, IOException {
        byte[] assinatura;
        progresso.setMinimo(0L);
        progresso.setMaximo(arquivo.length());
        FileInputStreamParcial in = new FileInputStreamParcial(arquivo, tamanhoArquivo);
        byte[] hash = algoritmo.geraDigest(in, progresso);
        if (progresso.foiCancelado()) {
            progresso.tarefaTerminou();
            throw new JSignExcecaoCancelamento("Assinatura digital cancelada");
        }
        char[] senha = this._reutilizarSenha ? this._ultimaSenhaFornecida : pin;
        try {
            assinatura = this.assinaPKCS7(algoritmo, hash, senha, flagAnexaCadeiaCertificados, flagAnexaMensagemOriginal);
        }
        catch (JSignException e) {
            if (progresso.foiCancelado()) {
                throw new JSignExcecaoCancelamento("Assinatura digital cancelada");
            }
            if (this.getKeystore().getType().equals(TipoKeyStore.SUNMSCAPI.toString())) {
                throw e;
            }
            DialogoSenha leitorSenha = JDialog.class.isInstance(janelaPai) ? new DialogoSenha((JDialog)janelaPai) : new DialogoSenha((JFrame)janelaPai);
            senha = leitorSenha.lerSenha(Recursos.getString("LoginContainer.titulo"), Recursos.getString("LoginContainer.mensagem"));
            assinatura = this.assinaPKCS7(algoritmo, hash, senha, flagAnexaCadeiaCertificados, flagAnexaMensagemOriginal);
        }
        finally {
            progresso.tarefaTerminou();
        }
        this._ultimaSenhaFornecida = senha;
        return assinatura;
    }

    public void setReutilizarSenha(boolean reutilizarSenha) {
        this._reutilizarSenha = reutilizarSenha;
    }

    static {
        MENSAGENS_ERRO_ASSINATURA.put(IOException.class, "Erro ao assinar digitalmente. Falha ao codificar a assinatura digital.");
        MENSAGENS_ERRO_ASSINATURA.put(CMSException.class, "Erro ao assinar digitalmente. Falha ao assinar os dados.");
        MENSAGENS_ERRO_ASSINATURA.put(KeyStoreException.class, "Erro ao assinar digitalmente. Falha ao acessar o certificado digital. Verifique se o certificado consegue ser acessado por outros programas.");
        MENSAGENS_ERRO_ASSINATURA.put(UnrecoverableKeyException.class, "Erro ao assinar digitalmente. Falha ao acessar a chave privada do certificado digital. Provavelmente a senha informada est\u00e1 errada.");
        MENSAGENS_ERRO_ASSINATURA.put(NoSuchAlgorithmException.class, "Erro ao assinar digitalmente. Um algoritmo necess\u00e1rio para usar o certificado digital n\u00e3o \u00e9 suportado.");
        MENSAGENS_ERRO_ASSINATURA.put(CertificateException.class, "Erro ao assinar digitalmente. Falha ao acessar o certificado. Verifique se o certificado funciona corretamente com outros programas.");
        MENSAGENS_ERRO_ASSINATURA.put(InvalidAlgorithmParameterException.class, "Erro ao assinar digitalmente. O algoritmo de assinatura n\u00e3o \u00e9 suportado pelo programa.");
        MENSAGENS_ERRO_ASSINATURA.put(CertStoreException.class, "Erro ao assinar digitalmente. Falha ao acessar o cerificado digital. Verifique se o certificado consegue ser usado por outros programas.");
        MENSAGENS_ERRO_ASSINATURA.put(NoSuchProviderException.class, "Erro ao assinar digitalmente. Provedor de fun\u00e7\u00f5es criptogr\u00e1ficas n\u00e3o encontrado. Falha interna grave. Reinstale a aplica\u00e7\u00e3o.");
    }
}

